/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.eclipse.persistency.project_creation;

import net.ssehub.easy.producer.eclipse.model.ProductLineProject;
import net.ssehub.easy.producer.eclipse.persistency.project_creation.AbstractProjectCreator;
import net.ssehub.easy.producer.eclipse.persistency.project_creation.DerivedProjectCreator;
import net.ssehub.easy.producer.eclipse.persistency.project_creation.IEASyProjectConfigurator;
import net.ssehub.easy.producer.eclipse.persistency.project_creation.InvalidProjectnameException;
import net.ssehub.easy.producer.eclipse.persistency.project_creation.NewProjectCreator;
import net.ssehub.easy.producer.eclipse.persistency.project_creation.ProjectAlreadyExistsException;
import net.ssehub.easy.producer.eclipse.persistency.project_creation.ProjectCreationException;
import net.ssehub.easy.producer.eclipse.persistency.project_creation.ValidProjectNameType;
import net.ssehub.easy.varModel.validation.IvmlIdentifierCheck;
import org.eclipse.core.resources.ResourcesPlugin;

public class EASyProjectCreatorFactory {
    public static ValidProjectNameType isValidProjectName(String name) {
        ValidProjectNameType status = ValidProjectNameType.VALID;
        if (name == null || "".equals(name)) {
            status = ValidProjectNameType.INVALID_IDENTIFIER;
        } else if (ResourcesPlugin.getWorkspace().getRoot().getProject(name).exists()) {
            status = ValidProjectNameType.ALREADY_EXISTS;
        } else if (!IvmlIdentifierCheck.isValidIdentifier(name)) {
            status = ValidProjectNameType.INVALID_IDENTIFIER;
        }
        return status;
    }

    public static ValidProjectNameType isValidProjectName(String name, boolean lazy) {
        ValidProjectNameType status = EASyProjectCreatorFactory.isValidProjectName(name);
        if (lazy && ValidProjectNameType.ALREADY_EXISTS == status) {
            status = ValidProjectNameType.VALID;
        }
        return status;
    }

    public static ProductLineProject createNewProject(String name, String predecessorID, boolean lazy, IEASyProjectConfigurator ... configurators) throws ProjectCreationException {
        ValidProjectNameType valid = EASyProjectCreatorFactory.isValidProjectName(name, lazy);
        switch (valid) {
            case VALID: {
                break;
            }
            case ALREADY_EXISTS: {
                throw new ProjectAlreadyExistsException();
            }
            case INVALID_IDENTIFIER: {
                throw new InvalidProjectnameException();
            }
            default: {
                new ProjectCreationException(null);
            }
        }
        AbstractProjectCreator creator = null;
        creator = null == predecessorID ? new NewProjectCreator(name, lazy, configurators) : new DerivedProjectCreator(name, predecessorID, lazy, configurators);
        return creator.createEASyProject();
    }
}

