/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.core.impl;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.reasoning.core.reasoner.Message;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.reasoning.core.reasoner.ValueCreationResult;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

public class ReasonerHelper {
    public static ValueCreationResult createValue(Configuration cfg, AbstractVariable var, IDatatype type, ReasonerConfiguration reasonerConfiguration, ProgressObserver observer) {
        IDatatype t = null != var ? var.getType() : type;
        List<String> messages = null;
        Value val = null;
        if (null == t) {
            messages = ReasonerHelper.appendMessage(messages, "No variable or type given (null).");
        } else {
            try {
                val = ValueFactory.createValue(t, new Object[0]);
            }
            catch (ValueDoesNotMatchTypeException e) {
                messages = ReasonerHelper.appendMessage(messages, e.getMessage());
            }
        }
        Project p = new Project("*");
        DecisionVariableDeclaration pVar = new DecisionVariableDeclaration("*", type, p);
        IDecisionVariable res = null;
        try {
            pVar.setValue(new ConstantValue(val));
            p.add(pVar);
            Configuration c = new Configuration(p);
            res = c.getDecision(pVar);
        }
        catch (CSTSemanticException e) {
            ReasonerHelper.appendMessage(messages, e);
        }
        catch (ValueDoesNotMatchTypeException e) {
            ReasonerHelper.appendMessage(messages, e);
        }
        ValueCreationResult result = new ValueCreationResult(res);
        if (null != messages) {
            for (int m = 0; m < messages.size(); ++m) {
                result.addMessage(new Message(messages.get(m), null, Status.ERROR));
            }
        }
        return result;
    }

    private static List<String> appendMessage(List<String> messages, Throwable th) {
        return ReasonerHelper.appendMessage(messages, th.getMessage());
    }

    private static List<String> appendMessage(List<String> messages, String message) {
        if (null == messages) {
            messages = new ArrayList<String>();
        }
        messages.add(message);
        return messages;
    }
}

