/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.core.reasoner;

import java.io.StringWriter;
import java.io.Writer;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.management.CommentResource;
import net.ssehub.easy.varModel.management.ModelCommentsPersistencer;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.datatypes.Operation;
import net.ssehub.easy.varModel.persistency.IVMLWriter;

public class CommentResourceVisitor
extends IVMLWriter {
    private CommentResource comments;

    private CommentResourceVisitor(Writer out, CommentResource comments) {
        super(out);
        this.setWriter(out);
        this.comments = comments;
    }

    public static String visit(IModelElement elt, CommentResource comments) {
        StringWriter out = new StringWriter();
        elt.accept(new CommentResourceVisitor((Writer)out, comments));
        return out.toString();
    }

    @Override
    protected void appendOCLFeatureCall(OCLFeatureCall call, Operation.FormattingHint hint) {
        String closing;
        String key = call.getOperation();
        if ("[]".equals(key)) {
            key = key + "[";
            closing = "]";
        } else {
            key = key + "(";
            closing = ")";
        }
        for (int i = 0; i <= call.getParameterCount(); ++i) {
            if (i > 0) {
                key = key + ",";
            }
            key = key + ".";
        }
        if (null != this.getComment(key = key + closing)) {
            String[] args = new String[call.getParameterCount() + 1];
            int pos = 0;
            Writer old = this.getWriter();
            StringWriter tmp = new StringWriter();
            this.setWriter(tmp);
            call.getOperand().accept(this);
            args[pos++] = tmp.toString();
            for (int i = 0; i < call.getParameterCount(); ++i) {
                tmp = new StringWriter();
                this.setWriter(tmp);
                call.getParameter(i).accept(this);
                args[pos++] = tmp.toString();
            }
            this.setWriter(old);
            this.appendComment(key, args);
        } else {
            super.appendOCLFeatureCall(call, hint);
        }
    }

    @Override
    public void visitConstraint(Constraint constraint) {
        if (!this.appendComment(ModelCommentsPersistencer.getKey(constraint), null)) {
            Writer old = this.getWriter();
            StringWriter tmp = new StringWriter();
            this.setWriter(tmp);
            constraint.getConsSyntax().accept(this);
            this.setWriter(old);
            String tmpStr = tmp.toString();
            if (tmpStr.length() == 0) {
                super.visitConstraint(constraint);
            } else {
                this.appendOutput(tmpStr);
            }
        }
    }

    @Override
    public void visitVariable(Variable variable) {
        AbstractVariable var = variable.getVariable();
        if (!this.appendComment(var.getQualifiedName(), null)) {
            super.visitVariable(variable);
        }
    }

    private String getComment(String key) {
        String result = null;
        if (key != null && null != this.comments) {
            result = this.comments.get(key);
        }
        return result;
    }

    private boolean appendComment(String key, String[] args) {
        boolean done = false;
        String comment = this.getComment(key);
        if (null != comment) {
            if (null != args) {
                for (int i = 0; i < args.length; ++i) {
                    comment = comment.replace("{" + i + "}", args[i]);
                }
            }
            this.appendOutput(comment);
            done = true;
        }
        return done;
    }

    @Override
    public void visitCompoundAccess(CompoundAccess access) {
        IVMLWriter bypassWriter = IVMLWriter.getInstance(new StringWriter());
        access.accept(bypassWriter);
        String key = bypassWriter.getWriter().toString();
        IVMLWriter.releaseInstance(bypassWriter);
        if (!this.appendComment(key, null)) {
            super.visitCompoundAccess(access);
        }
    }
}

