/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.core.reasoner;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.ssehub.easy.varModel.model.Constraint;

public class ConstraintList
implements Iterable<Constraint> {
    protected transient int modCount = 0;
    private int size = 0;
    private Node first;
    private Node last;
    private transient IModificationListener listener;

    public ConstraintList() {
        this(null);
    }

    protected ConstraintList(IModificationListener listener) {
        this.setModificationListener(listener);
    }

    protected void setModificationListener(IModificationListener listener) {
        this.listener = listener;
    }

    public boolean contains(Constraint constraint) {
        return this.indexOf(constraint) >= 0;
    }

    public int indexOf(Constraint constraint) {
        int index = 0;
        int result = -1;
        if (null == constraint) {
            Node x = this.first;
            while (x != null) {
                if (x.constraint == null) {
                    result = index;
                    break;
                }
                ++index;
                x = x.next;
            }
        } else {
            Node x = this.first;
            while (x != null) {
                if (constraint == x.constraint) {
                    result = index;
                    break;
                }
                ++index;
                x = x.next;
            }
        }
        return result;
    }

    public Constraint getFirst() {
        Node f = this.first;
        if (f == null) {
            throw new NoSuchElementException();
        }
        return f.constraint;
    }

    public Constraint getLast() {
        Node l = this.last;
        if (l == null) {
            throw new NoSuchElementException();
        }
        return l.constraint;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void add(Constraint constraint) {
        this.linkLast(constraint);
    }

    public void addFirst(Constraint constraint) {
        this.linkFirst(constraint);
    }

    public void addLast(Constraint constraint) {
        this.linkLast(constraint);
    }

    public void clear() {
        Node x = this.first;
        while (null != x) {
            Node next = x.next;
            if (null != this.listener) {
                this.listener.notifyRemoved(x.constraint, x);
            }
            x.constraint = null;
            x.next = null;
            x.prev = null;
            x = next;
        }
        this.first = null;
        this.last = null;
        this.size = 0;
        if (null != this.listener) {
            this.listener.notifyRemovedAll();
        }
        ++this.modCount;
    }

    public boolean addAll(Collection<? extends Constraint> constraints) {
        return this.addAll(this.size, constraints);
    }

    public boolean addAll(int index, Collection<? extends Constraint> constraints) {
        boolean result;
        this.checkPositionIndex(index);
        int numNew = constraints.size();
        if (0 == numNew) {
            result = false;
        } else {
            Constraint[] cArray = new Constraint[numNew];
            constraints.toArray(cArray);
            this.addAll(index, cArray);
            result = true;
        }
        return result;
    }

    private void addAll(int index, Constraint[] cArray) {
        Node pred;
        Node succ;
        if (index == this.size) {
            succ = null;
            pred = this.last;
        } else {
            succ = this.node(index);
            pred = succ.prev;
        }
        for (Constraint c : cArray) {
            Node newNode = new Node(pred, c, null);
            if (pred == null) {
                this.first = newNode;
            } else {
                pred.next = newNode;
            }
            pred = newNode;
            if (null == this.listener) continue;
            this.listener.notifyAdded(c, newNode);
        }
        if (succ == null) {
            this.last = pred;
        } else {
            pred.next = succ;
            succ.prev = pred;
        }
        this.size += cArray.length;
        ++this.modCount;
    }

    public boolean addAll(ConstraintList constraints) {
        return this.addAll(constraints, false);
    }

    public boolean addAll(ConstraintList constraints, boolean clear) {
        return this.addAll(this.size, constraints, clear);
    }

    public boolean addAll(int index, ConstraintList constraints) {
        return this.addAll(index, constraints, false);
    }

    public boolean addAll(int index, ConstraintList constraints, boolean clear) {
        boolean result;
        this.checkPositionIndex(index);
        int numNew = constraints.size();
        if (0 == numNew) {
            result = false;
        } else {
            if (!clear) {
                this.addAll(index, constraints.toArray());
            } else {
                if (null == this.first) {
                    this.first = constraints.first;
                    this.last = constraints.last;
                } else {
                    Node pred;
                    Node succ;
                    if (index == this.size) {
                        succ = null;
                        pred = this.last;
                    } else {
                        succ = this.node(index);
                        pred = succ.prev;
                    }
                    constraints.first.prev = pred;
                    pred.next = constraints.first;
                    if (null == succ) {
                        this.last = constraints.last;
                    } else {
                        succ.prev = constraints.last;
                        constraints.last.next = succ;
                    }
                }
                if (null != this.listener) {
                    Node x = constraints.first;
                    while (null != x) {
                        this.listener.notifyAdded(x.constraint, x);
                        x = x.next;
                    }
                }
                this.size += constraints.size;
                constraints.first = null;
                constraints.last = null;
                constraints.size = 0;
                ++constraints.modCount;
                if (null != constraints.listener) {
                    constraints.listener.notifyRemovedAll();
                }
                ++this.modCount;
            }
            result = true;
        }
        return result;
    }

    public Constraint[] toArray() {
        Constraint[] result = new Constraint[this.size];
        int index = 0;
        Node x = this.first;
        while (x != null) {
            result[index] = x.constraint;
            ++index;
            x = x.next;
        }
        return result;
    }

    public void toCollection(Collection<Constraint> collection) {
        Node x = this.first;
        while (x != null) {
            collection.add(x.constraint);
            x = x.next;
        }
    }

    public Constraint pop() {
        return this.removeFirst();
    }

    public Constraint removeFirst() {
        Node f = this.first;
        if (f == null) {
            throw new NoSuchElementException();
        }
        return this.unlinkFirst(f);
    }

    public Constraint removeLast() {
        Node l = this.last;
        if (l == null) {
            throw new NoSuchElementException();
        }
        return this.unlinkLast(l);
    }

    @Override
    public Iterator<Constraint> iterator() {
        return new Iterator<Constraint>(){
            private Node last = null;
            private Node cursor = ConstraintList.access$400(ConstraintList.this);
            private int expectedModCount;
            {
                this.expectedModCount = ConstraintList.this.modCount;
            }

            @Override
            public boolean hasNext() {
                return this.cursor != null;
            }

            @Override
            public Constraint next() {
                this.last = this.cursor;
                if (null == this.cursor) {
                    throw new NoSuchElementException();
                }
                Constraint result = this.cursor.constraint;
                this.cursor = this.cursor.next;
                return result;
            }

            @Override
            public void remove() {
                if (null == this.last) {
                    throw new IllegalStateException();
                }
                this.checkForComodification();
                ConstraintList.this.unlink(this.last);
                this.last = null;
                this.expectedModCount = ConstraintList.this.modCount;
            }

            final void checkForComodification() {
                if (ConstraintList.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }

    public boolean removeAll(Collection<? extends Constraint> constraints) {
        Objects.requireNonNull(constraints);
        boolean modified = false;
        Iterator<Constraint> it = this.iterator();
        while (it.hasNext()) {
            if (!constraints.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    private void linkFirst(Constraint constraint) {
        Node newNode;
        Node f = this.first;
        this.first = newNode = new Node(null, constraint, f);
        if (null == f) {
            this.last = newNode;
        } else {
            f.prev = newNode;
        }
        ++this.size;
        ++this.modCount;
        if (null != this.listener) {
            this.listener.notifyAdded(constraint, newNode);
        }
    }

    private void linkLast(Constraint constraint) {
        Node newNode;
        Node l = this.last;
        this.last = newNode = new Node(l, constraint, null);
        if (null == l) {
            this.first = newNode;
        } else {
            l.next = newNode;
        }
        ++this.size;
        ++this.modCount;
        if (null != this.listener) {
            this.listener.notifyAdded(constraint, newNode);
        }
    }

    private Constraint unlinkFirst(Node node) {
        Constraint constraint = node.constraint;
        Node next = node.next;
        node.constraint = null;
        node.next = null;
        this.first = next;
        if (next == null) {
            this.last = null;
        } else {
            next.prev = null;
        }
        --this.size;
        ++this.modCount;
        if (null != this.listener) {
            this.listener.notifyRemoved(constraint, node);
        }
        return constraint;
    }

    private Constraint unlinkLast(Node node) {
        Constraint constraint = node.constraint;
        Node prev = node.prev;
        node.constraint = null;
        node.prev = null;
        this.last = prev;
        if (prev == null) {
            this.first = null;
        } else {
            prev.next = null;
        }
        --this.size;
        ++this.modCount;
        if (null != this.listener) {
            this.listener.notifyRemoved(constraint, node);
        }
        return constraint;
    }

    Constraint unlink(Node node) {
        Constraint constraint = node.constraint;
        Node next = node.next;
        Node prev = node.prev;
        if (prev == null) {
            this.first = next;
        } else {
            prev.next = next;
            node.prev = null;
        }
        if (next == null) {
            this.last = prev;
        } else {
            next.prev = prev;
            node.next = null;
        }
        node.constraint = null;
        --this.size;
        ++this.modCount;
        if (null != this.listener) {
            this.listener.notifyRemoved(constraint, node);
        }
        return constraint;
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size;
    }

    private boolean isPositionIndex(int index) {
        return index >= 0 && index <= this.size;
    }

    private void checkPositionIndex(int index) {
        if (!this.isPositionIndex(index)) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private Node node(int index) {
        Node result;
        if (index < this.size >> 1) {
            result = this.first;
            for (int i = 0; i < index; ++i) {
                result = result.next;
            }
        } else {
            result = this.last;
            for (int i = this.size - 1; i > index; --i) {
                result = result.prev;
            }
        }
        return result;
    }

    public String toString() {
        String result = "[";
        Node x = this.first;
        while (x != null) {
            result = result + x.constraint;
            if (x.next != null) {
                result = result + ", ";
            }
            x = x.next;
        }
        result = result + "]";
        return result;
    }

    static /* synthetic */ Node access$400(ConstraintList x0) {
        return x0.first;
    }

    protected static class Node {
        private Constraint constraint;
        private Node next;
        private Node prev;

        private Node(Node prev, Constraint constraint, Node next) {
            this.constraint = constraint;
            this.next = next;
            this.prev = prev;
        }
    }

    protected static interface IModificationListener {
        public void notifyAdded(Constraint var1, Node var2);

        public void notifyRemoved(Constraint var1, Node var2);

        public void notifyRemovedAll();
    }
}

