/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.core.reasoner;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.reasoning.core.reasoner.Message;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;

public abstract class IUpgrader {
    private static final String PROTOCOL_REFERENCE = "reference:";
    private static final String PROTOCOL_FILE = "file:";
    private URI source;
    private String bundleLocation;
    private File dest;
    private Map<String, String> files;
    private String marker;
    private ProgressObserver observer;
    private long timeStamp = System.currentTimeMillis();

    protected IUpgrader(URI source, String dest, Map<String, String> files, String marker, ProgressObserver observer) {
        this.source = source;
        this.bundleLocation = dest;
        this.dest = IUpgrader.bundleLocationToFile(dest);
        this.files = files;
        this.marker = marker;
    }

    public static String toBundleLocation(File file) throws MalformedURLException {
        return PROTOCOL_REFERENCE + file.toURI().toURL().toString();
    }

    public static File bundleLocationToFile(String location) {
        File result = null;
        if (null != location && location.startsWith(PROTOCOL_REFERENCE)) {
            String part = location.substring(PROTOCOL_REFERENCE.length());
            if (part.startsWith(PROTOCOL_FILE)) {
                part = part.substring(PROTOCOL_FILE.length());
            }
            if (!(result = new File(part)).isAbsolute()) {
                String eLocation = System.getProperty("eclipse.home.location");
                if (eLocation.startsWith(PROTOCOL_FILE)) {
                    eLocation = eLocation.substring(PROTOCOL_FILE.length());
                }
                result = new File(eLocation, part);
            }
        }
        if (null == result) {
            EASyLoggerFactory.EASyLogger logger = EASyLoggerFactory.INSTANCE.getLogger(IUpgrader.class, "net.ssehub.easy.reasoning.core");
            logger.error("unknown location type" + location);
        }
        return result;
    }

    public ReasoningResult upgrade() {
        ReasoningResult result = new ReasoningResult();
        if (null == this.dest) {
            result.addMessage(new Message("location '" + this.bundleLocation + "'cannot be determined", null, Status.ERROR));
        } else if (!this.doUpgrade(result)) {
            result.addMessage(new Message("cannot handle '" + this.getSource() + "'", null, Status.ERROR));
        }
        return result;
    }

    protected abstract boolean doUpgrade(ReasoningResult var1);

    protected URI getSource() {
        return this.source;
    }

    protected String getMappedFile(String input) {
        return this.files.get(input);
    }

    protected String getMarker() {
        return this.marker;
    }

    protected ProgressObserver getObserver() {
        return this.observer;
    }

    protected Iterator<Map.Entry<String, String>> allFileMappings() {
        return this.files.entrySet().iterator();
    }

    protected File obtainTargetFile(String targetName) {
        File result = new File(this.dest, targetName);
        if (result.exists()) {
            int pos = targetName.lastIndexOf(46);
            String destName = pos < 0 ? targetName + "." + this.timeStamp : targetName.substring(0, pos) + "." + this.timeStamp + targetName.substring(pos);
            File destFile = new File(this.dest, destName);
            result.renameTo(destFile);
        }
        return result;
    }

    protected void error(ReasoningResult result, IOException ex) {
        result.addMessage(new Message("I/O problem: " + ex.getMessage(), null, Status.ERROR));
    }

    protected void copy(File source, File target) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(source);
            out = new FileOutputStream(target);
            in.getChannel().transferTo(0L, source.length(), out.getChannel());
            out.close();
            out = null;
            in.close();
        }
        catch (IOException e) {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }
}

