/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.core.reasoner;

import net.ssehub.easy.reasoning.core.frontend.ReasonerFrontend;
import net.ssehub.easy.reasoning.core.reasoner.AttributeValues;
import net.ssehub.easy.reasoning.core.reasoner.Message;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerDescriptor;

public class ReasonerConfiguration {
    public static final IAdditionalInformationLogger ADDITIONAL_INFO_LOG_SYSOUT = new IAdditionalInformationLogger(){

        @Override
        public void info(String text) {
            System.out.println(text);
        }

        @Override
        public void info(Message msg) {
            System.out.println(msg);
        }
    };
    public static final IAdditionalInformationLogger ADDITIONAL_INFO_LOG_NONE = new IAdditionalInformationLogger(){

        @Override
        public void info(String text) {
        }

        @Override
        public void info(Message msg) {
        }
    };
    private AttributeValues attributeValues;
    private int timeout;
    private ReasonerDescriptor defaultReasoner;
    private boolean customMessages;
    private boolean incremental;
    private IAdditionalInformationLogger logger = ADDITIONAL_INFO_LOG_SYSOUT;

    public ReasonerConfiguration() {
        this(false);
    }

    public ReasonerConfiguration(boolean defParamValue) {
        this.timeout = ReasonerFrontend.getInstance().getTimeout();
        this.customMessages = defParamValue;
    }

    public ReasonerConfiguration setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getTimeout(ReasonerConfiguration configuration) {
        int result = 0;
        if (null != configuration) {
            this.timeout = configuration.getTimeout();
        }
        if (result <= 0) {
            result = ReasonerFrontend.getInstance().getTimeout();
        }
        return result;
    }

    public ReasonerConfiguration setAttributeValues(AttributeValues attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    public AttributeValues getAttributeValues() {
        return this.attributeValues;
    }

    public static AttributeValues getAttributeValues(ReasonerConfiguration config) {
        AttributeValues result = null;
        if (null != config) {
            result = config.getAttributeValues();
        }
        return result;
    }

    public ReasonerConfiguration setDefaultReasoner(ReasonerDescriptor defaultReasoner) {
        this.defaultReasoner = defaultReasoner;
        return this;
    }

    public ReasonerDescriptor getDefaultResoner() {
        return this.defaultReasoner;
    }

    public ReasonerConfiguration enableCustomMessages() {
        this.customMessages = true;
        return this;
    }

    public ReasonerConfiguration disableCustomMessages() {
        this.customMessages = false;
        return this;
    }

    public boolean getCustomMessages() {
        return this.customMessages;
    }

    public IAdditionalInformationLogger getLogger() {
        return this.logger;
    }

    public ReasonerConfiguration setAdditionalInformationLogger(IAdditionalInformationLogger logger) {
        if (null != logger) {
            this.logger = logger;
        }
        return this;
    }

    public ReasonerConfiguration setRuntimeMode(boolean runtime) {
        this.incremental = runtime;
        return this;
    }

    public ReasonerConfiguration setIncrementalMode(boolean incremental) {
        this.incremental = incremental;
        return this;
    }

    public boolean isRuntimeMode() {
        return this.incremental;
    }

    public boolean isIncrementalMode() {
        return this.incremental;
    }

    public static interface IAdditionalInformationLogger {
        public void info(String var1);

        public void info(Message var1);
    }
}

