/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.core.reasoner;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.reasoning.core.reasoner.FileUpgrader;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;

public class ZipUpgrader
extends FileUpgrader {
    public ZipUpgrader(URI source, String dest, Map<String, String> files, String marker, ProgressObserver observer) {
        super(source, dest, files, marker, observer);
    }

    @Override
    protected boolean doUpgrade(ReasoningResult result) {
        boolean done = false;
        if ("zip".equalsIgnoreCase(this.getExtension())) {
            try {
                this.unpackZip(new ZipInputStream(this.getSource().toURL().openStream()));
                done = true;
            }
            catch (IOException e) {
                this.error(result, e);
            }
        }
        if (!done) {
            done = super.doUpgrade(result);
        }
        return done;
    }

    private void unpackZip(ZipInputStream zis) throws IOException {
        try {
            ZipEntry entry;
            do {
                String name;
                String mapped;
                if (null == (entry = zis.getNextEntry()) || null == (mapped = this.getMappedFile(name = entry.getName()))) continue;
                this.unpackEntryToInstallPath(zis, entry, mapped);
            } while (null != entry);
            zis.close();
        }
        catch (IOException e) {
            try {
                zis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    private void unpackEntryToInstallPath(ZipInputStream zis, ZipEntry entry, String targetName) throws IOException {
        int read = 0;
        byte[] buffer = new byte[1024];
        File dest = this.obtainTargetFile(targetName);
        FileOutputStream fos = new FileOutputStream(dest);
        while ((read = zis.read(buffer)) != -1) {
            fos.write(buffer, 0, read);
        }
        fos.close();
    }
}

