/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.sseReasoner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.Utils;
import net.ssehub.easy.reasoning.core.reasoner.AnnotationAssignmentConstraint;
import net.ssehub.easy.reasoning.core.reasoner.AttachedConstraint;
import net.ssehub.easy.reasoning.core.reasoner.ConstraintBase;
import net.ssehub.easy.reasoning.core.reasoner.ConstraintList;
import net.ssehub.easy.reasoning.core.reasoner.ConstraintVariableConstraint;
import net.ssehub.easy.reasoning.core.reasoner.DefaultConstraint;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.reasoning.sseReasoner.CheckInitializerVisitor;
import net.ssehub.easy.reasoning.sseReasoner.EvalVisitor;
import net.ssehub.easy.reasoning.sseReasoner.RescheduleValueChangeVisitor;
import net.ssehub.easy.reasoning.sseReasoner.functions.AbstractConstraintProcessor;
import net.ssehub.easy.reasoning.sseReasoner.functions.ConstraintFunctions;
import net.ssehub.easy.reasoning.sseReasoner.functions.DefaultValueTranslator;
import net.ssehub.easy.reasoning.sseReasoner.functions.FailedElementDetails;
import net.ssehub.easy.reasoning.sseReasoner.functions.FailedElements;
import net.ssehub.easy.reasoning.sseReasoner.functions.ScopeAssignments;
import net.ssehub.easy.reasoning.sseReasoner.model.ContextStack;
import net.ssehub.easy.reasoning.sseReasoner.model.ReasoningUtils;
import net.ssehub.easy.reasoning.sseReasoner.model.SubstitutionVisitor;
import net.ssehub.easy.reasoning.sseReasoner.model.TypeCache;
import net.ssehub.easy.reasoning.sseReasoner.model.VariablesInConstraintFinder;
import net.ssehub.easy.reasoning.sseReasoner.model.VariablesInNotSimpleAssignmentConstraintsFinder;
import net.ssehub.easy.reasoning.sseReasoner.model.VariablesMap;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IConfigurationElement;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.CSTUtils;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationVisitor;
import net.ssehub.easy.varModel.cstEvaluation.IResolutionListener;
import net.ssehub.easy.varModel.cstEvaluation.LocalDecisionVariable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.AnnotationVisitor;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IvmlException;
import net.ssehub.easy.varModel.model.ModelQuery;
import net.ssehub.easy.varModel.model.ModelVisitorAdapter;
import net.ssehub.easy.varModel.model.OperationDefinition;
import net.ssehub.easy.varModel.model.PartialEvaluationBlock;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.filter.FilterType;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.Value;

final class Resolver
implements IResolutionListener,
TypeCache.IConstraintTarget {
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(Resolver.class, "net.ssehub.easy.reasoning.sseReasoner");
    private static final int MODE_COMPOUND_REGISTER = 1;
    private static final int MODE_COMPOUND_TRANSLATE = 2;
    private static final int MODE_COMPOUND_NONE = -1;
    private ReasonerConfiguration reasonerConfig;
    private Configuration config;
    private boolean incremental = false;
    private boolean reuseInstance = false;
    private IAssignmentState assignmentState = AssignmentState.DERIVED;
    private boolean inRescheduling = false;
    private EvalVisitor evaluator = new EvalVisitor();
    private FailedElements failedElements = new FailedElements();
    private ScopeAssignments scopeAssignments = new ScopeAssignments();
    private VariablesMap variablesMap = new VariablesMap();
    private ReasonerState copiedState;
    private Stack<ConstraintBase> tmpBase = new Stack();
    private ConstraintBase constraintBase = new ConstraintBase();
    private DefaultConstraints defaultConstraints = DefaultConstraints.access$100(new DefaultConstraints());
    private ConstraintList topLevelConstraints = new ConstraintList();
    private ConstraintList otherConstraints = new ConstraintList();
    private List<Project> projects;
    private int constraintCounter = 0;
    private int variablesInConstraintsCounter = 0;
    private int reevaluationCounter = 0;
    private int variablesCounter = 0;
    private boolean hasTimeout = false;
    private boolean isRunning = false;
    private boolean wasStopped = false;
    private long translationTime = 0L;
    private long evaluationTime = 0L;
    private Project project;
    private transient Set<Project> doneProjects = new HashSet<Project>(20);
    private transient Set<IDecisionVariable> usedVariables = new HashSet<IDecisionVariable>(100);
    private transient SubstitutionVisitor substVisitor = new SubstitutionVisitor();
    private transient ContextStack contexts = new ContextStack();
    private transient VariablesInNotSimpleAssignmentConstraintsFinder simpleAssignmentFinder = new VariablesInNotSimpleAssignmentConstraintsFinder(this.variablesMap);
    private transient ConstraintTranslationVisitor projectVisitor = new ConstraintTranslationVisitor();
    private transient VariablesInConstraintFinder variablesFinder = new VariablesInConstraintFinder();
    private transient OtherConstraintsProcessor otherConstraintsProc = new OtherConstraintsProcessor();
    private transient CompoundAnnotationMapper annotationMapper = new CompoundAnnotationMapper();
    private transient RescheduleValueChangeVisitor rescheduler = new RescheduleValueChangeVisitor(this);
    private transient CheckInitializerVisitor initChecker = new CheckInitializerVisitor(this);
    private transient long endTimestamp;
    private transient boolean inTopLevelEvals = false;

    public Resolver(Configuration config, ReasonerConfiguration reasonerConfig) {
        this.reasonerConfig = reasonerConfig;
        this.config = config;
    }

    @Override
    public void localVariableCreated(LocalDecisionVariable var) {
        this.contexts.registerMapping(var.getDeclaration(), null);
    }

    @Override
    public void localVariableDisposed(LocalDecisionVariable var) {
        this.contexts.unregisterMapping(var.getDeclaration());
    }

    void translateValueTypeChange(IDecisionVariable variable, Value newValue, Value oldValue) {
        IDatatype newType = newValue.getType();
        IDatatype oldType = oldValue.getType();
        if (NullValue.INSTANCE == newValue) {
            this.cleanupConstraints(variable, true, null);
        } else if (NullValue.INSTANCE == oldValue) {
            boolean inc = this.setIncremental(true);
            this.translateDeclaration(variable.getDeclaration(), variable, null);
            this.setIncremental(inc);
        } else if (oldType.isAssignableFrom(newType)) {
            Set<Compound> types = ReasoningUtils.collectRefines(oldType, newType);
            this.contexts.setTypeExcludes(types);
            boolean inc = this.setIncremental(true);
            this.translateDeclaration(variable.getDeclaration(), variable, null);
            this.setIncremental(inc);
            this.contexts.setTypeExcludes(null);
            ReasoningUtils.SET_COMPOUND_POOL.releaseInstance(types);
        } else {
            Set<Compound> types = ReasoningUtils.collectRefines(oldType, newType);
            this.cleanupConstraints(variable, true, types);
            ReasoningUtils.SET_COMPOUND_POOL.releaseInstance(types);
        }
    }

    List<Constraint> cleanupConstraints(IDecisionVariable variable, boolean clear, Set<Compound> deleteFilter) {
        List<Constraint> constraints;
        IConfigurationElement iter = variable;
        do {
            constraints = iter instanceof IDecisionVariable ? this.variablesMap.getConstraintsForVariable(iter) : null;
            iter = iter.getParent();
        } while (null == constraints && null != iter);
        if (clear && null != constraints) {
            if (null != deleteFilter) {
                ArrayList<Constraint> toRemove = new ArrayList<Constraint>();
                for (int i = constraints.size() - 1; i >= 0; --i) {
                    Constraint cst = constraints.get(i);
                    Object attachedTo = cst.getAttachedTo();
                    if (null == attachedTo || !deleteFilter.contains(attachedTo)) continue;
                    constraints.remove(i);
                    toRemove.add(cst);
                }
                constraints = toRemove;
            }
            this.constraintBase.removeAll(constraints);
            for (int i = 0; i < this.tmpBase.size(); ++i) {
                ((ConstraintBase)this.tmpBase.get(i)).removeAll(constraints);
            }
            this.failedElements.removeProblemConstraints(constraints);
            this.simpleAssignmentFinder.acceptAndClear(constraints, this.config, false);
            this.variablesMap.removeAll(variable, constraints);
            constraints.clear();
        }
        return constraints;
    }

    void moveOtherConstraintsToConstraintBase(IDecisionVariable variable) {
        this.variablesMap.addAll(variable, this.otherConstraints);
        this.constraintBase.addAll(this.otherConstraints, true);
    }

    void reschedule(AbstractVariable declaration) {
        this.reschedule(this.variablesMap.getRelevantConstraints(declaration));
    }

    void reschedule(IDecisionVariable var) {
        this.reschedule(this.variablesMap.getConstraintsForVariable(var));
    }

    private void reschedule(Collection<Constraint> constraints) {
        if (null != constraints) {
            for (Constraint varConstraint : constraints) {
                if (this.constraintBase.contains(varConstraint)) continue;
                this.constraintBase.addLast(varConstraint);
            }
        }
    }

    @Override
    public void notifyResolved(IDecisionVariable compound, String slotName, IDecisionVariable resolved) {
        if (!resolved.isLocal()) {
            this.usedVariables.add(resolved);
        }
    }

    @Override
    public void notifyResolved(AbstractVariable declaration, IDecisionVariable resolved) {
        if (!resolved.isLocal()) {
            this.usedVariables.add(resolved);
        }
    }

    public void resolve() {
        this.isRunning = true;
        this.evaluator.init(this.config, null, false, this.rescheduler);
        this.evaluator.setResolutionListener(this);
        this.evaluator.setScopeAssignments(this.scopeAssignments);
        long l = this.endTimestamp = this.reasonerConfig.getTimeout() <= 0 ? -1L : System.currentTimeMillis() + (long)this.reasonerConfig.getTimeout();
        if (null == this.copiedState) {
            if (this.reuseInstance) {
                this.copiedState = new ReasonerState();
            }
            this.projects = Utils.discoverImports(this.config.getProject());
            for (int p = 0; !this.hasTimeout && !this.wasStopped && p < this.projects.size(); ++p) {
                this.project = this.projects.get(p);
                long start = System.currentTimeMillis();
                this.translateConstraints(this.project);
                this.evaluateConstraintBase(start, this.project);
            }
        } else {
            this.variablesMap.clear();
            this.variablesMap.copyFrom(this.copiedState.variablesMap);
            for (int p = 0; !this.hasTimeout && !this.wasStopped && p < this.copiedState.constraintBase.size(); ++p) {
                this.project = this.projects.get(p);
                long start = System.currentTimeMillis();
                this.constraintBase.addAll((ConstraintList)this.copiedState.constraintBase.get(p));
                this.evaluateConstraintBase(start, this.project);
            }
        }
        this.evaluator.clear();
        this.isRunning = false;
    }

    private void evaluateConstraintBase(long start, Project project) {
        long mid = System.currentTimeMillis();
        this.translationTime += mid - start;
        this.evaluateConstraints(project);
        long end = System.currentTimeMillis();
        this.evaluationTime += end - mid;
        this.config.freezeValues(project, FilterType.NO_IMPORTS);
        this.doneProjects.add(project);
    }

    private void evaluateConstraints(Project project) {
        this.scopeAssignments.clearScopeAssignments(project);
        this.evaluator.setDispatchScope(project);
        while (!this.constraintBase.isEmpty() && !this.wasStopped) {
            this.evaluateConstraint(this.constraintBase.removeFirst(), true);
            if (this.endTimestamp <= 0L || System.currentTimeMillis() <= this.endTimestamp) continue;
            this.hasTimeout = true;
            break;
        }
    }

    private void evaluateConstraint(Constraint constraint, boolean top) {
        ConstraintSyntaxTree cst = constraint.getConsSyntax();
        if (cst != null) {
            DefaultConstraint dCst;
            boolean evaluated = false;
            Constraint.IConstraintType type = constraint.getType();
            if ((type == Constraint.Type.DEFAULT || type == Constraint.Type.ANNOTATION_ASSIGNMENT) && this.doneProjects.contains(constraint.getProject())) {
                evaluated = true;
            }
            if (!evaluated && constraint instanceof DefaultConstraint && (dCst = (DefaultConstraint)constraint).getAttachedConstraintsSize() > 0) {
                ConstraintBase dflt = new ConstraintBase();
                dflt.addAll(dCst.getDefaultConstraints(), true);
                dflt.addAll(dCst.getDeferredDefaultConstraints(), true);
                this.tmpBase.push(this.constraintBase);
                this.constraintBase = dflt;
                while (!dflt.isEmpty() && !this.wasStopped) {
                    this.evaluateConstraint(dflt.removeFirst(), false);
                    if (this.endTimestamp <= 0L || System.currentTimeMillis() <= this.endTimestamp) continue;
                    this.hasTimeout = true;
                    break;
                }
                this.constraintBase = this.tmpBase.pop();
                this.evaluateConstraint(constraint, cst);
                evaluated = true;
            }
            if (!evaluated) {
                this.evaluateConstraint(constraint, cst);
            }
        }
    }

    private void evaluateConstraint(Constraint constraint, ConstraintSyntaxTree cst) {
        this.usedVariables.clear();
        this.scopeAssignments.setCurrentScope(constraint);
        this.evaluator.setAssignmentState(Constraint.Type.DEFAULT == constraint.getType() || Constraint.Type.ANNOTATION_ASSIGNMENT == constraint.getType() ? AssignmentState.DEFAULT : this.assignmentState);
        ++this.reevaluationCounter;
        this.evaluator.visit(cst);
        this.analyzeEvaluationResult(constraint);
        this.evaluator.clearIntermediary();
    }

    private void translateDerivedDatatypeConstraints(AbstractVariable decl, IDatatype type, DecisionVariableDeclaration localDecl, IModelElement parent, int refCounter, ConstraintSyntaxTree cAcc) {
        if (type instanceof DerivedDatatype) {
            AbstractVariable declaration;
            DerivedDatatype dType = (DerivedDatatype)type;
            int count = dType.getConstraintCount();
            DecisionVariableDeclaration dVar = dType.getTypeDeclaration();
            AbstractVariable abstractVariable = declaration = null == localDecl ? decl : localDecl;
            if (count > 0 && dVar != declaration) {
                this.substVisitor.setMappings(this.contexts);
                if (null != cAcc) {
                    this.substVisitor.addVariableMapping(dVar, cAcc);
                } else {
                    this.substVisitor.addVariableMapping(dVar, declaration, refCounter);
                }
                for (int i = 0; i < count; ++i) {
                    ConstraintSyntaxTree cst = dType.getConstraint(i).getConsSyntax();
                    if (null != localDecl) {
                        cst = ReasoningUtils.createContainerCall(new Variable(decl), Container.FORALL, cst, localDecl);
                    }
                    cst = this.substVisitor.accept(cst);
                    try {
                        cst.inferDatatype();
                        this.addConstraint(this.topLevelConstraints, new Constraint(cst, parent), true, null, null);
                        continue;
                    }
                    catch (CSTSemanticException e) {
                        LOGGER.exception(e);
                    }
                }
                this.substVisitor.clear();
            }
            this.translateDerivedDatatypeConstraints(decl, dType.getBasisType(), localDecl, parent, refCounter, null);
        } else if (type instanceof Reference) {
            this.translateDerivedDatatypeConstraints(decl, ((Reference)type).getType(), localDecl, parent, refCounter + 1, null);
        }
    }

    private void translateAnnotationDeclarations(AbstractVariable decl, IDecisionVariable variable, ConstraintSyntaxTree cAcc) {
        boolean isNested;
        ConstraintSyntaxTree acc = null == cAcc ? new Variable(decl) : cAcc;
        boolean bl = isNested = this.contexts.size() > 1 || TypeQueries.isCompound(DerivedDatatype.resolveToBasis(variable.getDeclaration().getType()));
        if (null != variable) {
            for (int i = 0; i < variable.getAttributesCount(); ++i) {
                IDecisionVariable att = variable.getAttribute(i);
                if (this.contexts.isKnownAnnotationAssignment(att.getDeclaration().getName())) continue;
                this.translateAnnotationDeclaration((Attribute)att.getDeclaration(), att, acc, isNested);
            }
        } else {
            for (int i = 0; i < decl.getAttributesCount(); ++i) {
                this.translateAnnotationDeclaration(decl.getAttribute(i), null, acc, isNested);
            }
        }
    }

    private void translateAnnotationDeclaration(Attribute decl, IDecisionVariable variable, ConstraintSyntaxTree cAcc, boolean qualifyAttribute) {
        ConstraintSyntaxTree attAcc = cAcc;
        if (null != cAcc && (qualifyAttribute || TypeQueries.isCompound(DerivedDatatype.resolveToBasis(decl.getType())))) {
            attAcc = new AttributeVariable(cAcc, decl);
        }
        this.translateDeclaration(decl, variable, attAcc);
    }

    private void translateDeclaration(AbstractVariable decl, IDecisionVariable var, ConstraintSyntaxTree cAcc) {
        IDatatype declType;
        ++this.variablesCounter;
        IDatatype actType = declType = decl.getType();
        ConstraintSyntaxTree defaultValue = this.incremental ? null : decl.getDefaultValue();
        AbstractVariable self = null;
        ConstraintSyntaxTree selfEx = null;
        DefaultConstraints tmpDflt = null;
        if (null != defaultValue) {
            actType = ReasoningUtils.inferTypeSafe(defaultValue, actType);
        }
        actType = DerivedDatatype.resolveToBasis(actType);
        int compoundMode = -1;
        boolean isCompound = TypeQueries.isCompound(actType);
        ConstraintSyntaxTree tCAcc = null;
        TypeCache.Entry tcEntry = null;
        if (isCompound) {
            self = decl;
            tCAcc = Resolver.checkTypeCast(declType, actType, decl, cAcc);
            compoundMode = this.translateCompoundDeclaration(decl, var, tCAcc, (Compound)actType, 1);
            tcEntry = this.contexts.getInConstruction(true);
        }
        if (!(null == defaultValue || decl.isAttribute() && decl.getParent() instanceof AttributeAssignment)) {
            if (cAcc instanceof CompoundAccess) {
                selfEx = ((CompoundAccess)cAcc).getCompoundExpression();
            }
            if (TypeQueries.isConstraint(declType)) {
                --this.variablesCounter;
                this.createConstraintVariableConstraint(defaultValue, selfEx, self, (IModelElement)decl, var);
            }
            if (!this.contexts.constraintVarOnly(false)) {
                ConstraintSyntaxTree acc;
                if (decl instanceof Attribute) {
                    Attribute attribute = (Attribute)decl;
                    acc = cAcc == null ? new Variable(attribute) : (cAcc instanceof AttributeVariable ? cAcc : new AttributeVariable(cAcc, attribute));
                } else {
                    acc = null != selfEx ? cAcc : new Variable(decl);
                }
                defaultValue = new OCLFeatureCall(acc, "=", DefaultValueTranslator.translateDefaultValueSafe(defaultValue));
                ReasoningUtils.inferTypeSafe(defaultValue, null);
                defaultValue = this.substituteVariables(defaultValue, selfEx, self, acc);
                tmpDflt = new DefaultConstraints();
                this.addDefaultConstraint(decl, defaultValue, tmpDflt, isCompound, var);
            }
            this.substVisitor.clear();
        }
        if (!this.incremental) {
            this.translateAnnotationDeclarations(decl, var, cAcc);
        }
        this.translateDerivedDatatypeConstraints(decl, declType, null, decl.getTopLevelParent(), 0, cAcc);
        if (isCompound) {
            this.contexts.setInConstruction(tcEntry);
            this.translateCompoundDeclaration(decl, var, tCAcc, (Compound)actType, compoundMode);
        } else if (TypeQueries.isContainer(actType)) {
            this.translateContainerDeclaration(decl, var, actType, cAcc);
        }
        this.transfer(null, tmpDflt, isCompound);
    }

    private void addDefaultConstraint(AbstractVariable decl, ConstraintSyntaxTree defaultValue, DefaultConstraints tmp, boolean enable, IDecisionVariable var) {
        try {
            ConstraintList targetCons = this.defaultConstraints.defaultConstraints;
            if (this.substVisitor.containsSelf() || ReasoningUtils.isOverriddenSlot(decl)) {
                targetCons = this.defaultConstraints.deferredDefaultConstraints;
            }
            DefaultConstraint c = this.transfer(new DefaultConstraint(defaultValue, (IModelElement)this.project), tmp, enable);
            this.addConstraint(targetCons, c, true, var, null);
        }
        catch (CSTSemanticException e) {
            LOGGER.exception(e);
        }
    }

    private DefaultConstraint transfer(DefaultConstraint constraint, DefaultConstraints tmp, boolean enable) {
        if (enable) {
            if (null != constraint) {
                tmp.defaultConstraints = this.defaultConstraints.defaultConstraints;
                tmp.deferredDefaultConstraints = this.defaultConstraints.deferredDefaultConstraints;
                this.defaultConstraints.initialize();
                constraint.setDefaultConstraints(this.defaultConstraints.defaultConstraints);
                constraint.setDeferredDefaultConstraints(this.defaultConstraints.deferredDefaultConstraints);
            } else if (null != tmp && null != tmp.defaultConstraints) {
                this.defaultConstraints.defaultConstraints = tmp.defaultConstraints;
                this.defaultConstraints.deferredDefaultConstraints = tmp.deferredDefaultConstraints;
            }
        }
        return constraint;
    }

    private static ConstraintSyntaxTree checkTypeCast(IDatatype declType, IDatatype actType, AbstractVariable decl, ConstraintSyntaxTree cAcc) {
        if (!TypeQueries.sameTypes(declType, actType)) {
            if (cAcc == null) {
                cAcc = new Variable(decl);
            }
            cAcc = ReasoningUtils.createAsTypeCast(cAcc, declType, actType);
        }
        return cAcc;
    }

    private void translateContainerDeclaration(AbstractVariable decl, IDecisionVariable var, IDatatype type, ConstraintSyntaxTree cAcc) {
        this.contexts.pushContext(decl, false);
        Container declType = (Container)type;
        IDatatype dContainedType = ReasoningUtils.getDeepestContainedType(declType);
        IDatatype dContainedBasisType = DerivedDatatype.resolveToBasis(dContainedType);
        ContainerValue val = ReasoningUtils.getRelevantValue(decl, var, this.incremental, ContainerValue.class);
        if (TypeQueries.isConstraint(dContainedBasisType)) {
            if (null != val) {
                this.createContainerConstraintValueConstraints(val, cAcc, null, decl, var);
            }
        } else if (TypeQueries.isCompound(dContainedBasisType)) {
            Set<Compound> used = ReasoningUtils.SET_COMPOUND_POOL.getInstance();
            if (null != val) {
                ReasoningUtils.getUsedCompoundTypes(val, used);
                Set<Compound> tmp = ReasoningUtils.SET_COMPOUND_POOL.getInstance();
                ReasoningUtils.purgeRefines(used, tmp);
                ReasoningUtils.SET_COMPOUND_POOL.releaseInstance(used);
                used = tmp;
            } else if (dContainedBasisType instanceof Compound) {
                used.add((Compound)dContainedBasisType);
            }
            for (Compound uType : used) {
                this.translateCompoundContainer(decl, uType, dContainedType, cAcc);
            }
            ReasoningUtils.SET_COMPOUND_POOL.releaseInstance(used);
        }
        if (dContainedType instanceof DerivedDatatype || dContainedType instanceof Reference) {
            this.translateDerivedDatatypeConstraints(decl, dContainedType, new DecisionVariableDeclaration("derivedType", dContainedType, null), this.project, 0, null);
        }
        this.contexts.popContext();
    }

    private void translateCompoundContainer(AbstractVariable decl, Compound type, IDatatype declaredContainedType, ConstraintSyntaxTree cAcc) {
        if (!this.contexts.alreadyProcessed(type)) {
            this.contexts.recordProcessed(type);
            DecisionVariableDeclaration localDecl = new DecisionVariableDeclaration("cmp" + this.contexts.size(), type, null);
            Variable localVar = new Variable(localDecl);
            Variable declVar = new Variable(decl);
            ConstraintSyntaxTree containerOp = null == cAcc ? declVar : cAcc;
            try {
                if (TypeQueries.isSequence(decl.getType())) {
                    containerOp = new OCLFeatureCall(containerOp, "asSet", new ConstraintSyntaxTree[0]);
                }
                if (ReasoningUtils.isNestedContainer(decl.getType())) {
                    containerOp = new OCLFeatureCall(containerOp, "flatten", new ConstraintSyntaxTree[0]);
                }
                if (!TypeQueries.sameTypes(type, declaredContainedType)) {
                    containerOp = new OCLFeatureCall(containerOp, "selectByKind", ReasoningUtils.createTypeValueConstant(type));
                }
            }
            catch (IvmlException e) {
                LOGGER.exception(e);
            }
            this.contexts.pushContext(null, containerOp, localDecl, true);
            this.registerCompoundMapping(type, localVar, declVar);
            this.translateCompoundContent(localDecl, null, type, localVar);
            this.contexts.popContext();
        }
    }

    private int translateCompoundDeclaration(AbstractVariable decl, IDecisionVariable variable, ConstraintSyntaxTree cAcc, Compound type, int mode) {
        int nextMode = -1;
        if (!this.contexts.alreadyProcessed(type) && 1 == mode) {
            ContextStack.TranslateMode tMode = this.contexts.getMappingMode(type);
            this.contexts.pushContext(decl, null == variable);
            this.contexts.recordAnnotationAssignments(type);
            if (tMode != ContextStack.TranslateMode.NOTHING) {
                if (!decl.isAttribute() && tMode != ContextStack.TranslateMode.TRANSFER) {
                    this.contexts.registerForTypeCache(type, decl);
                }
                this.contexts.transferTypeExcludes(type);
                if (tMode == ContextStack.TranslateMode.TRANSFER) {
                    this.contexts.transferToContext(type, decl);
                } else {
                    this.registerCompoundMapping(type, cAcc, new Variable(decl));
                }
            }
            nextMode = 2;
        }
        if (2 == mode) {
            if (!this.contexts.transferConstraints(type, this, variable, decl)) {
                this.translateCompoundContent(decl, variable, type, cAcc);
            }
            this.contexts.popContext(type);
            this.contexts.recordProcessed(type);
            nextMode = -1;
        }
        return nextMode;
    }

    private void registerCompoundMapping(Compound type, ConstraintSyntaxTree cAcc, Variable declVar) {
        this.registerCompoundSlotMapping(type, cAcc, declVar);
        this.annotationMapper.initialize(cAcc, declVar);
        try {
            this.annotationMapper.visitAnnotations(declVar.getVariable());
        }
        catch (IvmlException ivmlException) {
            // empty catch block
        }
        this.annotationMapper.clear();
    }

    private void registerCompoundSlotMapping(Compound type, ConstraintSyntaxTree cAcc, Variable declVar) {
        int n = type.getDeclarationCount();
        for (int i = 0; i < n; ++i) {
            DecisionVariableDeclaration nestedDecl = type.getDeclaration(i);
            ConstraintSyntaxTree acc = this.contexts.getLocalMapping(nestedDecl.getName());
            if (null == acc) {
                acc = null == cAcc ? new CompoundAccess(declVar, nestedDecl.getName()) : new CompoundAccess(cAcc, nestedDecl.getName());
            }
            this.contexts.registerMapping(nestedDecl, acc);
            int m = nestedDecl.getAttributesCount();
            for (int a = 0; a < m; ++a) {
                Attribute attr = nestedDecl.getAttribute(a);
                AttributeVariable aAcc = new AttributeVariable(acc, attr);
                this.contexts.registerMapping(attr, aAcc);
            }
        }
        n = type.getRefinesCount();
        for (int r = 0; r < n; ++r) {
            this.registerCompoundSlotMapping(type.getRefines(r), cAcc, declVar);
        }
    }

    private void translateCompoundContent(AbstractVariable decl, IDecisionVariable variable, Compound type, ConstraintSyntaxTree cAcc) {
        int i;
        int n;
        if (null != variable) {
            if (null != variable.getValue()) {
                cAcc = Resolver.checkTypeCast(decl.getType(), variable.getValue().getType(), decl, cAcc);
            }
            n = variable.getNestedElementsCount();
            for (i = 0; i < n; ++i) {
                IDecisionVariable nestedVar = variable.getNestedElement(i);
                AbstractVariable nestedDecl = nestedVar.getDeclaration();
                if (this.contexts.isElementTypeExcluded(nestedDecl.getParent())) continue;
                this.translateDeclaration(nestedDecl, nestedVar, this.getNestedAccessor(nestedDecl, cAcc));
            }
        } else {
            n = type.getInheritedElementCount();
            for (i = 0; i < n; ++i) {
                DecisionVariableDeclaration nestedDecl = type.getInheritedElement(i);
                if (this.contexts.isElementTypeExcluded(nestedDecl.getParent())) continue;
                this.translateDeclaration(nestedDecl, null, this.getNestedAccessor(nestedDecl, cAcc));
            }
        }
        if (!this.incremental) {
            for (int a = 0; a < type.getAssignmentCount(); ++a) {
                this.translateAnnotationAssignments(type.getAssignment(a), variable, null, cAcc);
            }
        }
        AbstractVariable self = null == cAcc ? decl : null;
        this.processCompoundEvals(type, cAcc, self, variable);
        this.otherConstraintsProc.setParameter(cAcc, self, variable);
        ConstraintFunctions.allCompoundConstraints(type, this.otherConstraintsProc, false, false, decl);
        this.otherConstraintsProc.clear();
    }

    private ConstraintSyntaxTree getNestedAccessor(AbstractVariable nestedDecl, ConstraintSyntaxTree cAcc) {
        return null == cAcc ? this.contexts.getMapping(nestedDecl) : new CompoundAccess(cAcc, nestedDecl.getName());
    }

    private void processCompoundEvals(Compound cmpType, ConstraintSyntaxTree selfEx, AbstractVariable self, IDecisionVariable variable) {
        if (!this.contexts.isTypeExcluded(cmpType)) {
            for (int r = 0; r < cmpType.getRefinesCount(); ++r) {
                this.processCompoundEvals(cmpType.getRefines(r), selfEx, self, variable);
            }
            for (int i = 0; i < cmpType.getModelElementCount(); ++i) {
                if (!(cmpType.getModelElement(i) instanceof PartialEvaluationBlock)) continue;
                PartialEvaluationBlock evalBlock = (PartialEvaluationBlock)cmpType.getModelElement(i);
                this.processEvalConstraints(evalBlock, selfEx, self, variable);
            }
        }
    }

    private void processEvalConstraints(PartialEvaluationBlock evalBlock, ConstraintSyntaxTree selfEx, AbstractVariable self, IDecisionVariable variable) {
        int i;
        for (i = 0; i < evalBlock.getNestedCount(); ++i) {
            this.processEvalConstraints(evalBlock.getNested(i), selfEx, self, variable);
        }
        for (i = 0; i < evalBlock.getEvaluableCount(); ++i) {
            if (!(evalBlock.getEvaluable(i) instanceof Constraint)) continue;
            Constraint evalConstraint = (Constraint)evalBlock.getEvaluable(i);
            ConstraintSyntaxTree evalCst = evalConstraint.getConsSyntax();
            ConstraintSyntaxTree cst = this.substituteVariables(evalCst, selfEx, self, null);
            try {
                Constraint constraint = new Constraint(cst, (IModelElement)this.project);
                this.addConstraint(this.otherConstraints, constraint, true, null, variable);
                continue;
            }
            catch (CSTSemanticException e) {
                LOGGER.exception(e);
            }
        }
    }

    void createContainerConstraintValueConstraints(ContainerValue val, ConstraintSyntaxTree selfEx, AbstractVariable self, IModelElement parent, IDecisionVariable nestedVariable) {
        for (int n = 0; n < val.getElementSize(); ++n) {
            Value cVal = val.getElement(n);
            ConstraintSyntaxTree cst = ReasoningUtils.getConstraintValueExpression(cVal);
            if (null != cst) {
                this.createConstraintVariableConstraint(cst, selfEx, self, parent, nestedVariable);
                continue;
            }
            if (!(cVal instanceof ContainerValue)) continue;
            this.createContainerConstraintValueConstraints((ContainerValue)cVal, selfEx, self, parent, nestedVariable);
        }
    }

    private void translateAnnotationAssignments(AttributeAssignment assignment, IDecisionVariable var, List<AttributeAssignment.Assignment> effectiveAssignments, ConstraintSyntaxTree compound) {
        ArrayList<AttributeAssignment.Assignment> assng = null == effectiveAssignments ? new ArrayList<AttributeAssignment.Assignment>() : effectiveAssignments;
        for (int d = 0; d < assignment.getAssignmentDataCount(); ++d) {
            assng.add(assignment.getAssignmentData(d));
        }
        HashSet<String> done = new HashSet<String>();
        for (int d = assng.size() - 1; d >= 0; --d) {
            AttributeAssignment.Assignment effectiveAssignment = (AttributeAssignment.Assignment)assng.get(d);
            String name = effectiveAssignment.getName();
            if (done.contains(name)) continue;
            done.add(name);
            for (int e = 0; e < assignment.getElementCount(); ++e) {
                IDecisionVariable v;
                DecisionVariableDeclaration aElt = assignment.getElement(e);
                String aEltName = aElt.getName();
                this.translateAnnotationAssignment(effectiveAssignment, aElt, compound);
                IDatatype aEltType = aElt.getType();
                if (!TypeQueries.isCompound(aEltType)) continue;
                Compound cmp = (Compound)aEltType;
                if (null != var && null != (v = var.getNestedElement(aEltName)) && null != v.getValue()) {
                    aEltType = v.getValue().getType();
                }
                ConstraintSyntaxTree acc = null != compound ? new CompoundAccess(compound, aEltName) : (null != var ? new CompoundAccess(new Variable(var.getDeclaration()), aEltName) : new Variable(aElt));
                for (int s = 0; s < cmp.getDeclarationCount(); ++s) {
                    DecisionVariableDeclaration slot = cmp.getDeclaration(s);
                    if (slot.getParent() instanceof AttributeAssignment) continue;
                    this.translateAnnotationAssignment(effectiveAssignment, slot, new CompoundAccess(acc, slot.getName()));
                }
            }
        }
        for (int a = 0; a < assignment.getAssignmentCount(); ++a) {
            this.translateAnnotationAssignments(assignment.getAssignment(a), var, assng, compound);
        }
    }

    private void translateAnnotationAssignment(AttributeAssignment.Assignment assignment, DecisionVariableDeclaration element, ConstraintSyntaxTree compound) {
        Attribute attrib = ModelQuery.findAttribute(element, assignment.getName());
        if (null != attrib) {
            ConstraintSyntaxTree origCompound = compound;
            if (null == compound) {
                compound = this.contexts.getMapping(element);
            }
            ConstraintSyntaxTree cst = compound == null ? new AttributeVariable(new Variable(element), attrib) : (null != origCompound ? new AttributeVariable(new CompoundAccess(compound, element.getName()), attrib) : new AttributeVariable(compound, attrib));
            cst = new OCLFeatureCall(cst, "=", assignment.getExpression());
            cst = this.substituteVariables(cst, compound, null, null);
            try {
                this.addConstraint(this.otherConstraints, new AnnotationAssignmentConstraint(cst, (IModelElement)this.project), false, null, null);
            }
            catch (CSTSemanticException e) {
                LOGGER.exception(e);
            }
        }
    }

    private void translateConstraints(Project project) {
        project.accept(this.projectVisitor);
        this.defaultConstraints.transfer(this.constraintBase, true);
        this.constraintBase.addAll(this.topLevelConstraints, true);
        this.constraintBase.addAll(this.otherConstraints, true);
        this.constraintCounter += this.constraintBase.size();
        this.variablesInConstraintsCounter += this.variablesMap.getDeclarationSize();
        if (null != this.copiedState) {
            ConstraintList copy = new ConstraintList();
            copy.addAll(this.constraintBase);
            this.copiedState.constraintBase.add(copy);
        }
        this.contexts.clear();
    }

    private void addConstraint(ConstraintList target, Constraint constraint, boolean checkForInitializers, IDecisionVariable variable, IDecisionVariable register) {
        ConstraintSyntaxTree cst = constraint.getConsSyntax();
        try {
            cst = this.contexts.composeExpression(cst);
            constraint.setConsSyntax(cst);
        }
        catch (CSTSemanticException e) {
            LOGGER.exception(e);
        }
        if (checkForInitializers) {
            this.initChecker.accept(cst, constraint.getParent(), variable);
        }
        boolean add = true;
        if (this.incremental) {
            boolean bl = add = !CSTUtils.isAssignment(cst);
            if (add) {
                this.variablesFinder.setConfiguration(this.config);
                cst.accept(this.variablesFinder);
                add = !this.variablesFinder.isConstraintFrozen();
                this.variablesFinder.clear();
            }
        }
        if (add) {
            boolean first = this.inTopLevelEvals && (target == this.otherConstraints || target == this.topLevelConstraints);
            this.addConstraint(target, first, constraint, register);
        }
    }

    @Override
    public final void addConstraint(ConstraintList target, boolean first, Constraint constraint, IDecisionVariable register) {
        if (first) {
            target.addFirst(constraint);
        } else {
            target.addLast(constraint);
        }
        this.simpleAssignmentFinder.acceptAndClear(constraint, this.config);
        if (null != register) {
            this.variablesMap.registerConstraint(register, constraint);
            if (null != this.copiedState) {
                this.copiedState.variablesMap.registerConstraint(register, constraint);
            }
        }
    }

    Constraint createConstraintVariableConstraint(ConstraintSyntaxTree cst, ConstraintSyntaxTree selfEx, AbstractVariable self, IModelElement parent, IDecisionVariable variable) {
        boolean cvo = this.contexts.constraintVarOnly(true);
        Constraint result = this.createConstraintVariableConstraint(cst, self, !((cst = this.substituteVariables(cst, selfEx, self, null)) instanceof ConstantValue), parent, variable);
        this.contexts.setConstraintVarOnly(cvo);
        return result;
    }

    Constraint createConstraintVariableConstraint(ConstraintSyntaxTree cst, AbstractVariable self, boolean checkForInitializers, IModelElement parent, IDecisionVariable variable) {
        ConstraintVariableConstraint constraint = null;
        try {
            constraint = new ConstraintVariableConstraint(cst, parent);
            this.addConstraint(this.otherConstraints, constraint, checkForInitializers, variable, variable);
        }
        catch (CSTSemanticException e) {
            LOGGER.exception(e);
        }
        return constraint;
    }

    private void analyzeEvaluationResult(Constraint constraint) {
        if (this.evaluator.constraintFailed()) {
            FailedElementDetails failedElementDetails = new FailedElementDetails();
            failedElementDetails.setProblemPoints(new HashSet<IDecisionVariable>(this.usedVariables));
            failedElementDetails.setProblemConstraintPart(this.getFailedConstraintPart());
            failedElementDetails.setProblemConstraint(constraint);
            failedElementDetails.setErrorClassifier(102);
            this.failedElements.addProblemConstraint(constraint, failedElementDetails);
        } else if (this.evaluator.constraintFulfilled()) {
            this.failedElements.removeProblemConstraint(constraint);
        }
        for (int j = 0; j < this.evaluator.getMessageCount(); ++j) {
            EvaluationVisitor.Message msg = this.evaluator.getMessage(j);
            AbstractVariable var = msg.getVariable();
            if (var == null || var.getParent() instanceof OperationDefinition || var.getParent() instanceof Constraint) continue;
            this.usedVariables.clear();
            this.usedVariables.add(msg.getDecision());
            FailedElementDetails failedelementDetails = new FailedElementDetails();
            failedelementDetails.setProblemPoints(new HashSet<IDecisionVariable>(this.usedVariables));
            failedelementDetails.setProblemConstraintPart(constraint.getConsSyntax());
            failedelementDetails.setProblemConstraint(constraint);
            failedelementDetails.setErrorClassifier(101);
            this.failedElements.addProblemVariable(var, failedelementDetails);
        }
        if (this.evaluator.constraintFulfilled() && Constraint.Type.DEFAULT == constraint.getType()) {
            this.simpleAssignmentFinder.acceptAndClear(constraint, this.config, false);
        }
    }

    ConstraintSyntaxTree substituteVariables(ConstraintSyntaxTree cst, ConstraintSyntaxTree selfEx, AbstractVariable self, ConstraintSyntaxTree acc) {
        this.substVisitor.setMappings(this.contexts);
        if (null != acc) {
            this.substVisitor.excludeFromMapping(acc);
        }
        if (selfEx != null) {
            this.substVisitor.setSelf(selfEx);
        }
        if (self != null) {
            this.substVisitor.setSelf(self);
        }
        cst = this.substVisitor.acceptAndClear(cst);
        ReasoningUtils.inferTypeSafe(cst, null);
        return cst;
    }

    private void conflictingDefault(AbstractVariable decl) {
    }

    private ConstraintSyntaxTree getFailedConstraintPart() {
        ConstraintSyntaxTree cstPart = null;
        if (this.evaluator.getFailedExpression() != null) {
            cstPart = this.evaluator.getFailedExpression()[0];
        }
        return cstPart;
    }

    IDecisionVariable getConstraintVariable(Constraint constraint) {
        return this.variablesMap.getDecisionVariableForConstraint(constraint);
    }

    int constraintCount() {
        return this.constraintCounter;
    }

    int variableCount() {
        return this.variablesCounter;
    }

    int variableInConstraintCount() {
        return this.variablesInConstraintsCounter;
    }

    int reevaluationCount() {
        return this.reevaluationCounter;
    }

    FailedElements getFailedElements() {
        return this.failedElements;
    }

    boolean setIncremental(boolean incremental) {
        boolean old = this.incremental;
        this.incremental = incremental;
        return old;
    }

    protected EvaluationVisitor createEvaluationVisitor() {
        return new EvalVisitor();
    }

    boolean hasTimeout() {
        return this.hasTimeout;
    }

    boolean wasStopped() {
        return this.wasStopped;
    }

    boolean isRunning() {
        return this.isRunning;
    }

    boolean stop() {
        this.wasStopped = true;
        return true;
    }

    void markForReuse() {
        this.reuseInstance = true;
    }

    void clear() {
        this.tmpBase.clear();
        this.defaultConstraints.clear();
        this.topLevelConstraints.clear();
        this.otherConstraints.clear();
        this.failedElements.clear();
        this.scopeAssignments.clear();
        this.constraintBase.clear();
        this.constraintCounter = 0;
        this.variablesInConstraintsCounter = 0;
        this.reevaluationCounter = 0;
        this.variablesCounter = 0;
        this.hasTimeout = false;
        this.isRunning = false;
        this.wasStopped = false;
        this.inRescheduling = false;
        this.usedVariables.clear();
        this.doneProjects.clear();
        this.substVisitor.clear();
        this.contexts.clear();
        this.simpleAssignmentFinder.clear();
    }

    void reInit() {
        this.hasTimeout = false;
        this.isRunning = false;
        this.wasStopped = false;
        this.inRescheduling = false;
        this.constraintCounter = 0;
        this.variablesInConstraintsCounter = 0;
        this.reevaluationCounter = 0;
        this.translationTime = 0L;
        this.evaluationTime = 0L;
        this.failedElements.clear();
        this.assignmentState = AssignmentState.DERIVED;
    }

    long getEvaluationTime() {
        return this.evaluationTime;
    }

    long getTranslationTime() {
        return this.translationTime;
    }

    void setAssignmentState(IAssignmentState state) {
        if (null != state) {
            this.assignmentState = state;
        }
    }

    final void addAssignedVariableToScope(IDecisionVariable variable) {
        this.scopeAssignments.addAssignedVariable(variable);
    }

    final boolean contextContainsMapping(AbstractVariable var) {
        return this.contexts.containsMapping(var);
    }

    final void contextRegisterMapping(AbstractVariable var, ConstraintSyntaxTree acc) {
        this.contexts.registerMapping(var, acc);
    }

    final void notifyRescheduling(boolean inRescheduling) {
        this.inRescheduling = inRescheduling;
    }

    @Override
    public boolean inRescheduling() {
        return this.inRescheduling;
    }

    private class OtherConstraintsProcessor
    extends AbstractConstraintProcessor {
        private ConstraintSyntaxTree selfEx;
        private AbstractVariable self;
        private IDecisionVariable variable;

        private OtherConstraintsProcessor() {
        }

        private void setParameter(ConstraintSyntaxTree selfEx, AbstractVariable self, IDecisionVariable variable) {
            this.selfEx = selfEx;
            this.self = self;
            this.variable = variable;
        }

        private void clear() {
            this.selfEx = null;
            this.self = null;
            this.variable = null;
        }

        @Override
        public ConstraintSyntaxTree process(ConstraintSyntaxTree cst, AbstractConstraintProcessor.ExpressionType type, String slot, IModelElement parent) {
            cst = Resolver.this.substituteVariables(cst, this.selfEx, this.self, null);
            try {
                AttachedConstraint constraint = new AttachedConstraint(cst, Resolver.this.contexts.getCurrentType(), parent);
                Resolver.this.addConstraint(Resolver.this.otherConstraints, constraint, true, this.variable, AbstractConstraintProcessor.ExpressionType.CONSTRAINT == type || AbstractConstraintProcessor.ExpressionType.ASSIGNMENT_CONSTRAINT == type ? this.variable : null);
            }
            catch (CSTSemanticException e) {
                LOGGER.exception(e);
            }
            return cst;
        }

        @Override
        public ContextStack getContextStack() {
            return Resolver.this.contexts;
        }
    }

    private class CompoundAnnotationMapper
    extends AnnotationVisitor {
        private ConstraintSyntaxTree cAcc;
        private Variable declVar;

        private CompoundAnnotationMapper() {
        }

        protected void initialize(ConstraintSyntaxTree cAcc, Variable declVar) {
            this.cAcc = cAcc;
            this.declVar = declVar;
        }

        protected void clear() {
            this.cAcc = null;
            this.declVar = null;
        }

        @Override
        protected void processAttributeAssignment(AttributeAssignment assng) throws IvmlException {
        }

        @Override
        protected void processAttribute(Attribute attr) throws IvmlException {
            AttributeVariable acc = null == this.cAcc ? new AttributeVariable(this.declVar, attr) : new AttributeVariable(this.cAcc, attr);
            for (Attribute iter = attr; null != iter; iter = iter.getOrigin()) {
                Resolver.this.contexts.registerMapping(iter, acc);
            }
        }
    }

    private static class DefaultConstraints {
        private ConstraintList defaultConstraints;
        private ConstraintList deferredDefaultConstraints;

        private DefaultConstraints() {
        }

        private DefaultConstraints initialize() {
            this.defaultConstraints = new ConstraintList();
            this.deferredDefaultConstraints = new ConstraintList();
            return this;
        }

        private void clear() {
            this.defaultConstraints.clear();
            this.deferredDefaultConstraints.clear();
        }

        private void transfer(ConstraintList target, boolean clear) {
            target.addAll(this.defaultConstraints, clear);
            target.addAll(this.deferredDefaultConstraints, clear);
        }
    }

    private class ConstraintTranslationVisitor
    extends ModelVisitorAdapter {
        private List<PartialEvaluationBlock> evals = null;

        private ConstraintTranslationVisitor() {
        }

        @Override
        public void visitProject(Project project) {
            for (int e = 0; e < project.getElementCount(); ++e) {
                project.getElement(e).accept(this);
            }
            if (null != this.evals) {
                Resolver.this.inTopLevelEvals = true;
                for (PartialEvaluationBlock block : this.evals) {
                    int i;
                    for (i = 0; i < block.getNestedCount(); ++i) {
                        block.getNested(i).accept(this);
                    }
                    for (i = 0; i < block.getEvaluableCount(); ++i) {
                        block.getEvaluable(i).accept(this);
                    }
                }
                Resolver.this.inTopLevelEvals = false;
            }
        }

        @Override
        public void visitDecisionVariableDeclaration(DecisionVariableDeclaration decl) {
            Resolver.this.translateDeclaration(decl, Resolver.this.config.getDecision(decl), null);
        }

        @Override
        public void visitConstraint(Constraint constraint) {
            Resolver.this.addConstraint(Resolver.this.topLevelConstraints, constraint, true, null, null);
        }

        @Override
        public void visitPartialEvaluationBlock(PartialEvaluationBlock block) {
            if (!Resolver.this.inTopLevelEvals) {
                if (null == this.evals) {
                    this.evals = new LinkedList<PartialEvaluationBlock>();
                }
                this.evals.add(block);
            }
        }

        @Override
        public void visitAttributeAssignment(AttributeAssignment assignment) {
            for (int v = 0; v < assignment.getElementCount(); ++v) {
                assignment.getElement(v).accept(this);
            }
            for (int c = 0; c < assignment.getConstraintsCount(); ++c) {
                Resolver.this.addConstraint(Resolver.this.topLevelConstraints, assignment.getConstraint(c), true, null, null);
            }
            for (int a = 0; a < assignment.getAssignmentCount(); ++a) {
                assignment.getAssignment(a).accept(this);
            }
            if (!Resolver.this.incremental) {
                Resolver.this.translateAnnotationAssignments(assignment, null, null, null);
            }
        }
    }

    private static class ReasonerState {
        private List<ConstraintList> constraintBase = new LinkedList<ConstraintList>();
        private VariablesMap variablesMap = new VariablesMap();

        private ReasonerState() {
        }
    }
}

