/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.sseReasoner.functions;

import java.util.HashSet;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.reasoning.sseReasoner.functions.AbstractConstraintProcessor;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.BlockExpression;
import net.ssehub.easy.varModel.cst.Comment;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.DeferInitExpression;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.IfThen;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.MultiAndExpression;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Parenthesis;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.UnresolvedExpression;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.datatypes.AnyType;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.datatypes.MetaType;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.datatypes.RealType;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.datatypes.StringType;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.datatypes.VersionType;
import net.ssehub.easy.varModel.model.filter.ConstraintFinder;

public class ConstraintFunctions {
    public static void allCompoundConstraints(Compound cmpType, AbstractConstraintProcessor processor, boolean includeConstraintVariables, boolean includeDefaults, IModelElement parent) {
        if (!processor.getContextStack().isTypeExcluded(cmpType)) {
            for (int c = 0; c < cmpType.getConstraintsCount(); ++c) {
                processor.process(cmpType.getConstraint(c), AbstractConstraintProcessor.ExpressionType.CONSTRAINT);
            }
            if (includeConstraintVariables || includeDefaults) {
                for (int i = 0; i < cmpType.getElementCount(); ++i) {
                    DecisionVariableDeclaration decl = cmpType.getElement(i);
                    ConstraintSyntaxTree defaultValue = decl.getDefaultValue();
                    if (null != defaultValue) {
                        if (includeConstraintVariables && TypeQueries.isConstraint(decl.getType())) {
                            processor.process(defaultValue, AbstractConstraintProcessor.ExpressionType.CONSTRAINT_VALUE, decl.getName(), parent);
                        } else if (includeDefaults) {
                            processor.process(defaultValue, AbstractConstraintProcessor.ExpressionType.DEFAULT, decl.getName(), parent);
                        }
                    }
                    int n = decl.getAttributesCount();
                    for (int a = 0; includeDefaults && a < n; ++a) {
                        Attribute attr = decl.getAttribute(a);
                        defaultValue = attr.getDefaultValue();
                        if (null == defaultValue) continue;
                        processor.process(defaultValue, AbstractConstraintProcessor.ExpressionType.ANNOTATION_DEFAULT, attr.getName(), parent);
                    }
                }
            }
            for (int r = 0; r < cmpType.getRefinesCount(); ++r) {
                ConstraintFunctions.allCompoundConstraints(cmpType.getRefines(r), processor, includeConstraintVariables, includeDefaults, parent);
            }
            for (int a = 0; a < cmpType.getAssignmentCount(); ++a) {
                ConstraintFunctions.allAssignmentConstraints(cmpType.getAssignment(a), processor);
            }
        }
    }

    public static void allAssignmentConstraints(AttributeAssignment assng, AbstractConstraintProcessor processor) {
        for (int c = 0; c < assng.getConstraintsCount(); ++c) {
            processor.process(assng.getConstraint(c), AbstractConstraintProcessor.ExpressionType.ASSIGNMENT_CONSTRAINT);
        }
        for (int a = 0; a < assng.getAssignmentCount(); ++a) {
            ConstraintFunctions.allAssignmentConstraints(assng.getAssignment(a), processor);
        }
    }

    public static void addConstraintsToProject(AbstractVariable var, Project scope, Project target) {
        new TransitiveConstraintFinder(scope, target).visit(var);
    }

    private static class TransitiveConstraintFinder
    extends ConstraintFinder
    implements IConstraintTreeVisitor,
    IDatatypeVisitor {
        private boolean add;
        private java.util.Set<AbstractVariable> variables = new HashSet<AbstractVariable>();
        private java.util.Set<AbstractVariable> scheduled = new HashSet<AbstractVariable>();
        private java.util.Set<AbstractVariable> candidates = new HashSet<AbstractVariable>();
        private java.util.Set<Object> done = new HashSet<Object>();
        private Project scope;
        private Project target;
        private IModelVisitor mVisitor;

        public TransitiveConstraintFinder(Project scope, Project target) {
            super(scope);
            this.scope = scope;
            this.target = target;
            this.mVisitor = this;
        }

        @Override
        protected void startAccept(Project project) {
        }

        public void visit(AbstractVariable var) {
            this.addToVariables(var);
            this.scope.accept(this);
            while (!this.scheduled.isEmpty()) {
                boolean visitAgain = false;
                for (AbstractVariable v : this.scheduled) {
                    if (this.variables.contains(v)) continue;
                    this.addToVariables(var);
                    this.target.add(v);
                    visitAgain = true;
                }
                this.scheduled.clear();
                if (!visitAgain) continue;
                this.scope.accept(this);
            }
        }

        private void visit(IDatatype type) {
            if (null != type && !this.done.contains(type)) {
                this.done.add(type);
                type.accept(this);
            }
        }

        private void addToVariables(AbstractVariable var) {
            this.variables.add(var);
            var.accept(this.mVisitor);
        }

        @Override
        public void visitDecisionVariableDeclaration(DecisionVariableDeclaration decl) {
            this.visit(decl.getType());
            if (null != decl.getDefaultValue()) {
                int size = this.candidates.size();
                decl.getDefaultValue().accept(this);
                if (this.candidates.size() > size) {
                    this.scheduled.addAll(this.candidates);
                    this.candidates.clear();
                }
            }
        }

        @Override
        public void visitConstraint(Constraint constraint) {
            this.add = false;
            constraint.getConsSyntax().accept(this);
            if (this.add) {
                this.target.addConstraint(constraint);
                this.scheduled.addAll(this.candidates);
                this.candidates.clear();
            }
        }

        @Override
        public void visitProject(Project project) {
            Project old = this.target;
            String pName = project.getName();
            for (int i = 0; old == this.target && i < old.getImportsCount(); ++i) {
                ProjectImport imp = old.getImport(i);
                if (!imp.getName().equals(pName) || null == imp.getResolved()) continue;
                this.target = (Project)imp.getResolved();
            }
            if (old == this.target) {
                this.target = new Project(pName);
                ProjectImport imp = new ProjectImport(pName);
                try {
                    imp.setResolved(this.target);
                    old.addImport(imp);
                }
                catch (ModelManagementException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.reasoning.sseReasoner");
                }
            }
            super.visitProject(project);
        }

        @Override
        public void visitConstantValue(ConstantValue value) {
        }

        private void handle(AbstractVariable variable) {
            boolean found = this.variables.contains(variable);
            if (!found) {
                this.candidates.add(variable);
            }
            this.add |= found;
        }

        @Override
        public void visitVariable(Variable variable) {
            this.handle(variable.getVariable());
        }

        @Override
        public void visitAnnotationVariable(AttributeVariable variable) {
            this.handle(variable.getVariable());
        }

        @Override
        public void visitParenthesis(Parenthesis parenthesis) {
            parenthesis.getExpr().accept(this);
        }

        @Override
        public void visitComment(Comment comment) {
        }

        @Override
        public void visitOclFeatureCall(OCLFeatureCall call) {
            if (null != call.getOperand()) {
                call.getOperand().accept(this);
            }
            for (int p = 0; p < call.getParameterCount(); ++p) {
                call.getParameter(p).accept(this);
            }
        }

        @Override
        public void visitLet(Let let) {
            let.getInExpression().accept(this);
        }

        @Override
        public void visitIfThen(IfThen ifThen) {
            ifThen.getIfExpr().accept(this);
            if (null != ifThen.getElseExpr()) {
                ifThen.getElseExpr().accept(this);
            }
        }

        @Override
        public void visitContainerOperationCall(ContainerOperationCall call) {
            call.getExpression().accept(this);
        }

        @Override
        public void visitCompoundAccess(CompoundAccess access) {
            if (null != access.getResolvedSlot()) {
                access.getResolvedSlot().accept(this.mVisitor);
            }
        }

        @Override
        public void visitUnresolvedExpression(UnresolvedExpression expression) {
        }

        @Override
        public void visitCompoundInitializer(CompoundInitializer initializer) {
            for (int e = 0; e < initializer.getExpressionCount(); ++e) {
                initializer.getExpression(e).accept(this);
            }
        }

        @Override
        public void visitContainerInitializer(ContainerInitializer initializer) {
            for (int e = 0; e < initializer.getExpressionCount(); ++e) {
                initializer.getExpression(e).accept(this);
            }
        }

        @Override
        public void visitSelf(Self self) {
        }

        @Override
        public void visitBlockExpression(BlockExpression block) {
            for (int e = 0; e < block.getExpressionCount(); ++e) {
                block.getExpression(e).accept(this);
            }
        }

        @Override
        public void visitDeferInitExpression(DeferInitExpression expression) {
            expression.getExpression().accept(this);
        }

        @Override
        public void visitMultiAndExpression(MultiAndExpression expression) {
            for (int e = 0; e < expression.getExpressionCount(); ++e) {
                expression.getExpression(e).accept(this);
            }
        }

        @Override
        public void visitDatatype(IDatatype datatype) {
        }

        @Override
        public void visitAnyType(AnyType datatype) {
        }

        @Override
        public void visitMetaType(MetaType datatype) {
        }

        @Override
        public void visitDerivedType(DerivedDatatype datatype) {
            datatype.getBasisType().accept(this);
        }

        @Override
        public void visitBooleanType(BooleanType type) {
        }

        @Override
        public void visitStringType(StringType type) {
        }

        @Override
        public void visitConstraintType(ConstraintType type) {
        }

        @Override
        public void visitIntegerType(IntegerType type) {
        }

        @Override
        public void visitVersionType(VersionType type) {
        }

        @Override
        public void visitRealType(RealType type) {
        }

        @Override
        public void visitCompoundType(Compound compound) {
            for (int e = 0; e < compound.getElementCount(); ++e) {
                compound.getElement(e).accept(this.mVisitor);
            }
            for (int a = 0; a < compound.getAssignmentCount(); ++a) {
                compound.getAssignment(a).accept(this.mVisitor);
            }
        }

        @Override
        public void visitAttributeAssignment(AttributeAssignment assignment) {
            for (int e = 0; e < assignment.getElementCount(); ++e) {
                assignment.getElement(e).accept(this.mVisitor);
            }
            super.visitAttributeAssignment(assignment);
        }

        @Override
        public void visitSet(Set set) {
            for (int g = 0; g < set.getGenericTypeCount(); ++g) {
                set.getGenericType(g).accept(this);
            }
        }

        @Override
        public void visitSequence(Sequence sequence) {
            for (int g = 0; g < sequence.getGenericTypeCount(); ++g) {
                sequence.getGenericType(g).accept(this);
            }
        }

        @Override
        public void visitEnumType(Enum enumType) {
        }

        @Override
        public void visitOrderedEnumType(OrderedEnum enumType) {
        }
    }
}

