/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.sseReasoner.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.pool.IPoolManager;
import net.ssehub.easy.basics.pool.Pool;
import net.ssehub.easy.reasoning.core.reasoner.ConstraintList;
import net.ssehub.easy.reasoning.sseReasoner.model.ReasoningUtils;
import net.ssehub.easy.reasoning.sseReasoner.model.TypeCache;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;

public final class ContextStack {
    private static final Pool<Context> POOL = new Pool<Context>(new IPoolManager<Context>(){

        @Override
        public Context create() {
            return new Context();
        }

        @Override
        public void clear(Context instance) {
            instance.clear();
        }
    });
    private Context currentContext = new Context();
    private Set<? extends IDatatype> globalExcludes;
    private transient TypeCache typeCache = null;

    public void clear() {
        do {
            this.popContext();
        } while (null != this.currentContext.predecessor);
        this.currentContext.clear();
    }

    public void pushContext(AbstractVariable decl, boolean recordProcessedTypes) {
        this.pushContext(decl, null, null, false);
    }

    public void recordAnnotationAssignments(Compound type) {
        Compound cType = type;
        if (cType.getAssignmentCount() > 0) {
            this.currentContext.annotationAssignments = new HashSet();
            for (int a = 0; a < cType.getAssignmentCount(); ++a) {
                this.collectAnnotationAssignments(cType.getAssignment(a));
            }
        }
    }

    void collectAnnotationAssignments(AttributeAssignment assng) {
        int a;
        for (a = 0; a < assng.getAssignmentDataCount(); ++a) {
            this.currentContext.annotationAssignments.add(assng.getAssignmentData(a).getName());
        }
        for (a = 0; a < assng.getAssignmentCount(); ++a) {
            this.collectAnnotationAssignments(assng.getAssignment(a));
        }
    }

    public boolean isKnownAnnotationAssignment(String name) {
        Set assng = this.currentContext.annotationAssignments;
        return null != assng ? assng.contains(name) : false;
    }

    public void pushContext(AbstractVariable decl, ConstraintSyntaxTree container, DecisionVariableDeclaration iterator, boolean recordProcessedTypes) {
        Context context = POOL.getInstance();
        context.container = container;
        context.iterator = iterator;
        context.recordProcessedTypes = recordProcessedTypes;
        this.pushContextImpl(context);
    }

    private void pushContextImpl(Context context) {
        context.predecessor = this.currentContext;
        context.inConstruction = this.currentContext.inConstruction;
        context.constraintVarOnly = this.currentContext.constraintVarOnly;
        context.self = this.currentContext.self;
        this.currentContext = context;
    }

    public void popContext(IDatatype type) {
        this.popContextImpl();
    }

    public void popContext() {
        this.popContextImpl();
    }

    private Context popContextImpl() {
        Context context = null;
        if (null != this.currentContext.predecessor) {
            context = this.currentContext;
            Context context2 = this.currentContext = context.predecessor;
            context2.cashMapping = context2.cashMapping | context.cashMapping;
        }
        return context;
    }

    public void registerMapping(AbstractVariable var, ConstraintSyntaxTree acc) {
        this.currentContext.varMap.put(var, acc);
        String name = var.getName();
        if (!this.currentContext.nameMap.containsKey(name)) {
            this.currentContext.nameMap.put(name, acc);
        }
    }

    public void unregisterMapping(AbstractVariable var) {
        this.currentContext.varMap.remove(var);
    }

    public boolean containsMapping(AbstractVariable var) {
        boolean found = this.currentContext.varMap.containsKey(var);
        return found;
    }

    public ConstraintSyntaxTree getMapping(AbstractVariable var) {
        ConstraintSyntaxTree result;
        Context iter = this.currentContext;
        do {
            result = (ConstraintSyntaxTree)iter.varMap.get(var);
            iter = iter.predecessor;
        } while (null == result && null != iter);
        return result;
    }

    public ConstraintSyntaxTree getLocalMapping(String name) {
        ConstraintSyntaxTree result = (ConstraintSyntaxTree)this.currentContext.nameMap.get(name);
        return result;
    }

    public void addConstraint(ConstraintList target, boolean first, Constraint constraint, boolean register) {
    }

    public boolean transferConstraints(IDatatype type, TypeCache.IConstraintTarget target, IDecisionVariable register, AbstractVariable var) {
        boolean result = false;
        return result;
    }

    public boolean constraintVarOnly(boolean clear) {
        boolean result = false;
        return result;
    }

    public void setConstraintVarOnly(boolean constraintVarOnly) {
    }

    public void registerForTypeCache(IDatatype type, AbstractVariable var) {
    }

    public TypeCache.Entry getInConstruction(boolean clear) {
        TypeCache.Entry result = null;
        return result;
    }

    public void setInConstruction(TypeCache.Entry inConstruction) {
    }

    public void notifyCashMapping() {
    }

    public TranslateMode getMappingMode(IDatatype type) {
        TranslateMode result = TranslateMode.REGISTER;
        return result;
    }

    public void transferToContext(IDatatype type, AbstractVariable var) {
    }

    public void addAsParentCache(IDatatype type, TypeCache.IConstraintTarget target, IDecisionVariable register, AbstractVariable var) {
    }

    public ConstraintSyntaxTree getCurrentContainer() {
        return this.currentContext.container;
    }

    public DecisionVariableDeclaration getCurrentIterator() {
        return this.currentContext.iterator;
    }

    public ConstraintSyntaxTree composeExpression(ConstraintSyntaxTree cst) throws CSTSemanticException {
        Context iter = this.currentContext;
        do {
            if (null == iter.container) continue;
            cst = ReasoningUtils.createContainerCall(iter.container, Container.FORALL, cst, iter.iterator);
            cst.inferDatatype();
        } while (null != (iter = iter.predecessor));
        return cst;
    }

    public void recordProcessed(IDatatype type) {
        boolean found = false;
        Context iter = this.currentContext;
        do {
            if (iter.recordProcessedTypes) {
                if (type instanceof Compound) {
                    this.recordProcessed(iter.processedTypes, (Compound)type);
                } else {
                    iter.processedTypes.add(type);
                }
                found = true;
            }
            iter = iter.predecessor;
        } while (!found && null != iter);
    }

    private void recordProcessed(Set<IDatatype> processed, Compound type) {
        if (!processed.contains(type)) {
            processed.add(type);
            for (int r = 0; r < type.getRefinesCount(); ++r) {
                this.recordProcessed(processed, type.getRefines(r));
            }
        }
    }

    public boolean alreadyProcessed(IDatatype type) {
        boolean found = false;
        Context iter = this.currentContext;
        do {
            if (iter.recordProcessedTypes) {
                found = iter.processedTypes.contains(type);
            }
            iter = iter.predecessor;
        } while (!found && null != iter);
        return found;
    }

    public int size() {
        int result = 0;
        Context iter = this.currentContext;
        do {
            ++result;
        } while (null != (iter = iter.predecessor));
        return result;
    }

    public void setTypeExcludes(Set<? extends IDatatype> excludes) {
        this.globalExcludes = excludes;
    }

    public void transferTypeExcludes(IDatatype type) {
        if (null != this.globalExcludes && null == this.currentContext.typeExcludes) {
            this.currentContext.typeExcludes = this.globalExcludes;
            this.globalExcludes = null;
        }
        this.currentContext.type = type;
    }

    public boolean isElementTypeExcluded(IModelElement element) {
        return element instanceof IDatatype ? this.isTypeExcluded((IDatatype)((Object)element)) : false;
    }

    public boolean isTypeExcluded(IDatatype type) {
        return null == this.currentContext.typeExcludes ? false : this.currentContext.typeExcludes.contains(type);
    }

    public IDatatype getCurrentType() {
        return this.currentContext.type;
    }

    static class Context {
        private Map<AbstractVariable, ConstraintSyntaxTree> varMap = new HashMap<AbstractVariable, ConstraintSyntaxTree>(30);
        private Map<String, ConstraintSyntaxTree> nameMap = new HashMap<String, ConstraintSyntaxTree>();
        private DecisionVariableDeclaration iterator;
        private ConstraintSyntaxTree container;
        private Context predecessor;
        private boolean recordProcessedTypes;
        private Set<IDatatype> processedTypes = new HashSet<IDatatype>();
        private Set<? extends IDatatype> typeExcludes;
        private IDatatype type;
        private TypeCache.Entry inConstruction;
        private boolean cashMapping;
        private boolean constraintVarOnly;
        private TypeCache.Entry fallback;
        private AbstractVariable self;
        private Set<String> annotationAssignments;

        Context() {
        }

        private void clear() {
            this.varMap.clear();
            this.nameMap.clear();
            this.iterator = null;
            this.container = null;
            this.predecessor = null;
            this.recordProcessedTypes = false;
            this.processedTypes.clear();
            this.typeExcludes = null;
            this.type = null;
            this.inConstruction = null;
            this.cashMapping = false;
            this.fallback = null;
            this.annotationAssignments = null;
        }
    }

    public static enum TranslateMode {
        NOTHING,
        REGISTER,
        TRANSFER;

    }
}

