/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.sseReasoner.model;

import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.reasoning.sseReasoner.model.VariablesMap;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.BlockExpression;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.Comment;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.DeferInitExpression;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.IfThen;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.MultiAndExpression;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Parenthesis;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.UnresolvedExpression;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationVisitor;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.Value;

public class VariablesInNotSimpleAssignmentConstraintsFinder
implements IConstraintTreeVisitor {
    private Configuration config;
    private VariablesMap constraintMap;
    private Constraint constraint;
    private boolean add = true;
    private EvaluationVisitor evaluator;

    public VariablesInNotSimpleAssignmentConstraintsFinder(VariablesMap constraintMap) {
        this.constraintMap = constraintMap;
        this.evaluator = new EvaluationVisitor();
    }

    public void accept(Constraint constraint, Configuration config) {
        this.config = config;
        this.constraint = constraint;
        this.evaluator.init(config, null, false, null);
        constraint.getConsSyntax().accept(this);
    }

    public void acceptAndClear(Constraint constraint, Configuration config) {
        this.acceptAndClear(constraint, config, true);
    }

    public void acceptAndClear(Constraint constraint, Configuration config, boolean add) {
        this.add = add;
        this.accept(constraint, config);
        this.clear();
    }

    public void acceptAndClear(List<Constraint> constraints, Configuration config, boolean add) {
        this.add = add;
        this.config = config;
        this.evaluator.init(config, null, false, null);
        for (int c = 0; c < constraints.size(); ++c) {
            this.constraint = constraints.get(c);
            this.constraint.getConsSyntax().accept(this);
        }
        this.clear();
    }

    public void clear() {
        this.config = null;
        this.constraint = null;
        this.add = true;
        this.evaluator.clear();
    }

    public VariablesInNotSimpleAssignmentConstraintsFinder forRemove() {
        this.add = false;
        return this;
    }

    @Override
    public void visitConstantValue(ConstantValue value) {
        Value constValue = value.getConstantValue();
        if (null != constValue && constValue instanceof ReferenceValue) {
            ReferenceValue rValue = (ReferenceValue)constValue;
            this.modifyRelation(rValue.getValue(), this.constraint);
        }
    }

    @Override
    public void visitVariable(Variable variable) {
        this.modifyRelation(variable.getVariable(), this.constraint);
    }

    private void modifyRelation(AbstractVariable variable, Constraint constraint) {
        if (null != variable) {
            IDecisionVariable var = this.config.getDecision(variable);
            if (null != var) {
                if (this.add) {
                    this.constraintMap.registerConstraint(var, constraint);
                } else {
                    this.constraintMap.unregisterConstraint(var, constraint);
                }
            }
            if (this.add) {
                this.constraintMap.add(variable, constraint);
            } else {
                this.constraintMap.remove(variable, constraint);
            }
        }
    }

    @Override
    public void visitAnnotationVariable(AttributeVariable variable) {
        ConstraintSyntaxTree qu = variable.getQualifier();
        if (null != qu) {
            qu.accept(this);
        }
        this.visitVariable(variable);
    }

    @Override
    public void visitParenthesis(Parenthesis parenthesis) {
        parenthesis.getExpr().accept(this);
    }

    @Override
    public void visitComment(Comment comment) {
        comment.getExpr().accept(this);
    }

    private boolean isConstraint(ConstraintSyntaxTree cst) {
        boolean result;
        try {
            result = TypeQueries.isConstraint(cst.inferDatatype());
        }
        catch (CSTSemanticException e) {
            result = false;
        }
        return result;
    }

    @Override
    public void visitOclFeatureCall(OCLFeatureCall call) {
        if (null != call.getOperand()) {
            ConstraintSyntaxTree operand;
            boolean analyze = true;
            if (call.getParameterCount() == 1 && call.getOperation().equals("=") && ((operand = call.getOperand()) instanceof Variable || operand instanceof CompoundAccess)) {
                ConstraintSyntaxTree param0 = call.getParameter(0);
                if (param0 instanceof ConstantValue || param0 instanceof ContainerInitializer || param0 instanceof CompoundInitializer) {
                    analyze = false;
                } else if (this.isConstraint(operand)) {
                    analyze = false;
                }
            }
            if (analyze) {
                call.getOperand().accept(this);
                for (int i = 0; i < call.getParameterCount(); ++i) {
                    call.getParameter(i).accept(this);
                }
            }
        }
    }

    @Override
    public void visitDeferInitExpression(DeferInitExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visitMultiAndExpression(MultiAndExpression expression) {
        for (int e = 0; e < expression.getExpressionCount(); ++e) {
            expression.getExpression(e).accept(this);
        }
    }

    @Override
    public void visitLet(Let let) {
        let.getInExpression().accept(this);
    }

    @Override
    public void visitIfThen(IfThen ifThen) {
        ifThen.getIfExpr().accept(this);
        ifThen.getThenExpr().accept(this);
        ifThen.getElseExpr().accept(this);
    }

    @Override
    public void visitContainerOperationCall(ContainerOperationCall call) {
        call.getContainer().accept(this);
        call.getExpression().accept(this);
    }

    @Override
    public void visitCompoundAccess(CompoundAccess access) {
        access.getCompoundExpression().accept(this);
        try {
            access.inferDatatype();
        }
        catch (CSTSemanticException e) {
            EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.reasoning.sseReasoner").exception(e);
        }
        access.accept(this.evaluator);
        IDecisionVariable var = this.evaluator.getResultVariable();
        if (null != var) {
            this.modifyRelation(var.getDeclaration(), this.constraint);
        } else {
            try {
                IDatatype cType = Reference.dereference(access.getCompoundExpression().inferDatatype());
                if (cType instanceof Compound) {
                    this.modifyRelation(((Compound)cType).getElement(access.getSlotName()), this.constraint);
                }
            }
            catch (CSTSemanticException cSTSemanticException) {
                // empty catch block
            }
        }
        this.evaluator.clearResult();
    }

    @Override
    public void visitUnresolvedExpression(UnresolvedExpression expression) {
        ConstraintSyntaxTree nestedConstraint = expression.getActualExpression();
        if (null != nestedConstraint) {
            nestedConstraint.accept(this);
        }
    }

    @Override
    public void visitCompoundInitializer(CompoundInitializer initializer) {
        for (int i = 0; i < initializer.getExpressionCount(); ++i) {
            initializer.getExpression(i).accept(this);
        }
    }

    @Override
    public void visitContainerInitializer(ContainerInitializer initializer) {
        for (int i = 0; i < initializer.getExpressionCount(); ++i) {
            initializer.getExpression(i).accept(this);
        }
    }

    @Override
    public void visitSelf(Self self) {
    }

    @Override
    public void visitBlockExpression(BlockExpression block) {
        int n = block.getExpressionCount();
        for (int e = 0; e < n; ++e) {
            block.getExpression(e).accept(this);
        }
    }
}

