/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.confModel;

import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.CompoundVariable;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.confModel.IFreezeSelector;
import net.ssehub.easy.varModel.confModel.NestedVarConfigProvider;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;

class CompoundItemConfigProvider
extends NestedVarConfigProvider {
    private String slotName;
    private IAssignmentState state;

    protected CompoundItemConfigProvider(CompoundVariable parent, String slotName) {
        super(parent);
        this.slotName = slotName;
        this.state = AssignmentState.UNDEFINED;
    }

    @Override
    protected CompoundVariable getParent() {
        return (CompoundVariable)super.getParent();
    }

    @Override
    protected Value getValue() {
        Value parentValue = this.getParent().getValue();
        return parentValue instanceof NullValue ? parentValue : ((CompoundValue)parentValue).getNestedValue(this.slotName);
    }

    @Override
    protected void setValue(Value value, IAssignmentState state) throws ConfigurationException {
        Value parentValue = this.getParent().getValue();
        if (null == parentValue || parentValue instanceof NullValue) {
            this.getParent().setValue(null, state);
            parentValue = this.getParent().getValue();
        }
        CompoundValue cmpValue = (CompoundValue)parentValue;
        try {
            cmpValue.configureValue(this.slotName, value);
            this.setState(state);
            this.getParent().notifyCreated();
        }
        catch (ValueDoesNotMatchTypeException e) {
            throw new ConfigurationException(this.getConfiguration(), e.getMessage(), 19002);
        }
    }

    @Override
    protected IAssignmentState getState() {
        IAssignmentState state = this.state;
        if (!this.getParent().ownStateAllowed()) {
            if (this.getParent().getState() == AssignmentState.FROZEN && null != this.getValue()) {
                state = AssignmentState.FROZEN;
            } else if (!this.getParent().ownStateAllowed() && null != this.getValue()) {
                state = this.getParent().getState();
            }
        }
        return state;
    }

    @Override
    protected final void setState(IAssignmentState state) {
        this.state = state;
        this.getConfiguration().variableChangedState(this.getParent());
    }

    @Override
    protected AbstractVariable getDeclaration() {
        Compound cmpType = (Compound)this.getParent().getDeclaration().getType();
        DecisionVariableDeclaration decl = null;
        for (int i = 0; i < cmpType.getElementCount() && null == decl; ++i) {
            if (!cmpType.getElement(i).getName().equals(this.slotName)) continue;
            decl = cmpType.getElement(i);
        }
        return decl;
    }

    @Override
    protected void setHistoryValue(Value value, IAssignmentState state) throws ConfigurationException {
        this.state = state;
    }

    @Override
    protected void freeze(IFreezeSelector selector) {
        IDecisionVariable thisVariable = this.getParent().getNestedVariable(this.slotName);
        if (selector.shallFreeze(thisVariable)) {
            this.freeze();
        }
    }
}

