/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.confModel;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.varModel.Bundle;
import net.ssehub.easy.varModel.confModel.AllFreezeSelector;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.DecisionVariable;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IConfigurationElement;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.confModel.IFreezeSelector;
import net.ssehub.easy.varModel.confModel.StructuredVariable;
import net.ssehub.easy.varModel.confModel.VariableCreator;
import net.ssehub.easy.varModel.confModel.paths.IResolutionPathElement;
import net.ssehub.easy.varModel.confModel.paths.NameAccessPathElement;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationVisitor;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

public class CompoundVariable
extends StructuredVariable {
    private Map<String, IDecisionVariable> nestedElements;
    private Compound instantiatableType;
    private boolean created;

    CompoundVariable(IConfigurationElement parent, AbstractVariable varDeclaration, boolean isVisible, boolean isAttribute) {
        super(parent, varDeclaration, isVisible, isAttribute);
        if (null == this.nestedElements) {
            this.nestedElements = new LinkedHashMap<String, IDecisionVariable>();
        }
        this.instantiatableType = (Compound)DerivedDatatype.resolveToBasis(varDeclaration.getType());
        if (this.instantiatableType.isAbstract()) {
            boolean done = false;
            if (null != varDeclaration.getDefaultValue()) {
                try {
                    IDatatype dfltValType = varDeclaration.getDefaultValue().inferDatatype();
                    if (!TypeQueries.isAnyType(dfltValType)) {
                        this.instantiatableType = (Compound)dfltValType;
                        done = true;
                    }
                }
                catch (CSTSemanticException dfltValType) {
                    // empty catch block
                }
            }
            if (!done) {
                Collection<Compound> candidates = this.instantiatableType.implementingNonAbstract(parent.getConfiguration().getProject());
                if ((candidates = this.instantiatableType.closestRefining(candidates)).size() > 0) {
                    this.instantiatableType = candidates.iterator().next();
                }
            }
        }
        for (int i = 0; i < this.instantiatableType.getInheritedElementCount(); ++i) {
            this.createNestedElement(this.instantiatableType.getInheritedElement(i), isVisible, isAttribute, false);
        }
        this.resolveAssignBlocks(this.instantiatableType);
    }

    @Override
    public IDatatype getInstantiatableType() {
        return null == this.instantiatableType ? super.getInstantiatableType() : this.instantiatableType;
    }

    private void resolveAssignBlocks(Compound cType) {
        for (int r = 0; r < cType.getRefinesCount(); ++r) {
            this.resolveAssignBlocks(cType.getRefines(r));
        }
        for (int a = 0; a < cType.getAssignmentCount(); ++a) {
            AttributeAssignment assignBlock = cType.getAssignment(a);
            this.resolveAssignBlocks(assignBlock, new HashMap<String, Value>());
        }
    }

    private void resolveAssignBlocks(AttributeAssignment assignBlock, Map<String, Value> annotationValues) {
        int i;
        int n = assignBlock.getAssignmentDataCount();
        for (i = 0; i < n; ++i) {
            AttributeAssignment.Assignment annotationAssignment = assignBlock.getAssignmentData(i);
            ConstraintSyntaxTree assignmentCST = annotationAssignment.getExpression();
            EvaluationVisitor evalVisitor = new EvaluationVisitor();
            evalVisitor.init(this.getConfiguration(), null, false, null);
            assignmentCST.accept(evalVisitor);
            Value annotationValue = evalVisitor.getResult();
            if (null == annotationValue) continue;
            annotationValues.put(annotationAssignment.getName(), annotationValue);
        }
        n = assignBlock.getModelElementCount();
        for (i = 0; i < n; ++i) {
            ContainableModelElement element = assignBlock.getModelElement(i);
            if (element instanceof DecisionVariableDeclaration) {
                DecisionVariableDeclaration nestedDeclaration = (DecisionVariableDeclaration)element;
                IDecisionVariable nestedVariable = this.getNestedVariable(nestedDeclaration.getName());
                if (null == nestedVariable) continue;
                int m = nestedVariable.getAttributesCount();
                for (int j = 0; j < m; ++j) {
                    IDecisionVariable annotation = nestedVariable.getAttribute(j);
                    Value annotationValue = annotationValues.get(annotation.getDeclaration().getName());
                    if (null == annotationValue) continue;
                    try {
                        annotation.setValue(annotationValue, AssignmentState.DEFAULT);
                        continue;
                    }
                    catch (ConfigurationException e) {
                        Bundle.getLogger(CompoundVariable.class).exception(e);
                    }
                }
                continue;
            }
            if (!(element instanceof AttributeAssignment)) continue;
            AttributeAssignment nestedAssignBlock = (AttributeAssignment)element;
            this.resolveAssignBlocks(nestedAssignBlock, new HashMap<String, Value>(annotationValues));
        }
    }

    private boolean isDirectTypeRecursive(AbstractVariable slot) {
        IDatatype myType = this.getDeclaration().getType();
        IDatatype slotType = slot.getType();
        return Compound.TYPE.isAssignableFrom(myType) && (myType.isAssignableFrom(slotType) || slotType.isAssignableFrom(myType));
    }

    private IDecisionVariable createNestedElement(AbstractVariable decl, boolean isVisible, boolean isAttribute, boolean force) {
        IDecisionVariable nestedVar = null;
        if (force || !this.isDirectTypeRecursive(decl)) {
            VariableCreator creator = new VariableCreator(decl, this, isVisible, isAttribute);
            try {
                nestedVar = creator.getVariable(false);
                this.nestedElements.put(decl.getName(), nestedVar);
            }
            catch (ConfigurationException e) {
                this.getLogger().exception(e);
            }
        }
        return nestedVar;
    }

    @Override
    public IAssignmentState getState() {
        IAssignmentState state = super.getState();
        if (state != AssignmentState.FROZEN && this.ownStateAllowed() && this.getValue() != NullValue.INSTANCE) {
            CompoundValue cmpValue = (CompoundValue)this.getValue();
            state = cmpValue != null && null != cmpValue.getValue() ? AssignmentState.ASSIGNED : AssignmentState.UNDEFINED;
        }
        return state;
    }

    @Override
    public int getNestedElementsCount() {
        return null == this.nestedElements ? 0 : this.nestedElements.size();
    }

    @Override
    public IDecisionVariable getNestedElement(int index) {
        return (IDecisionVariable)this.nestedElements.values().toArray()[index];
    }

    @Override
    public IDecisionVariable getNestedElement(String name) {
        return this.nestedElements.get(name);
    }

    @Override
    public void setValue(Value value, IAssignmentState state, IConfigurationElement nested) throws ConfigurationException {
        IDecisionVariable nestedVar = this.getNestedVariable(nested.getDeclaration().getName());
        if (null == nestedVar) {
            nestedVar = this.createNestedElement(nested.getDeclaration(), this.isVisible(), this.isAttribute(), true);
        }
        nestedVar.setValue(value, state);
    }

    @Override
    public void setValue(Value value, IAssignmentState state) throws ConfigurationException {
        super.setValue(value, state);
        if (null != value && value != NullValue.INSTANCE) {
            CompoundValue cmpValue = (CompoundValue)value;
            Compound cmpType = (Compound)DerivedDatatype.resolveToBasis(this.getDeclaration().getType());
            if (!value.getType().equals(cmpType)) {
                HashSet<String> itemNames = new HashSet<String>();
                itemNames.addAll(this.nestedElements.keySet());
                Compound vType = (Compound)value.getType();
                for (int i = 0; i < vType.getInheritedElementCount(); ++i) {
                    DecisionVariableDeclaration nestedItem = vType.getInheritedElement(i);
                    String name = nestedItem.getName();
                    if (!this.nestedElements.containsKey(name)) {
                        VariableCreator creator = new VariableCreator(nestedItem, this, this.isVisible(), this.isAttribute());
                        try {
                            this.nestedElements.put(name, creator.getVariable(false));
                        }
                        catch (ConfigurationException e) {
                            this.getLogger().exception(e);
                        }
                    }
                    itemNames.remove(name);
                }
                for (String name : itemNames) {
                    this.nestedElements.remove(name);
                }
            }
            for (int i = 0; i < cmpType.getInheritedElementCount(); ++i) {
                String slotName = cmpType.getInheritedElement(i).getName();
                if (null == slotName || null == cmpValue.getNestedValue(slotName)) continue;
                IDecisionVariable nestedVar = (DecisionVariable)this.nestedElements.get(slotName);
                Value nestedValue = cmpValue.getNestedValue(slotName);
                if (null == nestedVar) {
                    nestedVar = this.createNestedElement(cmpType.getElement(slotName), this.isVisible(), this.isAttribute(), true);
                }
                if (null == nestedVar) continue;
                IAssignmentState nestedState = nestedVar.getState();
                if (nestedState != AssignmentState.USER_ASSIGNED || state == AssignmentState.USER_ASSIGNED) {
                    nestedVar.setValue(nestedValue, state);
                }
                nestedVar.notifyWasAssigned(nestedValue);
            }
            this.created = true;
        } else if (value == NullValue.INSTANCE) {
            this.created = false;
        }
    }

    public IDecisionVariable getNestedVariable(String slotName) {
        return this.nestedElements.get(slotName);
    }

    @Override
    public void freeze(String nestedElement) {
        IDecisionVariable nestedVar = this.nestedElements.get(nestedElement);
        nestedVar.freeze(AllFreezeSelector.INSTANCE);
    }

    @Override
    public void freeze(IFreezeSelector selector) {
        super.freeze(selector);
        for (IDecisionVariable var : this.nestedElements.values()) {
            var.freeze(selector);
        }
    }

    @Override
    public void unfreeze(IAssignmentState state) {
        super.unfreeze(state);
        for (IDecisionVariable var : this.nestedElements.values()) {
            var.unfreeze(state);
        }
    }

    @Override
    boolean allowsNestedStates() {
        return true;
    }

    @Override
    public Value getValue() {
        Value value = super.getValue();
        if (null == value) {
            try {
                value = ValueFactory.createValue(this.getInstantiatableType(), null);
                this.setValue(value, AssignmentState.UNDEFINED);
            }
            catch (ValueDoesNotMatchTypeException e) {
                e.printStackTrace();
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    @Override
    public boolean removeDerivedValues() {
        boolean changed = false;
        for (IDecisionVariable var : this.nestedElements.values()) {
            if (AssignmentState.ASSIGNED == var.getState()) continue;
            var.removeDerivedValues();
            changed = true;
        }
        return changed;
    }

    @Override
    protected IResolutionPathElement getPathForNestedElement(IDecisionVariable nested) {
        NameAccessPathElement result = null;
        for (Map.Entry<String, IDecisionVariable> entry : this.nestedElements.entrySet()) {
            if (entry.getValue() != nested) continue;
            result = new NameAccessPathElement(this.getResolutionPath(), entry.getKey());
            break;
        }
        return result;
    }

    protected EASyLoggerFactory.EASyLogger getLogger() {
        return EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.varModel");
    }

    @Override
    public void notifyCreated() {
        this.created = true;
    }

    @Override
    public boolean wasCreated() {
        return this.created;
    }

    @Override
    public boolean enableWasAssignedForIsDefined() {
        return true;
    }

    @Override
    public boolean notifyWasAssigned(Value value) {
        boolean old = this.wasAssigned();
        super.notifyWasAssigned(value);
        if (value instanceof CompoundValue) {
            CompoundValue cValue = (CompoundValue)value;
            for (String n : cValue.getSlotNames()) {
                IDecisionVariable var = this.getNestedElement(n);
                if (null == var) continue;
                var.notifyWasAssigned(cValue.getNestedValue(n));
            }
        }
        return old;
    }
}

