/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.confModel;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.varModel.Bundle;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.ModelQueryException;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

public class ConfigQuery {
    static List<ConstraintSyntaxTree> possibleValuesForReferences(Configuration config, Reference refType) {
        ArrayList<ConstraintSyntaxTree> cstValues = new ArrayList<ConstraintSyntaxTree>();
        List<IDecisionVariable> allowedVars = ConfigQuery.collectVariablesByType(config, refType.getType(), false);
        for (IDecisionVariable possibleVar : allowedVars) {
            try {
                cstValues.add(ConfigQuery.toCST(possibleVar));
            }
            catch (ModelQueryException e) {
                Bundle.getLogger(ConfigQuery.class).warn(e.getMessage());
            }
        }
        return cstValues;
    }

    public static List<IDecisionVariable> collectVariablesByType(Configuration config, IDatatype type, boolean onlyToplevel) {
        ArrayList<IDecisionVariable> variables = new ArrayList<IDecisionVariable>();
        for (IDecisionVariable variable : config) {
            ConfigQuery.addVariableByType(variable, type, onlyToplevel, variables);
        }
        return variables;
    }

    private static void addVariableByType(IDecisionVariable variable, IDatatype type, boolean onlyToplevel, List<IDecisionVariable> variables) {
        if (null == type || type.isAssignableFrom(variable.getDeclaration().getType())) {
            variables.add(variable);
        }
        if (!onlyToplevel) {
            int end = variable.getNestedElementsCount();
            for (int i = 0; i < end; ++i) {
                ConfigQuery.addVariableByType(variable.getNestedElement(i), type, onlyToplevel, variables);
            }
        }
    }

    public static ConstraintSyntaxTree toCST(IDecisionVariable variable) throws ModelQueryException {
        ConstraintSyntaxTree result = null;
        if (variable.isNested()) {
            IDecisionVariable parent = (IDecisionVariable)variable.getParent();
            IDatatype parentType = DerivedDatatype.resolveToBasis(parent.getDeclaration().getType());
            if (Compound.TYPE.isAssignableFrom(parentType)) {
                result = new CompoundAccess(ConfigQuery.toCST(parent), variable.getDeclaration().getName());
            } else if (Sequence.TYPE.isAssignableFrom(parentType)) {
                int index = -1;
                int end = parent.getNestedElementsCount();
                for (int i = 0; i < end && index == -1; ++i) {
                    if (parent.getNestedElement(i) != variable) continue;
                    index = i;
                }
                if (index != -1) {
                    try {
                        ConstantValue indexValue = new ConstantValue(ValueFactory.createValue(IntegerType.TYPE, index));
                        result = new OCLFeatureCall(ConfigQuery.toCST(parent), "[]", indexValue);
                        result.inferDatatype();
                    }
                    catch (ValueDoesNotMatchTypeException e) {
                        throw new ModelQueryException("cannot resolve nested element '" + variable.getDeclaration().getName() + "' in parent '" + parent.getDeclaration().getName() + "'", 10151);
                    }
                    catch (CSTSemanticException e) {
                        throw new ModelQueryException("cannot resolve access operation on '" + variable.getDeclaration().getName() + "' in parent '" + parent.getDeclaration().getName() + "'", 10151);
                    }
                }
            } else if (Set.TYPE.isAssignableFrom(parentType)) {
                throw new ModelQueryException("cannot create access statement for nested elements of a set.", 10151);
            }
        } else {
            result = new Variable(variable.getDeclaration());
        }
        return result;
    }
}

