/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.confModel;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.messages.Message;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.modelManagement.IModelProcessingListener;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.varModel.confModel.AllFreezeSelector;
import net.ssehub.easy.varModel.confModel.AssignmentResolver;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.ConfigurationInitializerRegistry;
import net.ssehub.easy.varModel.confModel.ConfigurationSaver;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.ICollectionElementVariable;
import net.ssehub.easy.varModel.confModel.IConfiguration;
import net.ssehub.easy.varModel.confModel.IConfigurationChangeListener;
import net.ssehub.easy.varModel.confModel.IConfigurationElement;
import net.ssehub.easy.varModel.confModel.IConfigurationVisitable;
import net.ssehub.easy.varModel.confModel.IConfigurationVisitor;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.confModel.IFreezeSelector;
import net.ssehub.easy.varModel.confModel.QueryCache;
import net.ssehub.easy.varModel.confModel.SharedQueryCache;
import net.ssehub.easy.varModel.confModel.VariableCreator;
import net.ssehub.easy.varModel.cstEvaluation.FreezeEvaluator;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.IFreezable;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IProjectListener;
import net.ssehub.easy.varModel.model.ModelQuery;
import net.ssehub.easy.varModel.model.ModelQueryException;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.filter.DeclarationFinder;
import net.ssehub.easy.varModel.model.filter.FilterType;
import net.ssehub.easy.varModel.model.filter.FrozenElementsFinder;
import net.ssehub.easy.varModel.model.rewrite.ProjectCopyVisitor;
import net.ssehub.easy.varModel.model.rewrite.ProjectRewriteVisitor;
import net.ssehub.easy.varModel.model.rewrite.modifier.FrozenCompoundConstraintsOmitter;
import net.ssehub.easy.varModel.model.rewrite.modifier.FrozenConstraintVarFilter;
import net.ssehub.easy.varModel.model.rewrite.modifier.FrozenConstraintsFilter;
import net.ssehub.easy.varModel.model.rewrite.modifier.FrozenTypeDefResolver;
import net.ssehub.easy.varModel.model.rewrite.modifier.ModelElementFilter;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

public class Configuration
implements IConfigurationVisitable,
IProjectListener,
Iterable<IDecisionVariable>,
IConfigurationElement,
IConfiguration {
    static final ConfigurationInitializerRegistry.IConfigurationInitializer DEFAULT_INITIALIZER = new ConfigurationInitializerRegistry.IConfigurationInitializer(){

        @Override
        public List<Message> initializeConfiguration(Configuration config, ProgressObserver observer) {
            AssignmentResolver resolver = new AssignmentResolver(config);
            resolver.resolve();
            config.freezeValues(config.project, FilterType.ALL);
            config.approximativeFreezing = true;
            return null;
        }

        @Override
        public boolean supportsElementCopy() {
            return false;
        }

        @Override
        public boolean resolveDefaultValue(IDecisionVariable variable) {
            return AssignmentResolver.resolveDefaultValue(variable);
        }
    };
    private Project project;
    private boolean assignValues;
    private boolean approximativeFreezing;
    private LinkedHashMap<AbstractVariable, IDecisionVariable> decisions = new LinkedHashMap();
    private List<IConfigurationChangeListener> listeners;
    private Map<IDatatype, Map<IDecisionVariable, ReferenceValue>> allInstances;
    private IAssignmentState resolutionState = AssignmentState.ASSIGNED;
    private QueryCache cache;

    public Configuration(Project project) {
        this(project, true, AssignmentState.ASSIGNED);
    }

    public Configuration(Project project, IAssignmentState resolutionState) {
        this(project, true, resolutionState);
    }

    public Configuration(Configuration configuration) {
        this.project = configuration.getProject();
        this.resolutionState = configuration.getResolutionState();
        this.cache = new QueryCache(this);
        VarModel.INSTANCE.events().addModelListener(this.project, this);
        this.listeners = new ArrayList<IConfigurationChangeListener>();
        if (null != this.project) {
            this.createVariables();
            for (Map.Entry<AbstractVariable, IDecisionVariable> entry : configuration.decisions.entrySet()) {
                IDecisionVariable newVar = this.getDecision(entry.getKey());
                if (null == newVar) continue;
                IDecisionVariable oldVar = entry.getValue();
                Value value = oldVar.getValue();
                if (null != value) {
                    value = value.clone();
                }
                try {
                    newVar.setValue(value, oldVar.getState());
                }
                catch (ConfigurationException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(Configuration.class, "net.ssehub.easy.varModel").exception(e);
                }
            }
        }
    }

    public Configuration(Project project, boolean assignValues) {
        this(project, assignValues, AssignmentState.ASSIGNED);
    }

    public Configuration(Project project, boolean assignValues, IAssignmentState resolutionState) {
        this.project = project;
        this.assignValues = assignValues;
        this.resolutionState = resolutionState;
        this.cache = new QueryCache(this);
        VarModel.INSTANCE.events().addModelListener(project, this);
        this.listeners = new ArrayList<IConfigurationChangeListener>();
        this.init();
    }

    @Override
    public boolean wasCreated() {
        return true;
    }

    public IAssignmentState getResolutionState() {
        return this.resolutionState;
    }

    public Project getProject() {
        return this.project;
    }

    public boolean isApproximatelyFrozen() {
        return this.approximativeFreezing;
    }

    Map<AbstractVariable, IDecisionVariable> getConfiguredDecisions() {
        return (Map)this.decisions.clone();
    }

    public void register(IConfigurationChangeListener listener) {
        this.listeners.add(listener);
    }

    public boolean unregister(IConfigurationChangeListener listener) {
        return this.listeners.remove(listener);
    }

    private ModelInfo<Project> getModelInfo() {
        return VarModel.INSTANCE.availableModels().getModelInfo(this.project);
    }

    private void init() {
        if (null != this.project) {
            ModelInfo<Project> info = this.getModelInfo();
            VarModel.INSTANCE.events().notifyModelProcessing(info, true, IModelProcessingListener.Type.INITIALIZING);
            VarModel.INSTANCE.resolveImports(this.project, null, null);
            this.createVariables();
            if (this.assignValues) {
                ConfigurationInitializerRegistry.IConfigurationInitializer init = ConfigurationInitializerRegistry.getInitializer();
                if (null == init) {
                    EASyLoggerFactory.INSTANCE.getLogger(Configuration.class, "net.ssehub.easy.varModel").error("No configuration initializer available");
                } else {
                    EASyLoggerFactory.INSTANCE.getLogger(Configuration.class, "net.ssehub.easy.varModel").info("Initializing configuration with: " + init.getClass().getName());
                    String msg = Message.toString(init.initializeConfiguration(this, ProgressObserver.NO_OBSERVER), Status.ERROR);
                    if (msg.length() > 0) {
                        EASyLoggerFactory.INSTANCE.getLogger(Configuration.class, "net.ssehub.easy.varModel").error(msg);
                    }
                }
            } else {
                EASyLoggerFactory.INSTANCE.getLogger(Configuration.class, "net.ssehub.easy.varModel").info("Not initializing configuration");
            }
            VarModel.INSTANCE.events().notifyModelProcessing(info, false, IModelProcessingListener.Type.INITIALIZING);
        }
    }

    private void createVariables() {
        DeclarationFinder finder = new DeclarationFinder(this.project, FilterType.ALL, null);
        List<AbstractVariable> topLevelDeclarations = finder.getVariableDeclarations(DeclarationFinder.VisibilityType.ONLY_EXPORTED);
        this.addVariables(topLevelDeclarations, true);
        topLevelDeclarations = finder.getVariableDeclarations(DeclarationFinder.VisibilityType.ONLY_HIDDEN);
        this.addVariables(topLevelDeclarations, false);
    }

    private void addVariables(List<AbstractVariable> topLevelDeclarations, boolean visible) {
        for (int i = 0; i < topLevelDeclarations.size(); ++i) {
            AbstractVariable declaration = topLevelDeclarations.get(i);
            try {
                this.createDecision(declaration, visible);
                continue;
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
        }
    }

    public IDecisionVariable createDecision(AbstractVariable decl) throws ConfigurationException {
        IDecisionVariable result = null;
        if (decl.getParent() instanceof Project && null == this.getDecision(decl)) {
            result = this.createDecision(decl, true);
        }
        return result;
    }

    private IDecisionVariable createDecision(AbstractVariable decl, boolean visible) throws ConfigurationException {
        VariableCreator creator = new VariableCreator(decl, this, visible, false);
        IDecisionVariable variable = creator.getVariable();
        this.addDecision(variable);
        if (null != this.allInstances) {
            this.allInstances.remove(decl.getType());
        }
        return variable;
    }

    public void freezeValues(Project project, FilterType filter) {
        FrozenElementsFinder finder = new FrozenElementsFinder(project, filter);
        List<IFreezable> frozenElements = finder.getFrozenElements();
        FreezeEvaluator selector = new FreezeEvaluator(this);
        for (int i = 0; i < frozenElements.size(); ++i) {
            IFreezable frozenElement = frozenElements.get(i);
            selector.setFreeze(finder.getFreezeBlock(frozenElement));
            if (frozenElement instanceof AbstractVariable) {
                this.freezeValues((AbstractVariable)((Object)frozenElement), selector);
                continue;
            }
            if (!(frozenElement instanceof Project)) continue;
            Project prj = (Project)frozenElement;
            for (int e = 0; e < prj.getElementCount(); ++e) {
                ContainableModelElement elt = prj.getElement(e);
                if (!(elt instanceof AbstractVariable)) continue;
                this.freezeValues((AbstractVariable)elt, selector);
            }
        }
    }

    private void freezeValues(AbstractVariable var, IFreezeSelector selector) {
        if (var.isTopLevel() || var.getParent() instanceof AttributeAssignment) {
            IDecisionVariable frozenVariable = this.getDecision(var);
            if (null != frozenVariable) {
                frozenVariable.freeze(selector);
            }
        } else {
            IModelElement parent = var.getParent();
            System.out.println("Config freeze for nested variable not implemented: " + parent);
        }
    }

    public void refresh() {
        ModelInfo<Project> info = this.getModelInfo();
        VarModel.INSTANCE.events().notifyModelProcessing(info, true, IModelProcessingListener.Type.REFRESHING);
        this.decisions.clear();
        this.allInstances = null;
        this.init();
        this.cache.clear();
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).configurationRefreshed(this);
        }
        VarModel.INSTANCE.events().notifyModelProcessing(info, false, IModelProcessingListener.Type.REFRESHING);
    }

    public QueryCache getQueryCache() {
        return this.cache;
    }

    private void addDecision(IDecisionVariable variable) {
        this.decisions.put(variable.getDeclaration(), variable);
    }

    public int getDecisionCount() {
        return this.decisions.size();
    }

    @Override
    public IDecisionVariable getDecision(AbstractVariable declaration) {
        IDecisionVariable result = this.decisions.get(declaration);
        if (null == result && declaration instanceof ICollectionElementVariable) {
            result = ((ICollectionElementVariable)((Object)declaration)).resolve(this);
        }
        return result;
    }

    @Override
    public Iterator<IDecisionVariable> iterator() {
        Collection<IDecisionVariable> variableCollection = this.decisions.values();
        return variableCollection.iterator();
    }

    public void clear() {
        this.decisions.clear();
        this.allInstances = null;
    }

    public boolean removeDecision(IDecisionVariable variable) {
        boolean containsKey = this.decisions.containsKey(variable.getDeclaration());
        this.decisions.remove(variable.getDeclaration());
        if (null != this.allInstances) {
            this.removeFromAllInstances(variable);
        }
        return containsKey;
    }

    private void removeFromAllInstances(IDecisionVariable variable) {
        Map<IDecisionVariable, ReferenceValue> inst = this.allInstances.get(variable.getDeclaration().getType());
        if (null != inst) {
            inst.remove(variable);
        }
    }

    public String getName() {
        return this.project.getName();
    }

    @Override
    public void accept(IConfigurationVisitor visitor) {
        visitor.visitConfiguration(this);
    }

    @Override
    public void notifyReplaced(Project oldProject, Project newProject) {
        this.project = newProject;
        this.refresh();
    }

    public Project toProject(boolean ownProject) throws ConfigurationException {
        return this.toProject(ownProject, true);
    }

    public Project toProject(boolean ownProject, boolean onlyUserInput) throws ConfigurationException {
        ConfigurationSaver saver = new ConfigurationSaver(this, ownProject, onlyUserInput);
        return saver.getSavedConfiguration();
    }

    @Override
    public final Configuration getConfiguration() {
        return this;
    }

    @Override
    public IConfigurationElement getParent() {
        return null;
    }

    void variableChanged(IDecisionVariable var, Value oldValue) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).itemChanged(this, var, oldValue);
        }
        if (null != this.allInstances) {
            this.allInstancesVariableChanged(var);
        }
    }

    private void allInstancesVariableChanged(IDecisionVariable var) {
        IDatatype type = var.getDeclaration().getType();
        Map<IDecisionVariable, ReferenceValue> instances = this.allInstances.get(type);
        if (null != instances) {
            if (NullValue.INSTANCE == var.getValue()) {
                instances.remove(var);
            } else if (!instances.containsKey(var)) {
                Reference rType = new Reference("", type, this.project);
                try {
                    instances.put(var, (ReferenceValue)ValueFactory.createValue(rType, var.getDeclaration()));
                }
                catch (ValueDoesNotMatchTypeException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.varModel").exception(e);
                }
            }
        }
        for (int n = 0; n < var.getNestedElementsCount(); ++n) {
            this.allInstancesVariableChanged(var.getNestedElement(n));
        }
    }

    void variableChangedState(IDecisionVariable var) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).stateChanged(this, var);
        }
    }

    protected void addAttributeDecision(Attribute attribute, Value value, IAssignmentState state) throws ConfigurationException {
        VariableCreator creator = new VariableCreator(attribute, this, true, false);
        IDecisionVariable var = creator.getVariable();
        var.setValue(value, state);
        this.decisions.put(attribute, var);
    }

    @Override
    public boolean isNested() {
        return false;
    }

    @Override
    public IAssignmentState getState() {
        return null;
    }

    @Override
    public void setValue(Value value, IAssignmentState state, IConfigurationElement nested) throws ConfigurationException {
        throw new ConfigurationException(this.getConfiguration(), "operation not supported", 19003);
    }

    @Override
    public AbstractVariable getDeclaration() {
        return null;
    }

    @Override
    public void freeze(IFreezeSelector selector) {
        for (IDecisionVariable variable : this.decisions.values()) {
            variable.freeze(selector);
        }
    }

    @Override
    public void unfreeze(IAssignmentState state) {
        for (IDecisionVariable variable : this.decisions.values()) {
            this.unfreezeVariable(variable, state);
        }
    }

    private void unfreezeVariable(IDecisionVariable variable, IAssignmentState state) {
        if (variable.getNestedElementsCount() > 0) {
            int n = variable.getNestedElementsCount();
            for (int i = 0; i < n; ++i) {
                this.unfreezeVariable(variable.getNestedElement(i), state);
            }
        }
        variable.unfreeze(state);
    }

    @Override
    public void freeze(String nestedElement) {
        for (IDecisionVariable nestedVariable : this.decisions.values()) {
            if (!nestedVariable.getDeclaration().getName().equals(nestedElement)) continue;
            nestedVariable.freeze(AllFreezeSelector.INSTANCE);
        }
    }

    public static IDecisionVariable dereference(IDecisionVariable var) {
        if (null != var && null != var.getConfiguration()) {
            AbstractVariable varDecl = var.getDeclaration();
            IDatatype type = varDecl.getType();
            while (type instanceof Reference) {
                type = ((Reference)type).getType();
                Value value = var.getValue();
                if (null == value || value == NullValue.INSTANCE) break;
                AbstractVariable refDecl = ((ReferenceValue)var.getValue()).getValue();
                if (null == refDecl) continue;
                IDecisionVariable res = var.getConfiguration().getDecision(refDecl);
                if (null == res) {
                    res = Configuration.findInParents(var, refDecl.getName());
                }
                var = res;
            }
        }
        return var;
    }

    public static IDecisionVariable findInParents(IDecisionVariable var, String name) {
        IDecisionVariable res = null;
        IConfigurationElement iter = var.getParent();
        while (res == null && iter instanceof IDecisionVariable) {
            res = ((IDecisionVariable)iter).getNestedElement(name);
            iter = iter.getParent();
        }
        return res;
    }

    public IDecisionVariable getDecision(String varName, boolean dereference) throws ModelQueryException {
        return this.getDecision(null, varName, dereference);
    }

    private IDecisionVariable getDecision(IDecisionVariable var, String varName, boolean dereference) throws ModelQueryException {
        IDecisionVariable result = null;
        int pos = varName.indexOf(46);
        String name = varName;
        String rest = null;
        if (pos >= 0) {
            name = varName.substring(0, pos);
            rest = varName.substring(pos + 1);
        }
        if (null != var) {
            result = var.getNestedElement(name);
        } else {
            AbstractVariable v = ModelQuery.findVariable(this.getProject(), name, null);
            if (null != v) {
                result = this.getDecision(v);
            }
        }
        if (null != result && dereference) {
            result = Configuration.dereference(result);
        }
        if (null != result && null != rest) {
            result = this.getDecision(result, rest, dereference);
        }
        return result;
    }

    @Override
    public Value getAllInstances(IDatatype type) {
        ContainerValue result;
        if (null == this.allInstances) {
            this.allInstances = new LinkedHashMap<IDatatype, Map<IDecisionVariable, ReferenceValue>>();
        }
        Map<IDecisionVariable, ReferenceValue> instances = this.allInstances.get(type);
        HashMap<IDatatype, Reference> referenceTypes = new HashMap<IDatatype, Reference>();
        Reference rType = new Reference("", type, this.project);
        referenceTypes.put(type, rType);
        if (null == instances && Compound.TYPE.isAssignableFrom(type)) {
            instances = new HashMap<IDecisionVariable, ReferenceValue>();
            this.allInstances.put(type, instances);
            for (IDecisionVariable var : this.decisions.values()) {
                this.collectAllInstances(var, type, referenceTypes, instances);
            }
        }
        Set setType = new Set(type.getName() + "Instances", rType, null);
        try {
            result = new ContainerValue((Container)setType, false, null == instances ? null : instances.values().toArray());
        }
        catch (ValueDoesNotMatchTypeException e) {
            result = null;
        }
        return result;
    }

    private void collectAllInstances(IDecisionVariable var, IDatatype type, Map<IDatatype, Reference> referenceTypes, Map<IDecisionVariable, ReferenceValue> instances) {
        AbstractVariable decl = var.getDeclaration();
        IDatatype varType = decl.getType();
        if (type.isAssignableFrom(varType) && NullValue.INSTANCE != var.getValue()) {
            try {
                Reference refType = referenceTypes.get(varType);
                if (null == refType) {
                    refType = new Reference("", varType, this.project);
                    referenceTypes.put(varType, refType);
                }
                instances.put(var, (ReferenceValue)ValueFactory.createValue(refType, decl));
            }
            catch (ValueDoesNotMatchTypeException e) {
                e.printStackTrace();
            }
        } else {
            for (int n = 0; n < var.getNestedElementsCount(); ++n) {
                this.collectAllInstances(var.getNestedElement(n), type, referenceTypes, instances);
            }
        }
    }

    public static IDecisionVariable mapVariable(IDecisionVariable var, Configuration cfg) {
        IDecisionVariable result = null;
        if (var.getParent() instanceof IDecisionVariable) {
            IDecisionVariable par = Configuration.mapVariable((IDecisionVariable)var.getParent(), cfg);
            if (null != par) {
                AbstractVariable decl = var.getDeclaration();
                for (int p = 0; null == result && p < par.getNestedElementsCount(); ++p) {
                    IDecisionVariable nested = par.getNestedElement(p);
                    if (!nested.getDeclaration().equals(decl)) continue;
                    result = nested;
                }
            }
        } else {
            result = cfg.getDecision(var.getDeclaration());
        }
        return result;
    }

    public static String getInstanceName(IDecisionVariable var) {
        return Configuration.getInstanceName(var, false);
    }

    public static String getInstanceName(IDecisionVariable var, boolean qualified) {
        String result = "";
        for (IConfigurationElement iter = var; null != iter; iter = iter.getParent()) {
            if (!(iter instanceof IDecisionVariable)) continue;
            IDecisionVariable decVar = iter;
            if (result.length() > 0) {
                result = "::" + result;
            }
            String name = qualified && !(iter.getParent() instanceof IDecisionVariable) ? decVar.getDeclaration().getQualifiedName() : decVar.getDeclaration().getName();
            result = name + result;
        }
        return result;
    }

    public static boolean equalsByInstanceName(IDecisionVariable var1, IDecisionVariable var2) {
        boolean equals;
        if (var1 != null && var2 != null) {
            equals = true;
            IConfigurationElement iter1 = var1;
            IConfigurationElement iter2 = var2;
            do {
                if (!iter1.getDeclaration().getName().equals(iter2.getDeclaration().getName())) {
                    equals = false;
                    break;
                }
                iter1 = iter1.getParent();
                iter2 = iter2.getParent();
            } while (iter1 instanceof IDecisionVariable && iter2 instanceof IDecisionVariable);
        } else {
            equals = false;
        }
        return equals;
    }

    public static void printConfig(PrintStream out, Configuration cfg) {
        for (IDecisionVariable var : cfg) {
            Configuration.printVariable(out, var, "");
        }
    }

    private static void printVariable(PrintStream out, IDecisionVariable var, String indent) {
        out.println(indent + var.getDeclaration().getName() + " = " + var.getValue() + " STATE " + var.getState());
        for (int i = 0; i < var.getNestedElementsCount(); ++i) {
            Configuration.printVariable(out, var.getNestedElement(i), indent + " ");
        }
        for (int a = 0; a < var.getAttributesCount(); ++a) {
            Configuration.printVariable(out, var.getAttribute(a), indent + " ");
        }
    }

    public void removeDerivedValues() {
        boolean changed = false;
        for (IDecisionVariable variable : this.decisions.values()) {
            changed &= variable.removeDerivedValues();
        }
        if (changed) {
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                this.listeners.get(i).configurationRefreshed(this);
            }
        }
    }

    public void prune() {
        ProjectCopyVisitor copier = new ProjectCopyVisitor(this.project, FilterType.ALL);
        this.project.accept(copier);
        this.project = copier.getCopiedProject();
        ProjectRewriteVisitor rewriter = new ProjectRewriteVisitor(this.project, FilterType.ALL);
        rewriter.addModelCopyModifier(new ModelElementFilter(Comment.class));
        rewriter.addModelCopyModifier(new FrozenConstraintsFilter(this));
        rewriter.addModelCopyModifier(new FrozenTypeDefResolver(this));
        rewriter.addModelCopyModifier(new FrozenConstraintVarFilter(this));
        rewriter.addModelCopyModifier(new FrozenCompoundConstraintsOmitter(this));
        this.project.accept(rewriter);
    }

    public void shareQueryCacheWith(Configuration configToShare) {
        configToShare.cache = new SharedQueryCache(this.cache);
    }

    public static IDecisionVariable getNestedElement(IDecisionVariable base, String name) {
        IDecisionVariable result = null;
        if (null != base) {
            int c = base.getNestedElementsCount();
            for (int n = 0; null == result && n < c; ++n) {
                IDecisionVariable nested = base.getNestedElement(n);
                if (!name.equals(nested.getDeclaration().getName())) continue;
                result = nested;
            }
        }
        return result;
    }

    public static IDecisionVariable getTopLevelDecision(IDecisionVariable var) {
        IConfigurationElement top;
        for (top = var; null != top && !(top.getParent() instanceof IConfiguration); top = top.getParent()) {
        }
        return top instanceof IDecisionVariable ? top : null;
    }

    public static Value dereference(IConfiguration conf, Value value) {
        while (value instanceof ReferenceValue) {
            IDecisionVariable var = conf.getDecision(((ReferenceValue)value).getValue());
            if (null == var) continue;
            value = var.getValue();
        }
        return value;
    }
}

