/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.confModel;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.varModel.Bundle;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.DecisionVariable;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IConfigurationElement;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.confModel.IFreezeSelector;
import net.ssehub.easy.varModel.confModel.StructuredVariable;
import net.ssehub.easy.varModel.confModel.VariableCreator;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

public abstract class ContainerVariable
extends StructuredVariable {
    private List<IDecisionVariable> nestedElements;

    protected ContainerVariable(IConfigurationElement parent, AbstractVariable varDeclaration, boolean isVisible, boolean isAttribute) {
        super(parent, varDeclaration, isVisible, isAttribute);
        if (null == this.nestedElements) {
            this.nestedElements = new ArrayList<IDecisionVariable>();
        }
    }

    void clear() {
        this.nestedElements.clear();
    }

    @Override
    public int getNestedElementsCount() {
        return null == this.nestedElements ? 0 : this.nestedElements.size();
    }

    @Override
    public IDecisionVariable getNestedElement(int index) {
        return this.nestedElements.get(index);
    }

    public int indexOf(IDecisionVariable var) {
        return this.nestedElements.indexOf(var);
    }

    @Override
    public void setValue(Value value, IAssignmentState state, IConfigurationElement nested) throws ConfigurationException {
        this.nestedElements.clear();
        ContainerValue conValue = (ContainerValue)value;
        IDatatype type = DerivedDatatype.resolveToBasis(this.getDeclaration().getType());
        type = ((Container)type).getContainedType();
        for (int i = 0; null != conValue && i < conValue.getElementSize(); ++i) {
            String name = this.getElementName(i);
            Value eltValue = conValue.getElement(i);
            DecisionVariableDeclaration decl = new DecisionVariableDeclaration(name, eltValue.getType(), this.getDeclaration());
            VariableCreator creator = new VariableCreator(decl, this, this.isVisible(), false);
            IDecisionVariable var = creator.getVariable();
            var.setValue(eltValue, state);
            eltValue.setValueParent(var);
            this.nestedElements.add(var);
        }
    }

    @Override
    public void setValue(Value value, IAssignmentState state) throws ConfigurationException {
        ContainerValue conValue = null;
        if (value == NullValue.INSTANCE) {
            this.nestedElements.clear();
        } else {
            conValue = (ContainerValue)value;
            IDatatype type = DerivedDatatype.resolveToBasis(this.getDeclaration().getType());
            type = ((Container)type).getContainedType();
            if (conValue != null) {
                while (this.nestedElements.size() > conValue.getElementSize()) {
                    this.nestedElements.remove(0);
                }
                for (int i = 0; i < conValue.getElementSize(); ++i) {
                    boolean createNewVar = true;
                    if (this.nestedElements.size() > i) {
                        IDecisionVariable oldVar = this.nestedElements.get(i);
                        Value trgValue = conValue.getElement(i);
                        boolean bl = createNewVar = null == trgValue || !trgValue.equals(oldVar.getValue());
                        if (createNewVar) {
                            boolean bl2 = createNewVar = AssignmentState.USER_ASSIGNED != oldVar.getState() || AssignmentState.USER_ASSIGNED == state;
                        }
                    }
                    if (!createNewVar) continue;
                    String name = this.getElementName(i);
                    IDatatype eltType = conValue.getElement(i).getType();
                    DecisionVariableDeclaration decl = new DecisionVariableDeclaration(name, eltType, this.getDeclaration());
                    VariableCreator creator = new VariableCreator(decl, this, this.isVisible(), false);
                    try {
                        IDecisionVariable var = creator.getVariable();
                        this.addNestedElement(var);
                        continue;
                    }
                    catch (ConfigurationException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        super.setValue(value, state);
        if (conValue != null) {
            for (int i = 0; i < conValue.getElementSize(); ++i) {
                IDecisionVariable nestedVariable = this.getNestedElement(i);
                if (AssignmentState.USER_ASSIGNED == nestedVariable.getState() && state != AssignmentState.USER_ASSIGNED) continue;
                Value nestedValue = conValue.getElement(i);
                nestedVariable.setValue(nestedValue, state);
                nestedValue.setValueParent(nestedVariable);
            }
        }
    }

    @Override
    public void freeze(IFreezeSelector selector) {
        super.freeze(selector);
        for (IDecisionVariable var : this.nestedElements) {
            var.freeze(selector);
        }
    }

    @Override
    public void freeze(String nestedElement) {
    }

    @Override
    boolean allowsNestedStates() {
        return true;
    }

    protected String getElementName(int index) {
        return "" + index;
    }

    public IDecisionVariable addNestedElement() {
        return this.addNestedElement((IDatatype)null);
    }

    public IDatatype getContainedType() {
        return ((Container)DerivedDatatype.resolveToBasis(this.getDeclaration().getType())).getContainedType();
    }

    public IDecisionVariable addNestedElement(IDatatype type) {
        if (null == this.getValue()) {
            try {
                Value containerValue = ValueFactory.createValue(this.getDeclaration().getType(), null);
                this.setValue(containerValue, AssignmentState.UNDEFINED);
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
            catch (ValueDoesNotMatchTypeException e) {
                e.printStackTrace();
            }
        }
        IDecisionVariable result = null;
        IDatatype baseType = this.getContainedType();
        if (null == type || !baseType.isAssignableFrom(type)) {
            type = baseType;
        }
        int elementPos = this.nestedElements.size();
        try {
            String name = this.getElementName(elementPos);
            DecisionVariableDeclaration decl = new DecisionVariableDeclaration(name, type, this.getDeclaration());
            VariableCreator creator = new VariableCreator(decl, this, this.isVisible(), false);
            result = creator.getVariable(false);
            this.addNestedElement(result);
            Value nullValue = ValueFactory.createValue(type, null);
            result.setValue(nullValue, AssignmentState.UNDEFINED);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        catch (ValueDoesNotMatchTypeException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean removeNestedElement(IDecisionVariable var) {
        int index = this.nestedElements.indexOf(var);
        if (-1 != index) {
            int i;
            this.nestedElements.remove(index);
            Object[] copiedValues = new Object[this.nestedElements.size()];
            for (i = 0; i < this.nestedElements.size(); ++i) {
                copiedValues[i] = this.nestedElements.get(i).getValue();
            }
            for (i = index; i < this.nestedElements.size(); ++i) {
                ((DecisionVariable)this.nestedElements.get(i)).setIndex(i);
            }
            try {
                Value newValue = ValueFactory.createValue(this.getDeclaration().getType(), copiedValues);
                super.setValue(newValue, AssignmentState.ASSIGNED);
            }
            catch (ValueDoesNotMatchTypeException e) {
                Bundle.getLogger(ContainerValue.class).exception(e);
            }
            catch (ConfigurationException e) {
                Bundle.getLogger(ContainerValue.class).exception(e);
            }
        }
        return -1 != index;
    }

    @Override
    public IAssignmentState getState() {
        IAssignmentState state = super.getState();
        if (state != AssignmentState.FROZEN && this.ownStateAllowed() && this.getValue() != NullValue.INSTANCE) {
            if (this.getValue() == null || null == this.getValue().getValue()) {
                state = AssignmentState.UNDEFINED;
            } else if (state == AssignmentState.UNDEFINED && this.nestedElements.size() > 0) {
                state = AssignmentState.ASSIGNED;
            }
        }
        return state;
    }

    void addNestedElement(IDecisionVariable var) {
        boolean found = false;
        for (int i = 0; i < this.getNestedElementsCount() && !found; ++i) {
            IDecisionVariable oldVar = this.nestedElements.get(i);
            if (!oldVar.getDeclaration().getName().equals(var.getDeclaration().getName())) continue;
            found = true;
            this.nestedElements.set(i, var);
        }
        if (!found) {
            if (null == this.nestedElements) {
                this.nestedElements = new ArrayList<IDecisionVariable>();
            }
            this.nestedElements.add(var);
        }
    }

    @Override
    public boolean removeDerivedValues() {
        int i;
        boolean changed = false;
        IAssignmentState oldState = this.getState();
        ArrayList<IDecisionVariable> copiedValues = new ArrayList<IDecisionVariable>();
        int n = this.nestedElements.size();
        for (i = 0; i < n; ++i) {
            if (AssignmentState.DERIVED == this.nestedElements.get(i).getState()) continue;
            copiedValues.add(this.nestedElements.get(i));
        }
        if (copiedValues.isEmpty()) {
            try {
                this.setValue(null, AssignmentState.UNDEFINED);
                changed = true;
            }
            catch (ConfigurationException e) {
                Bundle.getLogger(ContainerValue.class).exception(e);
            }
        } else if (copiedValues.size() < this.nestedElements.size()) {
            for (i = 0; i < copiedValues.size(); ++i) {
                ((DecisionVariable)copiedValues.get(i)).setIndex(i);
            }
            try {
                Value newValue = ValueFactory.createValue(this.getDeclaration().getType(), copiedValues.toArray());
                super.setValue(newValue, oldState);
            }
            catch (ValueDoesNotMatchTypeException e) {
                Bundle.getLogger(ContainerValue.class).exception(e);
            }
            catch (ConfigurationException e) {
                Bundle.getLogger(ContainerValue.class).exception(e);
            }
            changed = true;
        }
        if (!this.nestedElements.isEmpty()) {
            n = this.nestedElements.size();
            for (int i2 = 0; i2 < n; ++i2) {
                changed &= this.nestedElements.get(i2).removeDerivedValues();
            }
        }
        return changed;
    }

    @Override
    public boolean notifyWasAssigned(Value value) {
        boolean old = this.wasAssigned();
        super.notifyWasAssigned(value);
        if (value instanceof ContainerValue) {
            ContainerValue cValue = (ContainerValue)value;
            for (int n = 0; n < Math.min(this.getNestedElementsCount(), cValue.getElementSize()); ++n) {
                this.getNestedElement(n).notifyWasAssigned(cValue.getElement(n));
            }
        }
        return old;
    }
}

