/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.confModel;

import java.util.HashMap;
import java.util.Map;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.CommandAssignmentState;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.ContainerItemConfigProvider;
import net.ssehub.easy.varModel.confModel.ContainerVariable;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IConfigurationElement;
import net.ssehub.easy.varModel.confModel.IConfigurationVisitor;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.confModel.IFreezeSelector;
import net.ssehub.easy.varModel.confModel.VariableConfigProvider;
import net.ssehub.easy.varModel.confModel.VariableConfigProviderFactory;
import net.ssehub.easy.varModel.confModel.VariableCreator;
import net.ssehub.easy.varModel.confModel.paths.IResolutionPathElement;
import net.ssehub.easy.varModel.confModel.paths.IndexAccessPathElement;
import net.ssehub.easy.varModel.confModel.paths.StartPathElement;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.AnnotationVisitor;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IAttributeAccess;
import net.ssehub.easy.varModel.model.IvmlException;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.Value;

abstract class DecisionVariable
implements IDecisionVariable {
    private IConfigurationElement parent;
    private VariableConfigProvider configProvider;
    private AbstractVariable declaration;
    private IDecisionVariable[] attributes = new IDecisionVariable[0];
    private boolean isVisible;
    private boolean isAttribute;
    private boolean wasAssigned;

    protected DecisionVariable(IConfigurationElement parent, AbstractVariable varDeclaration, boolean isVisible, boolean isAttribute) {
        this.declaration = varDeclaration;
        this.parent = parent;
        this.isVisible = isVisible;
        this.isAttribute = isAttribute;
        this.configProvider = VariableConfigProviderFactory.createDelegate(this);
        if (!isAttribute) {
            try {
                new InitializationAnnotationVisitor().visitAnnotations(varDeclaration);
            }
            catch (IvmlException e) {
                EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.varModel").exception(e);
            }
        }
    }

    @Override
    public int getAttributesCount() {
        return this.attributes.length;
    }

    @Override
    public IDecisionVariable getAttribute(int index) {
        return this.attributes[index];
    }

    @Override
    public final boolean isNested() {
        return !(this.parent instanceof Configuration);
    }

    @Override
    public final IConfigurationElement getParent() {
        return this.parent;
    }

    @Override
    public final Configuration getConfiguration() {
        Configuration config = null;
        config = this.isNested() ? this.parent.getConfiguration() : (Configuration)this.parent;
        return config;
    }

    @Override
    public void accept(IConfigurationVisitor visitor) {
        visitor.visitDecisionVariable(this);
    }

    @Override
    public Value getValue() {
        Value returnValue = null;
        if (this.configProvider != null) {
            returnValue = this.configProvider.getValue();
        }
        return returnValue;
    }

    @Override
    public void setValue(Value value, IAssignmentState state) throws ConfigurationException {
        this.wasAssigned = state != AssignmentState.UNDEFINED;
        this.configProvider.setValue(value, state);
    }

    @Override
    public void setValue(Value value, IAssignmentState state, boolean asAssignment) throws ConfigurationException {
        this.setValue(value, state);
    }

    @Override
    public IDecisionVariable getNestedElement(String name) {
        return Configuration.getNestedElement(this, name);
    }

    @Override
    public IAssignmentState getState() {
        return this.configProvider.getState();
    }

    @Override
    public AbstractVariable getDeclaration() {
        return this.declaration;
    }

    @Override
    public void freeze(IFreezeSelector selector) {
        if (null == selector || selector.shallFreeze(this)) {
            this.configProvider.freeze(selector);
            for (int a = 0; a < this.getAttributesCount(); ++a) {
                this.getAttribute(a).freeze(selector);
            }
        }
    }

    @Override
    public void unfreeze(IAssignmentState state) {
        if (CommandAssignmentState.ASSIGNED_CLEAR == state) {
            this.wasAssigned = false;
            state = AssignmentState.ASSIGNED;
        }
        this.configProvider.unfreeze(state);
        for (int a = 0; a < this.getAttributesCount(); ++a) {
            this.getAttribute(a).unfreeze(state);
        }
    }

    public String toString() {
        String result = this.declaration.getName();
        if (null != this.getValue()) {
            result = result + " = " + this.getValue().toString();
        }
        return result;
    }

    @Override
    public final int getNestedDepth() {
        int depth = 0;
        if (this.isNested()) {
            IDecisionVariable parent = (IDecisionVariable)this.parent;
            depth = parent.getNestedDepth() + 1;
        }
        return depth;
    }

    void setIndex(int newIndex) {
        if (this.configProvider instanceof ContainerItemConfigProvider) {
            ContainerItemConfigProvider conItemProvider = (ContainerItemConfigProvider)this.configProvider;
            ContainerVariable parent = conItemProvider.getParent();
            String newName = parent.getElementName(newIndex);
            this.declaration = new DecisionVariableDeclaration(newName, this.declaration.getType(), this.declaration.getParent());
            conItemProvider.setIndex(newIndex);
        }
    }

    VariableConfigProvider getConfigProvider() {
        return this.configProvider;
    }

    boolean ownStateAllowed() {
        boolean ownStateallowed = this.configProvider.isStateChangeAllowed();
        if (ownStateallowed && this.isNested() && null != this.getParent()) {
            ownStateallowed = ((DecisionVariable)this.getParent()).ownStateAllowed();
        }
        return ownStateallowed;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    protected boolean isAttribute() {
        return this.isAttribute;
    }

    @Override
    public void setHistoryValue(Value value, IAssignmentState state) throws ConfigurationException {
        this.configProvider.setHistoryValue(value, state);
    }

    @Override
    public boolean hasValue() {
        return null != this.getValue() && null != this.getValue().getValue();
    }

    @Override
    public boolean hasNullValue() {
        return this.getValue() instanceof NullValue;
    }

    void setState(IAssignmentState state) {
        this.configProvider.setState(state);
        int n = this.getNestedElementsCount();
        for (int i = 0; i < n; ++i) {
            ((DecisionVariable)this.getNestedElement(i)).setState(state);
        }
    }

    @Override
    public String getQualifiedName() {
        return this.isNested() ? ((IDecisionVariable)this.getParent()).getQualifiedName() + "::" + this.getDeclaration().getName() : this.getDeclaration().getQualifiedName();
    }

    @Override
    public IResolutionPathElement getResolutionPath() {
        IResolutionPathElement result = null;
        IConfigurationElement par = this.getParent();
        result = par instanceof DecisionVariable ? ((DecisionVariable)par).getPathForNestedElement(this) : new StartPathElement(this.getDeclaration());
        return result;
    }

    protected IResolutionPathElement getPathForNestedElement(IDecisionVariable nested) {
        IndexAccessPathElement result = null;
        for (int n = 0; null == result && n < this.getNestedElementsCount(); ++n) {
            IDecisionVariable tmp = this.getNestedElement(n);
            if (tmp != nested) continue;
            result = new IndexAccessPathElement(this.getResolutionPath(), n);
        }
        return result;
    }

    public IDatatype getInstantiatableType() {
        return this.declaration.getType();
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public boolean wasCreated() {
        return true;
    }

    @Override
    public void notifyCreated() {
    }

    @Override
    public boolean notifyWasAssigned(Value value) {
        boolean old = this.wasAssigned;
        this.wasAssigned = true;
        return old;
    }

    @Override
    public boolean wasAssigned() {
        return this.wasAssigned;
    }

    @Override
    public boolean enableWasAssignedForIsDefined() {
        return false;
    }

    static /* synthetic */ IDecisionVariable[] access$102(DecisionVariable x0, IDecisionVariable[] x1) {
        x0.attributes = x1;
        return x1;
    }

    private class InitializationAnnotationVisitor
    extends AnnotationVisitor {
        private Map<String, Value> values = new HashMap<String, Value>();
        private Map<String, IDecisionVariable> tmp = new HashMap<String, IDecisionVariable>();

        private InitializationAnnotationVisitor() {
        }

        @Override
        public void visitAnnotations(IAttributeAccess access) throws IvmlException {
            super.visitAnnotations(access);
            DecisionVariable.access$102(DecisionVariable.this, new IDecisionVariable[this.tmp.size()]);
            int a = 0;
            for (IDecisionVariable var : this.tmp.values()) {
                ((DecisionVariable)DecisionVariable.this).attributes[a++] = var;
            }
        }

        @Override
        protected void processAttributeAssignment(AttributeAssignment assng) throws IvmlException {
            for (int r = 0; r < assng.getRealizingCount(); ++r) {
                AbstractVariable var;
                String key;
                OCLFeatureCall call;
                ConstraintSyntaxTree constr = assng.getRealizing(r).getConsSyntax();
                if (!(constr instanceof OCLFeatureCall) || 1 != (call = (OCLFeatureCall)constr).getParameterCount() || !"=".equals(call.getOperation())) continue;
                ConstraintSyntaxTree p0 = call.getOperand();
                ConstraintSyntaxTree p1 = call.getParameter(0);
                if (!(p0 instanceof Variable) || !(p1 instanceof ConstantValue) || this.values.containsKey(key = (var = ((Variable)p0).getVariable()).getName())) continue;
                this.values.put(key, ((ConstantValue)p1).getConstantValue());
            }
        }

        @Override
        protected void processAttribute(Attribute attr) throws IvmlException {
            String key = attr.getName();
            if (!this.tmp.containsKey(key)) {
                VariableCreator creator = new VariableCreator(attr, DecisionVariable.this, DecisionVariable.this.isVisible, true);
                IDecisionVariable var = creator.getVariable();
                if (this.values.containsKey(key)) {
                    var.setValue(this.values.get(key), AssignmentState.DERIVED);
                } else if (null != attr.getDefaultValue() && attr.getDefaultValue() instanceof ConstantValue) {
                    Value val = ((ConstantValue)attr.getDefaultValue()).getConstantValue();
                    var.setValue(val, AssignmentState.DEFAULT);
                }
                this.tmp.put(key, var);
            }
        }
    }
}

