/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.confModel;

import java.util.Stack;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.CompoundVariable;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationVisitor;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

public class DefaultValueHelper {
    private EvaluationVisitor evaluator = new EvaluationVisitor();
    private Stack<IDecisionVariable> variables;

    public DefaultValueHelper() {
    }

    public DefaultValueHelper(IDecisionVariable variable) {
        this();
        this.initialize(variable);
    }

    public static void fillDefaults(IDecisionVariable variable) {
        if (null != variable && variable.getState() != AssignmentState.FROZEN) {
            DefaultValueHelper helper = new DefaultValueHelper(variable);
            helper.assignDefaultValue(variable);
            helper.clear();
        }
    }

    public void initialize(IDecisionVariable variable) {
        this.variables.clear();
        this.variables.push(variable);
        this.evaluator.init(variable.getConfiguration(), null, false, null);
    }

    public void clear() {
        this.variables.clear();
        this.evaluator.clear();
    }

    private void assignDefaultValue(IDecisionVariable var) {
        IDatatype type = var.getDeclaration().getType();
        if (type instanceof ConstraintType) {
            this.assignConstraintValue();
        } else if (type instanceof Compound) {
            this.assignCompoundValue((Compound)type);
        } else {
            this.assignSingleExpressionDefault();
        }
    }

    private void assignConstraintValue() {
        IDecisionVariable var = this.variables.peek();
        ConstraintSyntaxTree defaultEx = var.getDeclaration().getDefaultValue();
        if (null != defaultEx) {
            try {
                var.setValue(ValueFactory.createValue(var.getDeclaration().getType(), defaultEx), AssignmentState.DEFAULT);
            }
            catch (ConfigurationException e) {
                DefaultValueHelper.getLogger().exception(e);
            }
            catch (ValueDoesNotMatchTypeException e) {
                DefaultValueHelper.getLogger().exception(e);
            }
        }
    }

    private void assignCompoundValue(Compound compound) {
        IDecisionVariable variable = this.variables.peek();
        if (variable instanceof CompoundVariable) {
            CompoundVariable cVariable = (CompoundVariable)variable;
            for (int e = 0; e < compound.getElementCount(); ++e) {
                DecisionVariableDeclaration var = compound.getElement(e);
                String slotName = var.getName();
                this.variables.push(cVariable.getNestedVariable(slotName));
                this.assignDefaultValue(cVariable.getNestedVariable(slotName));
                this.variables.pop();
            }
        }
        this.assignSingleExpressionDefault();
    }

    private void assignSingleExpressionDefault() {
        ConstraintSyntaxTree defaultEx;
        IDecisionVariable var = this.variables.peek();
        if (AssignmentState.UNDEFINED == var.getState() && null != (defaultEx = var.getDeclaration().getDefaultValue())) {
            defaultEx.accept(this.evaluator);
            Value defaultValue = this.evaluator.getResult();
            if (null != defaultValue) {
                try {
                    var.setValue(defaultValue, AssignmentState.DEFAULT);
                }
                catch (ConfigurationException e) {
                    DefaultValueHelper.getLogger().exception(e);
                }
            } else {
                DefaultValueHelper.getLogger().error("Cannot evaluate default value for " + var);
            }
        }
    }

    private static EASyLoggerFactory.EASyLogger getLogger() {
        return EASyLoggerFactory.INSTANCE.getLogger(DefaultValueHelper.class, "net.ssehub.easy.varModel");
    }
}

