/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.confModel;

import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.persistency.StringProvider;

public abstract class DisplayNameProvider {
    private static DisplayNameProvider nameProvider = new DisplayNameProvider(){

        @Override
        public String getDisplayName(AbstractVariable variable) {
            return variable.getUniqueName();
        }

        @Override
        public String getParentNames(AbstractVariable variable) {
            String result = null;
            if (variable.getParent() != null) {
                result = variable.getParent().getQualifiedName();
            }
            return result;
        }

        @Override
        public String getDisplayName(EnumLiteral literal) {
            return literal.getName();
        }

        @Override
        public String getNullName(AbstractVariable type) {
            return "[NULL]";
        }

        @Override
        public boolean enableNullValueInConfiguration(AbstractVariable variable) {
            return false;
        }
    };

    public static void setInstance(DisplayNameProvider provider) {
        if (null != provider) {
            nameProvider = provider;
        }
    }

    public static DisplayNameProvider getInstance() {
        return nameProvider;
    }

    public String getDisplayName(IDecisionVariable variable) {
        return this.getDisplayName(variable.getDeclaration());
    }

    public abstract String getDisplayName(AbstractVariable var1);

    public String getDisplayName(ConstraintSyntaxTree constraint, Configuration configuration) {
        String name;
        if (constraint instanceof Variable) {
            name = this.getDisplayName(((Variable)constraint).getVariable());
        } else if (constraint instanceof CompoundAccess) {
            CompoundAccess access = (CompoundAccess)constraint;
            String varName = null != access.getResolvedSlot() ? this.getDisplayName(access.getResolvedSlot()) : access.getSlotName();
            name = this.getDisplayName(access.getCompoundExpression(), configuration) + '.' + varName;
        } else if (constraint instanceof OCLFeatureCall && "[]".equals(((OCLFeatureCall)constraint).getOperation())) {
            OCLFeatureCall call = (OCLFeatureCall)constraint;
            name = this.getDisplayNameForIndexAccess(call, configuration);
        } else {
            name = StringProvider.toIvmlString(constraint, configuration.getProject());
        }
        return name;
    }

    protected String getDisplayNameForIndexAccess(OCLFeatureCall call, Configuration configuration) {
        return this.getDisplayName(call.getOperand(), configuration) + "[" + this.getDisplayName(call.getParameter(0), configuration) + "]";
    }

    public abstract String getParentNames(AbstractVariable var1);

    public abstract String getDisplayName(EnumLiteral var1);

    public abstract String getNullName(AbstractVariable var1);

    public String getNullName(IDecisionVariable variable) {
        String result = null;
        if (null != variable) {
            result = this.getNullName(variable.getDeclaration());
        }
        return result;
    }

    public boolean enableNullValueInConfiguration(IDecisionVariable variable) {
        boolean result = false;
        if (null != variable) {
            result = this.enableNullValueInConfiguration(variable.getDeclaration());
        }
        return result;
    }

    public abstract boolean enableNullValueInConfiguration(AbstractVariable var1);
}

