/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.confModel;

import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.CompoundVariable;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.ContainerVariable;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.confModel.IFreezeSelector;
import net.ssehub.easy.varModel.confModel.VariableConfigProvider;
import net.ssehub.easy.varModel.confModel.VariableCreator;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;

class ToplevelVarConfigProvider
extends VariableConfigProvider {
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(ToplevelVarConfigProvider.class, "net.ssehub.easy.varModel");
    private Value value;
    private IAssignmentState state;
    private IDecisionVariable relatedVariable;

    protected ToplevelVarConfigProvider(IDecisionVariable relatedVariable, Value value, IAssignmentState state) {
        this.relatedVariable = relatedVariable;
        this.setValueImpl(value);
        this.state = null == state ? AssignmentState.UNDEFINED : state;
    }

    @Override
    protected Value getValue() {
        return this.value;
    }

    @Override
    protected void setValue(Value value, IAssignmentState state) throws ConfigurationException {
        if (this.state != AssignmentState.FROZEN) {
            this.assignValue(value, state, false);
        } else if (null == this.value && this.state == AssignmentState.FROZEN && null != value && !value.isConfigured()) {
            this.setValueImpl(value);
        } else {
            throw new ConfigurationException(this.getConfiguration(), "decision '" + this.getDeclaration().getName() + "' is already frozen and cannot be changed", 19001);
        }
    }

    @Override
    protected IAssignmentState getState() {
        return this.state;
    }

    @Override
    protected final void setState(IAssignmentState state) {
        this.state = state;
        this.getConfiguration().variableChangedState(this.relatedVariable);
    }

    @Override
    protected final boolean isStateChangeAllowed() {
        return true;
    }

    @Override
    protected final AbstractVariable getDeclaration() {
        return this.relatedVariable.getDeclaration();
    }

    @Override
    protected final Configuration getConfiguration() {
        return this.relatedVariable.getConfiguration();
    }

    @Override
    protected void setHistoryValue(Value value, IAssignmentState state) throws ConfigurationException {
        this.assignValue(value, state, true);
    }

    private void assignValue(Value value, IAssignmentState state, boolean allowDeletation) throws ConfigurationException {
        Value oldValue = this.value;
        if (null != value) {
            if (!this.getDeclaration().getType().isAssignableFrom(value.getType())) {
                throw new ConfigurationException(this.getConfiguration(), "type '" + IvmlDatatypeVisitor.getQualifiedType(this.getDeclaration().getType()) + "' of variable declaration '" + this.getDeclaration().getName() + "' does not match type of value '" + IvmlDatatypeVisitor.getQualifiedType(value.getType()) + "'", 19002);
            }
            if (value instanceof CompoundValue && null != oldValue && oldValue instanceof CompoundValue) {
                value = this.assignCompoundValue((CompoundValue)value, state, allowDeletation, (CompoundValue)oldValue);
            } else if (value instanceof ContainerValue) {
                value = this.assignContainerValue((ContainerValue)value, state, allowDeletation);
            }
        } else if (this.relatedVariable.getDeclaration().getType() instanceof Container && allowDeletation) {
            ContainerVariable container = (ContainerVariable)this.relatedVariable;
            container.clear();
        }
        this.setValueImpl(value);
        this.state = state;
        this.getConfiguration().variableChanged(this.relatedVariable, oldValue);
    }

    private Value assignCompoundValue(CompoundValue value, IAssignmentState state, boolean allowDeletation, CompoundValue oldValue) throws ConfigurationException {
        IDecisionVariable var;
        CompoundValue newValue = oldValue;
        if (allowDeletation) {
            newValue = value;
        } else {
            try {
                CompoundValue tmpValue = value;
                if (!TypeQueries.sameTypes(value.getType(), oldValue.getType())) {
                    newValue = value;
                    tmpValue = oldValue;
                }
                Compound cType = (Compound)DerivedDatatype.resolveToBasis(this.getDeclaration().getType());
                for (int i = 0; i < cType.getInheritedElementCount(); ++i) {
                    IAssignmentState oldState;
                    DecisionVariableDeclaration decl = cType.getInheritedElement(i);
                    String name = decl.getName();
                    var = this.relatedVariable.getNestedElement(name);
                    Value newSlotValue = newValue.getNestedValue(name);
                    Value oldSlotValue = tmpValue.getNestedValue(name);
                    IAssignmentState iAssignmentState = oldState = null != var ? var.getState() : state;
                    if (oldSlotValue != null && newSlotValue == null || AssignmentState.USER_ASSIGNED == oldState && state != AssignmentState.USER_ASSIGNED) continue;
                    newValue.configureValue(name, newSlotValue);
                }
            }
            catch (ValueDoesNotMatchTypeException exc) {
                LOGGER.exception(exc);
            }
        }
        Compound cmpType = (Compound)DerivedDatatype.resolveToBasis(value.getType());
        for (int i = 0; i < cmpType.getInheritedElementCount(); ++i) {
            String slotName = cmpType.getInheritedElement(i).getName();
            CompoundVariable cmpVar = (CompoundVariable)this.relatedVariable;
            Value nestedValue = value.getNestedValue(slotName);
            var = cmpVar.getNestedVariable(slotName);
            if (null == var) continue;
            IAssignmentState nestedState = var.getState();
            if (nestedState != AssignmentState.USER_ASSIGNED) {
                nestedState = state;
            }
            if (allowDeletation) {
                if (nestedValue == null) {
                    var.setValue(nestedValue, AssignmentState.UNDEFINED);
                    continue;
                }
                var.setValue(nestedValue, nestedState);
                continue;
            }
            if (null == nestedValue || null == var || nestedState == AssignmentState.USER_ASSIGNED) continue;
            var.setValue(nestedValue, nestedState);
        }
        value = newValue;
        return value;
    }

    private Value assignContainerValue(ContainerValue conValue, IAssignmentState state, boolean allowDeletation) throws ConfigurationException {
        ContainerVariable container = (ContainerVariable)this.relatedVariable;
        if (allowDeletation) {
            container.clear();
        }
        ContainerValue oldValue = null;
        if (this.value instanceof ContainerValue) {
            oldValue = (ContainerValue)this.value;
        }
        this.setValueImpl(conValue);
        for (int i = 0; i < conValue.getElementSize(); ++i) {
            boolean overwrite = true;
            if (container.getNestedElementsCount() > i) {
                IDecisionVariable oldNestedVar = container.getNestedElement(i);
                boolean bl = overwrite = AssignmentState.USER_ASSIGNED != oldNestedVar.getState() || state == AssignmentState.USER_ASSIGNED;
            }
            if (overwrite) {
                String nestedName = container.getElementName(i);
                DecisionVariableDeclaration nestedDecl = new DecisionVariableDeclaration(nestedName, conValue.getElement(i).getType(), this.relatedVariable.getDeclaration());
                VariableCreator creator = new VariableCreator(nestedDecl, this.relatedVariable, this.relatedVariable.isVisible(), false);
                IDecisionVariable nestedVar = creator.getVariable();
                container.addNestedElement(nestedVar);
                Value nesValue = conValue.getElement(i);
                nestedVar.setValue(nesValue, state);
                continue;
            }
            if (oldValue.getElementSize() <= i) continue;
            try {
                conValue.setValue(i, oldValue.getElement(i));
                continue;
            }
            catch (ValueDoesNotMatchTypeException e) {
                LOGGER.exception(e);
            }
        }
        return this.value;
    }

    private void setValueImpl(Value value) {
        if (null != this.value) {
            this.value.setValueParent(null);
        }
        this.value = value;
        if (null != this.value) {
            this.value.setValueParent(this.relatedVariable);
        }
    }

    @Override
    protected void freeze(IFreezeSelector selector) {
        this.freeze();
    }
}

