/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.confModel;

import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.BasisVariable;
import net.ssehub.easy.varModel.confModel.CompoundItemConfigProvider;
import net.ssehub.easy.varModel.confModel.CompoundVariable;
import net.ssehub.easy.varModel.confModel.ContainerItemConfigProvider;
import net.ssehub.easy.varModel.confModel.ContainerVariable;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.confModel.ToplevelVarConfigProvider;
import net.ssehub.easy.varModel.confModel.VariableConfigProvider;

class VariableConfigProviderFactory {
    VariableConfigProviderFactory() {
    }

    static VariableConfigProvider createDelegate(IDecisionVariable relatedVariable) {
        VariableConfigProvider delegate = null;
        if (!relatedVariable.isNested()) {
            delegate = new ToplevelVarConfigProvider(relatedVariable, null, AssignmentState.UNDEFINED);
        } else if (relatedVariable.getDeclaration().isAttribute()) {
            delegate = new ToplevelVarConfigProvider(relatedVariable, null, AssignmentState.UNDEFINED);
        } else {
            IDecisionVariable parent = (IDecisionVariable)relatedVariable.getParent();
            if (parent instanceof CompoundVariable) {
                delegate = new CompoundItemConfigProvider((CompoundVariable)parent, relatedVariable.getDeclaration().getName());
            } else if (parent instanceof ContainerVariable) {
                ContainerVariable containerParent = (ContainerVariable)parent;
                int countItems = containerParent.getNestedElementsCount();
                for (int i = 0; null == delegate && i < countItems; ++i) {
                    String thisName = relatedVariable.getDeclaration().getName();
                    String nameInParent = containerParent.getNestedElement(i).getDeclaration().getName();
                    if (!nameInParent.equals(thisName)) continue;
                    delegate = new ContainerItemConfigProvider(containerParent, i);
                }
                if (null == delegate) {
                    if (!relatedVariable.getDeclaration().isAttribute()) {
                        containerParent.addNestedElement(relatedVariable);
                    }
                    delegate = new ContainerItemConfigProvider(containerParent, countItems);
                }
            } else if (parent instanceof BasisVariable) {
                delegate = new ToplevelVarConfigProvider(relatedVariable, null, AssignmentState.UNDEFINED);
            }
        }
        return delegate;
    }
}

