/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cst;

import java.util.Arrays;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;

public class CompoundInitializer
extends ConstraintSyntaxTree {
    private Compound type;
    private ConstraintSyntaxTree[] expressions;
    private String[] slots;
    private AbstractVariable[] slotDecls;

    public CompoundInitializer(Compound type, String[] slots, AbstractVariable[] slotDecls, ConstraintSyntaxTree[] expressions) throws CSTSemanticException {
        this.type = type;
        this.expressions = expressions;
        this.slots = slots;
        this.slotDecls = slotDecls;
        if (null == expressions) {
            throw new CSTSemanticException("expressions is null", 10103);
        }
        if (null == slots) {
            throw new CSTSemanticException("slots is null", 10103);
        }
        if (null == slotDecls) {
            throw new CSTSemanticException("slotDecls is null", 10103);
        }
        if (expressions.length != slots.length || slots.length != slotDecls.length) {
            throw new CSTSemanticException("number of expressions is not equal to number of slots", 10103);
        }
    }

    public Compound getType() {
        return this.type;
    }

    public int getSlotCount() {
        return this.slots.length;
    }

    public int getExpressionCount() {
        return this.expressions.length;
    }

    public ConstraintSyntaxTree getExpression(int index) {
        return this.expressions[index];
    }

    public String getSlot(int index) {
        return this.slots[index];
    }

    public AbstractVariable getSlotDeclaration(int index) {
        return this.slotDecls[index];
    }

    @Override
    public void accept(IConstraintTreeVisitor visitor) {
        visitor.visitCompoundInitializer(this);
    }

    @Override
    public IDatatype inferDatatype() throws CSTSemanticException {
        return this.type;
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof CompoundInitializer) {
            CompoundInitializer other = (CompoundInitializer)obj;
            equals = this.type.getQualifiedName().equals(other.type.getQualifiedName());
            equals &= Arrays.equals(this.expressions, other.expressions);
            equals &= Arrays.equals(this.slotDecls, other.slotDecls);
            equals &= Arrays.equals(this.slots, other.slots);
        }
        return equals;
    }

    public int hashCode() {
        int hashCode = this.type.getQualifiedName().hashCode();
        return hashCode *= Arrays.hashCode(this.expressions);
    }
}

