/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cst;

import java.util.HashMap;
import java.util.Map;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.BlockExpression;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.Comment;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.DeferInitExpression;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.IfThen;
import net.ssehub.easy.varModel.cst.Leaf;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.MultiAndExpression;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Parenthesis;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.UnresolvedExpression;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IAttributableElement;

public class ConstraintReplacer
implements IConstraintTreeVisitor {
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(ConstraintReplacer.class, "net.ssehub.easy.varModel");
    private Map<Leaf, Leaf> mapping = new HashMap<Leaf, Leaf>();
    private Map<AbstractVariable, AbstractVariable> varMapping = new HashMap<AbstractVariable, AbstractVariable>();
    private ConstraintSyntaxTree copiedConstraint;
    private ConstraintSyntaxTree origin;

    public ConstraintReplacer(ConstraintSyntaxTree origin) {
        this.origin = origin;
    }

    public ConstraintSyntaxTree replaceVariable(Leaf oldLeaf, Leaf newLeaf) {
        this.mapping.put(oldLeaf, newLeaf);
        this.origin.accept(this);
        return this.copiedConstraint;
    }

    @Override
    public void visitConstantValue(ConstantValue value) {
        this.replace(value);
    }

    @Override
    public void visitVariable(Variable variable) {
        AbstractVariable mappedDecl = this.varMapping.get(variable.getVariable());
        if (null != mappedDecl) {
            this.copiedConstraint = new Variable(mappedDecl);
        } else {
            this.replace(variable);
        }
    }

    private void replace(Leaf oldLeaf) {
        Leaf newLeaf = this.mapping.get(oldLeaf);
        this.copiedConstraint = null != newLeaf ? newLeaf : oldLeaf;
    }

    @Override
    public void visitParenthesis(Parenthesis parenthesis) {
        parenthesis.getExpr().accept(this);
        this.copiedConstraint = new Parenthesis(this.copiedConstraint);
        this.resolve();
    }

    @Override
    public void visitDeferInitExpression(DeferInitExpression expression) {
        expression.getExpression().accept(this);
        this.copiedConstraint = new DeferInitExpression(this.copiedConstraint);
        this.resolve();
    }

    @Override
    public void visitCompoundInitializer(CompoundInitializer initializer) {
        int e;
        int count = initializer.getExpressionCount();
        String[] slots = new String[count];
        AbstractVariable[] slotDecls = new AbstractVariable[count];
        ConstraintSyntaxTree[] expressions = new ConstraintSyntaxTree[count];
        for (e = 0; e < count; ++e) {
            slots[e] = initializer.getSlot(e);
            slotDecls[e] = this.map(initializer.getSlotDeclaration(e));
        }
        for (e = 0; e < count; ++e) {
            initializer.getExpression(e).accept(this);
            expressions[e] = this.copiedConstraint;
        }
        try {
            this.copiedConstraint = new CompoundInitializer(initializer.getType(), slots, slotDecls, expressions);
            this.resolve();
        }
        catch (CSTSemanticException e2) {
            LOGGER.exception(e2);
        }
    }

    @Override
    public void visitContainerInitializer(ContainerInitializer initializer) {
        int count = initializer.getExpressionCount();
        ConstraintSyntaxTree[] expressions = new ConstraintSyntaxTree[count];
        for (int e = 0; e < count; ++e) {
            initializer.getExpression(e).accept(this);
            expressions[e] = this.copiedConstraint;
        }
        try {
            this.copiedConstraint = new ContainerInitializer(initializer.getType(), expressions);
            this.resolve();
        }
        catch (CSTSemanticException e) {
            LOGGER.exception(e);
        }
    }

    @Override
    public void visitComment(Comment comment) {
    }

    @Override
    public void visitOclFeatureCall(OCLFeatureCall call) {
        call.getOperand().accept(this);
        ConstraintSyntaxTree operand = this.copiedConstraint;
        ConstraintSyntaxTree[] parameters = new ConstraintSyntaxTree[call.getParameterCount()];
        for (int i = 0; i < call.getParameterCount(); ++i) {
            call.getParameter(i).accept(this);
            parameters[i] = this.copiedConstraint;
        }
        this.copiedConstraint = new OCLFeatureCall(operand, call.getOperation(), call.getAccessor(), parameters);
        this.resolve();
    }

    @Override
    public void visitMultiAndExpression(MultiAndExpression expression) {
        OCLFeatureCall[] expressions = new OCLFeatureCall[expression.getExpressionCount()];
        for (int e = 0; e < expression.getExpressionCount(); ++e) {
            expression.getExpression(e).accept(this);
            expressions[e] = (OCLFeatureCall)this.copiedConstraint;
        }
        try {
            this.copiedConstraint = new MultiAndExpression(expressions);
            this.resolve();
        }
        catch (CSTSemanticException e) {
            LOGGER.exception(e);
        }
    }

    private void resolve() {
        if (null != this.copiedConstraint) {
            try {
                this.copiedConstraint.inferDatatype();
            }
            catch (CSTSemanticException e) {
                LOGGER.exception(e);
            }
        }
    }

    @Override
    public void visitLet(Let let) {
        DecisionVariableDeclaration var = this.map(let.getVariable());
        let.getInExpression().accept(this);
        ConstraintSyntaxTree inEx = this.copiedConstraint;
        this.copiedConstraint = new Let(var, inEx);
        this.resolve();
    }

    @Override
    public void visitIfThen(IfThen ifThen) {
        ifThen.getIfExpr().accept(this);
        ConstraintSyntaxTree ifEx = this.copiedConstraint;
        ifThen.getThenExpr().accept(this);
        ConstraintSyntaxTree thenEx = this.copiedConstraint;
        ConstraintSyntaxTree elseEx = null;
        if (null != ifThen.getElseExpr()) {
            ifThen.getElseExpr().accept(this);
            elseEx = this.copiedConstraint;
        }
        this.copiedConstraint = new IfThen(ifEx, thenEx, elseEx);
        this.resolve();
    }

    @Override
    public void visitContainerOperationCall(ContainerOperationCall call) {
        call.getContainer().accept(this);
        ConstraintSyntaxTree container = this.copiedConstraint;
        DecisionVariableDeclaration[] declarators = new DecisionVariableDeclaration[call.getDeclaratorsCount()];
        for (int d = 0; d < declarators.length; ++d) {
            declarators[d] = this.map(call.getDeclarator(d));
        }
        call.getExpression().accept(this);
        ConstraintSyntaxTree expression = this.copiedConstraint;
        this.copiedConstraint = new ContainerOperationCall(container, call.getOperation(), expression, declarators);
        this.resolve();
    }

    private AbstractVariable map(AbstractVariable var) {
        AbstractVariable result;
        if (var instanceof DecisionVariableDeclaration) {
            result = this.map((DecisionVariableDeclaration)var);
        } else if (var instanceof Attribute) {
            AbstractVariable tmp;
            Attribute old = (Attribute)var;
            IAttributableElement element = old.getElement();
            if (element instanceof AbstractVariable && (tmp = this.varMapping.get((AbstractVariable)((Object)element))) instanceof IAttributableElement) {
                element = (IAttributableElement)((Object)tmp);
            }
            result = new Attribute(old.getName(), old.getType(), old.getParent(), element);
        } else {
            result = null;
        }
        return result;
    }

    private DecisionVariableDeclaration map(DecisionVariableDeclaration var) {
        DecisionVariableDeclaration result = new DecisionVariableDeclaration(var.getName(), var.getType(), var.getParent());
        this.varMapping.put(var, result);
        return result;
    }

    @Override
    public void visitCompoundAccess(CompoundAccess access) {
        access.getCompoundExpression().accept(this);
        ConstraintSyntaxTree compEx = this.copiedConstraint;
        this.copiedConstraint = new CompoundAccess(compEx, access.getSlotName());
        this.resolve();
    }

    @Override
    public void visitUnresolvedExpression(UnresolvedExpression expression) {
        ConstraintSyntaxTree actual = expression.getActualExpression();
        if (null != actual) {
            actual.accept(this);
        }
    }

    @Override
    public void visitSelf(Self self) {
        this.copiedConstraint = self;
    }

    @Override
    public void visitAnnotationVariable(AttributeVariable variable) {
        this.visitVariable(variable);
    }

    @Override
    public void visitBlockExpression(BlockExpression block) {
        ConstraintSyntaxTree[] exprs = new ConstraintSyntaxTree[block.getExpressionCount()];
        int n = block.getExpressionCount();
        for (int e = 0; e < n; ++e) {
            block.getExpression(e).accept(this);
            exprs[e] = this.copiedConstraint;
        }
        try {
            this.copiedConstraint = new BlockExpression(exprs);
        }
        catch (CSTSemanticException e) {
            LOGGER.exception(e);
        }
    }
}

