/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cst;

import java.io.PrintStream;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.BlockExpression;
import net.ssehub.easy.varModel.cst.Comment;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.DeferInitExpression;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.IfThen;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.MultiAndExpression;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Parenthesis;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.UnresolvedExpression;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.persistency.StringProvider;

public class DebugConstraintTreeVisitor
implements IConstraintTreeVisitor {
    private PrintStream out;
    private StringBuilder indentation = new StringBuilder();

    public DebugConstraintTreeVisitor() {
        this(System.out);
    }

    public DebugConstraintTreeVisitor(PrintStream out) {
        this.out = out;
    }

    private void increaseIndentation() {
        this.indentation.append("  ");
    }

    private void decreaseIndentation() {
        int length = this.indentation.length();
        if (length > 0) {
            this.indentation.delete(length - 2, length);
        }
    }

    private void print(String text) {
        this.out.print(this.indentation);
        this.out.print(text);
    }

    private void println(String text) {
        this.print(text);
        this.out.println();
    }

    @Override
    public void visitConstantValue(ConstantValue value) {
        this.println(StringProvider.toIvmlString(value));
    }

    @Override
    public void visitVariable(Variable variable) {
        this.println(StringProvider.toIvmlString(variable) + " type " + StringProvider.toIvmlString(variable.getVariable()));
    }

    @Override
    public void visitParenthesis(Parenthesis parenthesis) {
        this.println("(");
        this.increaseIndentation();
        parenthesis.getExpr().accept(this);
        this.decreaseIndentation();
        this.println(")");
    }

    @Override
    public void visitComment(Comment comment) {
        this.println("COMMENT " + comment.getComment());
        this.increaseIndentation();
        comment.getExpr().accept(this);
        this.decreaseIndentation();
    }

    @Override
    public void visitOclFeatureCall(OCLFeatureCall call) {
        this.println("CALL " + call.getOperation() + "(resolved: " + (call.getResolvedOperation() != null) + ") with parameter");
        this.increaseIndentation();
        call.getOperand().accept(this);
        for (int p = 0; p < call.getParameterCount(); ++p) {
            call.getParameter(p).accept(this);
        }
        this.decreaseIndentation();
    }

    @Override
    public void visitDeferInitExpression(DeferInitExpression expression) {
        this.println("deferred");
        expression.getExpression().accept(this);
    }

    @Override
    public void visitMultiAndExpression(MultiAndExpression expression) {
        this.println("MULTI-AND");
        this.increaseIndentation();
        for (int e = 0; e < expression.getExpressionCount(); ++e) {
            expression.getExpression(e).accept(this);
        }
        this.decreaseIndentation();
    }

    @Override
    public void visitLet(Let let) {
        this.println("let " + StringProvider.toIvmlString(let.getVariable()) + " in");
        this.increaseIndentation();
        let.getInExpression().accept(this);
        this.decreaseIndentation();
    }

    @Override
    public void visitIfThen(IfThen ifThen) {
        this.println("if-then-else");
        this.increaseIndentation();
        this.println("if:");
        ifThen.getIfExpr().accept(this);
        this.println("then:");
        ifThen.getThenExpr().accept(this);
        this.println("else:");
        ifThen.getElseExpr().accept(this);
        this.decreaseIndentation();
    }

    @Override
    public void visitContainerOperationCall(ContainerOperationCall call) {
        this.println("ContainerCall (resolved: " + (call.getResolvedOperation() != null) + ") " + call.getOperation());
        this.increaseIndentation();
        this.println("container:");
        call.getContainer().accept(this);
        this.println("expression:");
        call.getExpression().accept(this);
        this.decreaseIndentation();
    }

    @Override
    public void visitCompoundAccess(CompoundAccess access) {
        String slot = "";
        if (null != access.getResolvedSlot()) {
            slot = " slot " + StringProvider.toIvmlString(access.getResolvedSlot());
        }
        this.println("compound access" + slot + " on");
        this.increaseIndentation();
        access.getCompoundExpression().accept(this);
        this.decreaseIndentation();
    }

    @Override
    public void visitUnresolvedExpression(UnresolvedExpression expression) {
        this.println("UNRESOLVED");
    }

    @Override
    public void visitCompoundInitializer(CompoundInitializer initializer) {
        this.println("COMPOUND INITIALIZER");
        this.increaseIndentation();
        for (int e = 0; e < initializer.getExpressionCount(); ++e) {
            this.println(initializer.getSlot(e) + ":");
            initializer.getExpression(e).accept(this);
        }
        this.decreaseIndentation();
    }

    @Override
    public void visitContainerInitializer(ContainerInitializer initializer) {
        this.println("CONTAINER INITIALIZER");
        this.increaseIndentation();
        for (int e = 0; e < initializer.getExpressionCount(); ++e) {
            initializer.getExpression(e).accept(this);
        }
        this.decreaseIndentation();
    }

    @Override
    public void visitSelf(Self self) {
        this.print("self");
    }

    @Override
    public void visitAnnotationVariable(AttributeVariable variable) {
        this.print("Annotation \"" + StringProvider.toIvmlString(variable.getVariable()) + "\"");
        ConstraintSyntaxTree qu = variable.getQualifier();
        if (null != qu) {
            this.print(" of ");
            qu.accept(this);
        }
    }

    @Override
    public void visitBlockExpression(BlockExpression block) {
        this.println("Block");
        this.increaseIndentation();
        for (int e = 0; e < block.getExpressionCount(); ++e) {
            block.getExpression(e).accept(this);
        }
        this.decreaseIndentation();
    }
}

