/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cst;

import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;

public class IfThen
extends ConstraintSyntaxTree {
    private ConstraintSyntaxTree ifExpr;
    private ConstraintSyntaxTree thenExpr;
    private ConstraintSyntaxTree elseExpr;
    private IDatatype result;

    IfThen() {
    }

    public IfThen(ConstraintSyntaxTree ifExpr, ConstraintSyntaxTree thenExpr, ConstraintSyntaxTree elseExpr) {
        this.ifExpr = ifExpr;
        this.thenExpr = thenExpr;
        this.elseExpr = elseExpr;
    }

    public ConstraintSyntaxTree getIfExpr() {
        return this.ifExpr;
    }

    public ConstraintSyntaxTree getThenExpr() {
        return this.thenExpr;
    }

    public ConstraintSyntaxTree getElseExpr() {
        return this.elseExpr;
    }

    @Override
    public IDatatype inferDatatype() throws CSTSemanticException {
        if (null == this.result) {
            IDatatype elseType;
            IDatatype ifType = this.ifExpr.inferDatatype();
            if (!BooleanType.TYPE.isAssignableFrom(ifType)) {
                throw new CSTSemanticException("if expression type ('" + ifType.getName() + "') is not Boolean", 10100);
            }
            IDatatype thenType = this.thenExpr.inferDatatype();
            if (!thenType.isAssignableFrom(elseType = this.elseExpr.inferDatatype())) {
                throw new CSTSemanticException("types of then ('" + thenType.getName() + "') and else ('" + elseType.getName() + "') part do not match", 10100);
            }
            this.result = thenType;
        }
        return this.result;
    }

    @Override
    public void accept(IConstraintTreeVisitor visitor) {
        visitor.visitIfThen(this);
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof IfThen) {
            IfThen other = (IfThen)obj;
            equals = this.ifExpr.equals(other.ifExpr);
            equals &= this.thenExpr.equals(other.thenExpr);
            if (null != this.elseExpr) {
                equals &= this.elseExpr.equals(other.elseExpr);
            }
        }
        return equals;
    }

    public int hashCode() {
        int hashCode = this.ifExpr.hashCode();
        hashCode *= this.thenExpr.hashCode();
        if (null != this.elseExpr) {
            hashCode *= this.elseExpr.hashCode();
        }
        return hashCode;
    }
}

