/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cst;

import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;

public class MultiAndExpression
extends ConstraintSyntaxTree {
    private OCLFeatureCall[] expressions;

    public MultiAndExpression(OCLFeatureCall ... expressions) throws CSTSemanticException {
        if (null == expressions) {
            throw new CSTSemanticException("No expressions given", 10106);
        }
        for (int e = 0; e < expressions.length; ++e) {
            if (null != expressions[e]) continue;
            throw new CSTSemanticException("Expression at index " + e + " is not given", 10106);
        }
        this.expressions = expressions;
    }

    public int getExpressionCount() {
        return this.expressions.length;
    }

    public OCLFeatureCall getExpression(int index) {
        return this.expressions[index];
    }

    @Override
    public void accept(IConstraintTreeVisitor visitor) {
        visitor.visitMultiAndExpression(this);
    }

    @Override
    public IDatatype inferDatatype() throws CSTSemanticException {
        for (int e = 0; e < this.expressions.length; ++e) {
            if (BooleanType.TYPE.isAssignableFrom(this.expressions[e].inferDatatype())) continue;
            throw new CSTSemanticException("Expression at index " + e + " does not evaluate to Boolean", 10100);
        }
        return BooleanType.TYPE;
    }
}

