/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cst;

import java.util.Arrays;
import java.util.HashSet;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.EmptyInitializer;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.UnknownOperationException;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.datatypes.BaseTypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.CustomOperation;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.ICustomOperationAccessor;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.MetaType;
import net.ssehub.easy.varModel.model.datatypes.Operation;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.values.MetaTypeValue;
import net.ssehub.easy.varModel.model.values.Value;

public class OCLFeatureCall
extends ConstraintSyntaxTree {
    private ConstraintSyntaxTree operand;
    private String operation;
    private ConstraintSyntaxTree[] parameters;
    private Operation resolvedOperation;
    private IDatatype result;
    private ICustomOperationAccessor opAccessor;

    OCLFeatureCall() {
    }

    public OCLFeatureCall(ConstraintSyntaxTree operand, String operation, ConstraintSyntaxTree ... parameters) {
        this(operand, operation, (ICustomOperationAccessor)null, parameters);
    }

    public OCLFeatureCall(ConstraintSyntaxTree operand, String operation, ICustomOperationAccessor opAccessor, ConstraintSyntaxTree ... parameters) {
        this.operand = operand;
        this.operation = operation;
        this.parameters = parameters;
        this.opAccessor = opAccessor;
    }

    @Override
    public IDatatype inferDatatype() throws CSTSemanticException {
        if (null == this.result) {
            if (null != this.operation) {
                if (null != this.operand) {
                    this.dfltInferDatatype();
                } else {
                    this.customInferDatatype(false);
                }
            } else {
                throw new CSTSemanticException("<internal error>", 10103);
            }
        }
        return this.result;
    }

    public static void checkTypeCompliance(Operation op, IDatatype operandType, IDatatype[] parameterTypes) throws CSTSemanticException {
        IDatatype pType;
        if (null != op && ("==".equals(op.getName()) || "=".equals(op.getName())) && null != parameterTypes && 1 == parameterTypes.length && !(pType = parameterTypes[0]).isAssignableFrom(operandType) && !operandType.isAssignableFrom(pType)) {
            throw new CSTSemanticException("operand and parameter type must be assignable", 10100);
        }
    }

    private void dfltInferDatatype() throws CSTSemanticException {
        IDatatype operandType = this.operand.inferDatatype();
        IDatatype[] paramTypes = null;
        if (null == this.parameters) {
            paramTypes = null;
        } else {
            paramTypes = new IDatatype[this.parameters.length];
            for (int p = 0; p < this.parameters.length; ++p) {
                paramTypes[p] = this.parameters[p].inferDatatype();
            }
        }
        Operation op = null;
        IDatatype relevantType = operandType;
        if (Container.TYPE.isAssignableFrom(operandType.getType())) {
            relevantType = ((Container)operandType.getType()).getContainedType();
        }
        if (Reference.TYPE.isAssignableFrom(relevantType)) {
            op = TypeQueries.getOperation(operandType, this.operation, paramTypes);
            OCLFeatureCall.checkTypeCompliance(op, operandType, paramTypes);
        }
        IDatatype origOperandType = operandType;
        operandType = BaseTypeVisitor.getBaseType(operandType);
        if (null == op) {
            op = TypeQueries.getOperation(operandType, this.operation, paramTypes);
        }
        if (null == op) {
            operandType = TypeQueries.resolveFully(operandType);
            OCLFeatureCall.resolveFully(this.parameters, paramTypes);
            op = TypeQueries.getOperation(operandType, this.operation, paramTypes);
            op = this.checkOperand(op, origOperandType, paramTypes);
            if (null == op && null != paramTypes) {
                IDatatype[] paramTypesBase = new IDatatype[paramTypes.length];
                for (int p = 0; p < paramTypes.length; ++p) {
                    paramTypesBase[p] = BaseTypeVisitor.getBaseType(paramTypes[p]);
                }
                op = TypeQueries.getOperation(operandType, this.operation, paramTypesBase);
                op = this.checkOperand(op, origOperandType, paramTypes);
            }
            if (null == op) {
                op = this.customInferDatatype(true);
                if (null == op) {
                    throw new UnknownOperationException(this.operation, 10101, operandType, paramTypes);
                }
                op = null;
            }
        }
        if (null != op) {
            this.replaceEmptyInitializer(op);
            this.checkRequiredAssignableParameter(op, operandType, paramTypes);
            this.result = this.getActualReturnType(op, operandType, paramTypes);
            if (null != this.result) {
                this.resolvedOperation = op;
            } else {
                throw new UnknownOperationException(this.operation, 10101, operandType, paramTypes);
            }
        }
    }

    private Operation checkOperand(Operation op, IDatatype operandType, IDatatype[] paramTypes) {
        Operation.ReturnTypeMode mode;
        Operation result = op;
        if (null != op && Operation.ReturnTypeMode.PARAM_1_CHECK == (mode = op.getReturnTypeMode()) && Container.TYPE.isAssignableFrom(operandType) && 1 == operandType.getGenericTypeCount() && !operandType.getGenericType(0).isAssignableFrom(this.getActualReturnType(op, operandType, paramTypes))) {
            result = null;
        }
        return result;
    }

    private static void resolveFully(ConstraintSyntaxTree[] parameter, IDatatype[] types) {
        if (null != types) {
            for (int p = 0; p < types.length; ++p) {
                IDatatype deref = TypeQueries.resolveFully(types[p]);
                if (types[p] == deref || parameter[p] instanceof ConstantValue) continue;
                types[p] = deref;
            }
        }
    }

    private void replaceEmptyInitializer(Operation op) {
        if (null != this.parameters) {
            for (int p = 0; p < this.parameters.length; ++p) {
                if (EmptyInitializer.INSTANCE != this.parameters[p]) continue;
                IDatatype pType = op.getParameterType(p);
                try {
                    if (Compound.TYPE.isAssignableFrom(pType)) {
                        this.parameters[p] = new CompoundInitializer((Compound)pType, new String[0], new AbstractVariable[0], new ConstraintSyntaxTree[0]);
                        continue;
                    }
                    if (!Container.TYPE.isAssignableFrom(pType)) continue;
                    this.parameters[p] = new ContainerInitializer((Container)pType, new ConstraintSyntaxTree[0]);
                    continue;
                }
                catch (CSTSemanticException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(OCLFeatureCall.class, "net.ssehub.easy.varModel").exception(e);
                }
            }
        }
    }

    private IDatatype getActualReturnType(Operation op, IDatatype immediateOperand, IDatatype ... parameter) {
        Value val;
        ConstraintSyntaxTree cst;
        IDatatype result = op.getActualReturnType(immediateOperand, parameter);
        Operation.ReturnTypeMode mode = op.getReturnTypeMode();
        if (Operation.ReturnTypeMode.IMMEDIATE_OPERAND_COLLECTION == mode && immediateOperand instanceof MetaType) {
            Value val2;
            if (this.getOperand() instanceof ConstantValue && (val2 = ((ConstantValue)this.getOperand()).getConstantValue()) instanceof MetaTypeValue) {
                IDatatype requestedType = ((MetaTypeValue)val2).getValue();
                result = this.createCollectionType(result, requestedType);
            }
        } else if (Operation.ReturnTypeMode.TYPED_PARAM_1 == mode && mode.getParameterIndex() < this.parameters.length && MetaType.TYPE.isAssignableFrom(result)) {
            ConstraintSyntaxTree param = this.parameters[mode.getParameterIndex()];
            result = this.createCollectionType(immediateOperand, param.getContainedType());
        } else if (Operation.ReturnTypeMode.TYPED_META_1 == mode && mode.getParameterIndex() < this.parameters.length && (cst = this.getParameter(mode.getParameterIndex())) instanceof ConstantValue && (val = ((ConstantValue)cst).getConstantValue()) instanceof MetaTypeValue) {
            result = ((MetaTypeValue)val).getValue();
        }
        return result;
    }

    private IDatatype createCollectionType(IDatatype immediateOperand, IDatatype containedType) {
        IDatatype result;
        if (immediateOperand instanceof Set) {
            Set set = (Set)immediateOperand;
            result = new Set("", containedType, set.getParent());
        } else if (immediateOperand instanceof Sequence) {
            Sequence sequence = (Sequence)immediateOperand;
            result = new Sequence("", containedType, sequence.getParent());
        } else {
            result = containedType;
        }
        return result;
    }

    private void checkRequiredAssignableParameter(Operation op, IDatatype operandType, IDatatype[] paramTypes) throws CSTSemanticException {
        if (op.requiresAssignableParameter()) {
            boolean ok = true;
            for (int p = 0; p < paramTypes.length; ++p) {
                ok &= operandType.isAssignableFrom(paramTypes[p]) || paramTypes[p].isAssignableFrom(operandType);
            }
            if (!ok) {
                throw new CSTSemanticException("the types of all parameters of operation '" + op.getName() + "' need to be compliant", 10100);
            }
        }
    }

    private Operation customInferDatatype(boolean fallback) throws CSTSemanticException {
        Operation op = null;
        if (null != this.opAccessor) {
            IDatatype[] paramTypes;
            int fcOperandIncrement;
            IDatatype fcOperandType;
            if (null == this.operand) {
                fcOperandType = null;
                fcOperandIncrement = 0;
            } else {
                fcOperandType = this.operand.inferDatatype();
                fcOperandIncrement = 1;
            }
            int paramCount = this.getParameterCount() + fcOperandIncrement;
            if (0 == paramCount) {
                paramTypes = null;
            } else {
                paramTypes = new IDatatype[paramCount];
                if (null != fcOperandType) {
                    paramTypes[0] = fcOperandType;
                }
                for (int p = fcOperandIncrement; p < paramCount; ++p) {
                    paramTypes[p] = Reference.dereference(this.parameters[p - fcOperandIncrement].inferDatatype());
                }
            }
            op = this.getCustomOperation(this.opAccessor, paramTypes, new HashSet<ICustomOperationAccessor>(), fcOperandIncrement);
            if (null != op) {
                IDatatype operandType = op.getOperand();
                this.replaceEmptyInitializer(op);
                this.checkRequiredAssignableParameter(op, operandType, paramTypes);
                this.result = this.getActualReturnType(op, operandType, paramTypes);
                this.resolvedOperation = op;
            } else if (!fallback) {
                throw new UnknownOperationException(this.operation, 10101, fcOperandType, paramTypes);
            }
        } else if (!fallback) {
            throw new CSTSemanticException("no custom operator accessor given for " + this.getOperation(), 10103);
        }
        return op;
    }

    private Operation getCustomOperation(ICustomOperationAccessor accessor, IDatatype[] paramTypes, HashSet<ICustomOperationAccessor> done, int opInc) {
        Operation result = null;
        if (!done.contains(accessor)) {
            done.add(accessor);
            result = this.getCustomOperation(accessor, paramTypes, opInc);
            if (null == result) {
                result = this.getCustomOperationOnImports(accessor, paramTypes, done, opInc);
            }
        }
        return result;
    }

    private Operation getCustomOperationOnImports(ICustomOperationAccessor accessor, IDatatype[] paramTypes, HashSet<ICustomOperationAccessor> done, int opInc) {
        Operation result = null;
        for (int i = 0; null == result && i < accessor.getImportsCount(); ++i) {
            ProjectImport imp = accessor.getImport(i);
            if (imp.isWildcard()) {
                if (!imp.isInsert() || imp.getResolved() == null) continue;
                result = this.getCustomOperationOnImports((ICustomOperationAccessor)imp.getResolved(), paramTypes, done, opInc);
                continue;
            }
            if (null != imp.getInterfaceName() || null == imp.getResolved()) continue;
            result = this.getCustomOperation((ICustomOperationAccessor)imp.getResolved(), paramTypes, done, opInc);
        }
        return result;
    }

    private Operation getCustomOperation(ICustomOperationAccessor accessor, IDatatype[] paramTypes, int opInc) {
        CustomOperation op = null;
        IDatatype operandType = accessor.getType();
        for (int o = 0; null == op && o < accessor.getOperationCount(); ++o) {
            CustomOperation tmp = accessor.getOperation(o);
            if (!tmp.getName().equals(this.operation) || !operandType.equals(tmp.getOperand())) continue;
            int tmpParamCount = ((Operation)tmp).getRequiredParameterCount();
            if (null == paramTypes || 0 == paramTypes.length) {
                if (tmpParamCount > 1) continue;
                op = tmp;
                continue;
            }
            if (paramTypes.length < tmpParamCount) continue;
            boolean eq = true;
            for (int p = 0; eq && p < paramTypes.length; ++p) {
                IDatatype pType = this.getParameterType(tmp, p, tmpParamCount, opInc);
                eq = OCLFeatureCall.isParameterAssignable(pType, paramTypes[p]);
            }
            if (!eq) continue;
            op = tmp;
        }
        return op;
    }

    private static boolean isParameterAssignable(IDatatype declared, IDatatype argument) {
        IDatatype arg;
        boolean ok;
        boolean bl = ok = null == declared ? true : declared.isAssignableFrom(argument);
        if (!ok && !(ok = declared.isAssignableFrom(arg = Reference.dereference(argument)))) {
            arg = DerivedDatatype.resolveToBasis(arg);
            ok = declared.isAssignableFrom(arg);
        }
        return ok;
    }

    private IDatatype getParameterType(Operation tmp, int index, int requiredParamCount, int opInc) {
        IDatatype result = null;
        if (index < requiredParamCount) {
            result = tmp.getParameterType(index);
        } else {
            DecisionVariableDeclaration dvd;
            String name = this.parameters[index - opInc].getName();
            if (null != name && null != (dvd = tmp.getParameter(name))) {
                result = dvd.getType();
            }
        }
        return result;
    }

    @Override
    public void accept(IConstraintTreeVisitor visitor) {
        visitor.visitOclFeatureCall(this);
    }

    public ConstraintSyntaxTree getOperand() {
        return this.operand;
    }

    public String getOperation() {
        return this.operation;
    }

    public int getParameterCount() {
        return null == this.parameters ? 0 : this.parameters.length;
    }

    public ConstraintSyntaxTree getParameter(int index) {
        if (null == this.parameters) {
            throw new IndexOutOfBoundsException();
        }
        return this.parameters[index];
    }

    public Operation getResolvedOperation() {
        return this.resolvedOperation;
    }

    public void setResolvedOperation(Operation op) {
        this.resolvedOperation = op;
    }

    public ICustomOperationAccessor getAccessor() {
        return this.opAccessor;
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof OCLFeatureCall) {
            OCLFeatureCall other = (OCLFeatureCall)obj;
            equals = this.operation.equals(other.operation);
            equals = null == this.operand ? (equals &= null == other.operand) : (equals &= null != other.operand && this.operand.equals(other.operand));
            if (null != this.opAccessor) {
                equals &= this.opAccessor.equals(other.opAccessor);
            }
            equals &= Arrays.equals(this.parameters, other.parameters);
        }
        return equals;
    }

    public int hashCode() {
        int hashCode = null == this.operand ? 0 : this.operand.hashCode();
        hashCode *= Arrays.hashCode(this.parameters);
        hashCode *= this.operation.hashCode();
        if (null != this.opAccessor) {
            hashCode *= this.opAccessor.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (null != this.operand) {
            result.append(this.operand.toString() + " ");
        }
        result.append(this.operation.toString());
        if (null != this.parameters) {
            int n = this.parameters.length;
            for (int i = 0; i < n; ++i) {
                result.append(" ");
                result.append(this.parameters[i].toString());
            }
        }
        return result.toString();
    }

    @Override
    public boolean isSemanticallyEqual(ConstraintSyntaxTree otherTree) {
        boolean equals = false;
        if (otherTree instanceof OCLFeatureCall) {
            OCLFeatureCall other = (OCLFeatureCall)otherTree;
            equals = this.operation.equals(other.operation);
            if (null != this.opAccessor) {
                equals &= this.opAccessor.equals(other.opAccessor);
            }
            if (equals) {
                boolean isCommutative;
                boolean bl = isCommutative = this.operation.equals("and") || this.operation.equals("or") || this.operation.equals("xor");
                if (isCommutative) {
                    equals &= this.operand.isSemanticallyEqual(other.operand) && this.parameters[0].isSemanticallyEqual(other.parameters[0]) || this.operand.isSemanticallyEqual(other.parameters[0]) && this.parameters[0].isSemanticallyEqual(other.operand);
                } else {
                    equals &= this.operand.isSemanticallyEqual(other.operand) && this.parameters.length == other.parameters.length;
                    for (int i = 0; i < this.parameters.length && equals; equals &= this.parameters[i].isSemanticallyEqual(other.parameters[i]), ++i) {
                    }
                }
            }
        }
        return equals;
    }
}

