/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cst;

import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;

public class UnknownOperationException
extends CSTSemanticException {
    public UnknownOperationException(String name, int code, IDatatype operand, IDatatype ... parameter) {
        super(UnknownOperationException.constructMessage(name, operand, parameter), code);
    }

    public static final String constructMessage(String name, IDatatype operand, IDatatype ... parameter) {
        StringBuilder builder = new StringBuilder("unknown operation of signature ");
        builder.append(name);
        builder.append("(");
        boolean operandPseudo = false;
        if (null != operand && !(operandPseudo = operand.isPseudoType())) {
            builder.append(IvmlDatatypeVisitor.getUnqualifiedType(operand));
        }
        if (null != parameter) {
            for (int p = 0; p < parameter.length; ++p) {
                if (operandPseudo && p > 0 || !operandPseudo) {
                    builder.append(", ");
                }
                builder.append(IvmlDatatypeVisitor.getUnqualifiedType(parameter[p]));
            }
        }
        builder.append(")");
        return builder.toString();
    }
}

