/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationContext;
import net.ssehub.easy.varModel.cstEvaluation.IValueChangeListener;
import net.ssehub.easy.varModel.cstEvaluation.LocalDecisionVariable;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

abstract class AbstractDecisionVariableEvaluationAccessor
extends EvaluationAccessor {
    private IDecisionVariable variable;

    AbstractDecisionVariableEvaluationAccessor() {
    }

    protected AbstractDecisionVariableEvaluationAccessor bind(IDecisionVariable variable, EvaluationContext context) {
        super.bind(context);
        this.variable = variable;
        return this;
    }

    @Override
    public void clear() {
        super.clear();
        this.variable = null;
    }

    @Override
    public IDecisionVariable getVariable() {
        return this.variable;
    }

    protected void notifyVariableChange(Value oldValue, IAssignmentState oldState, IValueChangeListener.ChangeKind kind) {
        this.getContext().notifyChangeListener(this.getVariable(), oldValue, oldState, kind);
    }

    @Override
    public Value getReferenceValue() {
        Value result;
        IDecisionVariable var = this.getVariable();
        try {
            IDatatype type = var.getDeclaration().getType();
            result = ValueFactory.createValue(new Reference(type.getName(), type, null), var.getDeclaration());
        }
        catch (ValueDoesNotMatchTypeException e) {
            result = null;
        }
        return result;
    }

    public String toString() {
        return null == this.variable ? "null" : this.variable.getDeclaration().getName();
    }

    public boolean isLocal() {
        return this.variable instanceof LocalDecisionVariable;
    }
}

