/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import net.ssehub.easy.varModel.cstEvaluation.ConstantAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationContext;
import net.ssehub.easy.varModel.cstEvaluation.EvaluatorRegistry;
import net.ssehub.easy.varModel.cstEvaluation.GenericOperations;
import net.ssehub.easy.varModel.cstEvaluation.IOperationEvaluator;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.Value;

public class BooleanOperations {
    static final IOperationEvaluator NOT = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            Boolean bool;
            Value value;
            ConstantAccessor result = null;
            if (null != operand && (value = operand.getValue()) instanceof BooleanValue && null != (bool = ((BooleanValue)value).getValue())) {
                result = ConstantAccessor.POOL.getInstance().bind(BooleanValue.toBooleanValue(bool == false), true, operand.getContext());
            }
            return result;
        }
    };
    static final IOperationEvaluator WARNING = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            ConstantAccessor result = null;
            if (null != operand) {
                Boolean bool;
                EvaluationContext context = operand.getContext();
                Value value = operand.getValue();
                if (value instanceof BooleanValue && null != (bool = ((BooleanValue)value).getValue()) && Boolean.FALSE == bool) {
                    context.issueWarning();
                }
                result = ConstantAccessor.POOL.getInstance().bind(BooleanValue.TRUE, true, context);
            }
            return result;
        }
    };

    private BooleanOperations() {
    }

    public static final void register() {
        EvaluatorRegistry.registerEvaluator(GenericOperations.TYPE_OF, BooleanType.TYPE_OF);
        EvaluatorRegistry.registerEvaluator(GenericOperations.EQUALS, BooleanType.EQUALS);
        EvaluatorRegistry.registerEvaluator(GenericOperations.UNEQUALS, BooleanType.UNEQUALS, BooleanType.UNEQUALS_ALIAS);
        EvaluatorRegistry.registerEvaluator(GenericOperations.ASSIGNMENT, BooleanType.ASSIGNMENT);
        EvaluatorRegistry.registerEvaluator(GenericOperations.IS_DEFINED, BooleanType.IS_DEFINED);
        EvaluatorRegistry.registerEvaluator(GenericOperations.COPY, BooleanType.COPY);
        EvaluatorRegistry.registerEvaluator(GenericOperations.TO_STRING, BooleanType.TO_STRING);
        EvaluatorRegistry.registerEvaluator(NOT, BooleanType.NOT);
        EvaluatorRegistry.registerEvaluator(WARNING, BooleanType.WARNING);
        EvaluatorRegistry.registerEvaluator(new BinaryOperationEvaluator(new BinaryBooleanOperation(){

            @Override
            public boolean evaluate(boolean b1, boolean b2) {
                return b1 || b2;
            }
        }), BooleanType.OR);
        EvaluatorRegistry.registerEvaluator(new BinaryOperationEvaluator(new BinaryBooleanOperation(){

            @Override
            public boolean evaluate(boolean b1, boolean b2) {
                return b1 ^ b2;
            }
        }), BooleanType.XOR);
        EvaluatorRegistry.registerEvaluator(new BinaryOperationEvaluator(new BinaryBooleanOperation(){

            @Override
            public boolean evaluate(boolean b1, boolean b2) {
                return b1 && b2;
            }
        }), BooleanType.AND);
        EvaluatorRegistry.registerEvaluator(new BinaryOperationEvaluator(new BinaryBooleanOperation(){

            @Override
            public boolean evaluate(boolean b1, boolean b2) {
                return !b1 || b2;
            }
        }), BooleanType.IMPLIES);
        EvaluatorRegistry.registerEvaluator(new BinaryOperationEvaluator(new BinaryBooleanOperation(){

            @Override
            public boolean evaluate(boolean b1, boolean b2) {
                return !(b1 && !b2 || b2 && !b1);
            }
        }), BooleanType.IFF);
    }

    private static class BinaryOperationEvaluator
    implements IOperationEvaluator {
        private BinaryBooleanOperation op;

        private BinaryOperationEvaluator(BinaryBooleanOperation op) {
            this.op = op;
        }

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            ConstantAccessor result = null;
            if (null != operand && null != arguments && 1 == arguments.length) {
                Value op = operand.getValue();
                Value arg = arguments[0].getValue();
                if (op instanceof BooleanValue && arg instanceof BooleanValue) {
                    Boolean bOp = ((BooleanValue)op).getValue();
                    Boolean bArg = ((BooleanValue)arg).getValue();
                    if (null != bOp && null != bArg) {
                        result = ConstantAccessor.POOL.getInstance().bind(BooleanValue.toBooleanValue(this.op.evaluate(bOp, bArg)), true, operand.getContext());
                    }
                }
            }
            return result;
        }
    }

    private static interface BinaryBooleanOperation {
        public boolean evaluate(boolean var1, boolean var2);
    }
}

