/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.pool.IPoolManager;
import net.ssehub.easy.basics.pool.Pool;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.CompoundVariable;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cstEvaluation.AbstractDecisionVariableEvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationContext;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationVisitor;
import net.ssehub.easy.varModel.cstEvaluation.IValueChangeListener;
import net.ssehub.easy.varModel.cstEvaluation.LocalDecisionVariable;
import net.ssehub.easy.varModel.cstEvaluation.VariableAccessor;
import net.ssehub.easy.varModel.model.values.Value;

class CompoundSlotAccessor
extends AbstractDecisionVariableEvaluationAccessor {
    public static final Pool<CompoundSlotAccessor> POOL = new Pool<CompoundSlotAccessor>(new IPoolManager<CompoundSlotAccessor>(){

        @Override
        public CompoundSlotAccessor create() {
            return new CompoundSlotAccessor();
        }

        @Override
        public void clear(CompoundSlotAccessor instance) {
            instance.clear();
        }
    });
    private IDecisionVariable slotVariable;

    private CompoundSlotAccessor() {
    }

    public CompoundSlotAccessor bind(IDecisionVariable variable, String slotName, EvaluationContext context) {
        super.bind(variable, context);
        this.slotVariable = ((CompoundVariable)variable).getNestedVariable(slotName);
        return this;
    }

    public CompoundSlotAccessor bind(LocalDecisionVariable variable, String slotName, EvaluationContext context) {
        super.bind(variable, context);
        this.slotVariable = variable.getNestedVariable(slotName);
        return this;
    }

    @Override
    public void clear() {
        super.clear();
        this.slotVariable = null;
    }

    @Override
    public Value getValue() {
        Value result = null != this.slotVariable ? this.slotVariable.getValue() : null;
        return result;
    }

    @Override
    public EvaluationAccessor getValue(EvaluationAccessor accessor) {
        EvaluationAccessor result = null;
        if (null != this.slotVariable) {
            VariableAccessor tmp = VariableAccessor.POOL.getInstance().bind(this.slotVariable, this.getContext());
            result = tmp.getValue(accessor);
            VariableAccessor.POOL.releaseInstance(tmp);
        }
        return result;
    }

    @Override
    public boolean setValue(Value value, boolean asAssignment) {
        boolean successful = false;
        EvaluationContext context = this.getContext();
        if (context.allowAssignValues() && null != this.slotVariable && null != value) {
            boolean assign = true;
            IAssignmentState slotState = this.slotVariable.getState();
            if (AssignmentState.DEFAULT == context.getAssignmentState()) {
                if (!this.slotVariable.getParent().wasCreated()) {
                    successful = false;
                    assign = false;
                } else if (slotState != AssignmentState.UNDEFINED && slotState != AssignmentState.FROZEN) {
                    assign = false;
                }
            }
            if (assign) {
                successful = this.assignValue(value, asAssignment);
            }
        }
        return successful;
    }

    private final boolean assignValue(Value value, boolean asAssignment) {
        boolean successful = false;
        Value oldValue = this.slotVariable.getValue();
        IAssignmentState oldState = this.slotVariable.getState();
        if (!Value.equalsPartially(oldValue, value) && oldState != AssignmentState.USER_ASSIGNED) {
            EvaluationContext context = this.getContext();
            IAssignmentState targetState = context.getTargetState(this.slotVariable);
            if (null != targetState) {
                try {
                    this.dereferenceIfNeeded(this.slotVariable, value).setValue(value, targetState, asAssignment);
                    successful = true;
                    this.notifyVariableChange(oldValue, oldState, IValueChangeListener.ChangeKind.FULL);
                }
                catch (ConfigurationException e) {
                    context.addErrorMessage(e);
                }
            } else {
                context.addMessage(new EvaluationVisitor.Message("Assignment state conflict", Status.ERROR, this.slotVariable, 101));
            }
        } else {
            successful = true;
        }
        return successful;
    }

    @Override
    public IDecisionVariable getVariable() {
        return this.slotVariable;
    }

    @Override
    public void release() {
        POOL.releaseInstance(this);
    }

    @Override
    public boolean isAssignable() {
        return true;
    }
}

