/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import java.util.HashSet;
import java.util.Set;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationUtils;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.CustomOperation;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.values.Value;

class DispatchInformation {
    private CustomOperation operation;
    private IDatatype[] argTypes;
    private int bestDiff;
    private CustomOperation bestMatch;
    private Set<String> candidates;
    private Set<Project> doneProjects;
    private String opName;
    private int opParamCount;
    private IDatatype returnType;

    DispatchInformation(CustomOperation operation, EvaluationAccessor[] args) {
        this.operation = operation;
        this.opName = operation.getName();
        this.opParamCount = operation.getParameterCount();
        this.returnType = operation.getReturns();
        this.argTypes = new IDatatype[args.length];
        int n = args.length;
        for (int a = 0; a < n; ++a) {
            Value val = args[a].getValue();
            if (null != val) {
                this.argTypes[a] = val.getType();
                continue;
            }
            if (args[a].getVariable() == null) continue;
            this.argTypes[a] = args[a].getVariable().getDeclaration().getType();
        }
        this.bestMatch = operation;
        this.bestDiff = EvaluationUtils.calculateDiff(operation, this.returnType, this.argTypes);
        this.candidates = new HashSet<String>();
        this.candidates.add(operation.getSignature());
        this.doneProjects = new HashSet<Project>();
    }

    CustomOperation getBestMatch() {
        return this.bestMatch;
    }

    void checkForDispatch(Project scope) {
        if (!this.doneProjects.contains(scope)) {
            this.doneProjects.add(scope);
            int n = scope.getOperationCount();
            for (int o = 0; this.bestDiff > 0 && o < n; ++o) {
                int diff;
                String tmpSignature;
                CustomOperation tmp = scope.getOperation(o);
                if (tmp == this.operation || !this.opName.equals(tmp.getName()) || this.opParamCount != tmp.getParameterCount() || this.candidates.contains(tmpSignature = tmp.getSignature()) || (diff = EvaluationUtils.calculateDiff(tmp, this.returnType, this.argTypes)) < 0) continue;
                this.candidates.add(tmpSignature);
                if (diff >= this.bestDiff) continue;
                this.bestMatch = tmp;
                this.bestDiff = diff;
            }
            n = scope.getImportsCount();
            for (int i = 0; this.bestDiff > 0 && i < n; ++i) {
                Project imp = (Project)scope.getImport(i).getResolved();
                if (null == imp) continue;
                this.checkForDispatch(imp);
            }
        }
    }
}

