/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import java.text.Collator;
import java.util.Locale;
import net.ssehub.easy.basics.DefaultLocale;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IConfiguration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationVisitor;
import net.ssehub.easy.varModel.cstEvaluation.IValueChangeListener;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.Value;

public abstract class EvaluationContext
implements IConfiguration {
    private Locale locale = DefaultLocale.getDefaultLocale();

    void clear() {
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (null != locale) {
            this.locale = locale;
        }
    }

    public Collator getCollator() {
        return Collator.getInstance(this.getLocale());
    }

    public abstract boolean allowAssignValues();

    public abstract void notifyChangeListener(IDecisionVariable var1, Value var2, IAssignmentState var3, IValueChangeListener.ChangeKind var4);

    public abstract void addMessage(EvaluationVisitor.Message var1);

    public abstract IAssignmentState getTargetState(IDecisionVariable var1);

    public void addErrorMessage(String message, int code) {
        this.addErrorMessage(message, null, code);
    }

    public void addErrorMessage(String message, IDecisionVariable variable, int code) {
        this.addMessage(new EvaluationVisitor.Message(message, Status.ERROR, variable, code));
    }

    public void addErrorMessage(Throwable throwable) {
        this.addErrorMessage(throwable.getMessage(), 110);
    }

    public abstract void issueWarning();

    public abstract boolean allowPropagation();

    public Value getDereferencedValue(Value value) {
        Value dereferencedValue = value;
        if (null != dereferencedValue && dereferencedValue instanceof ReferenceValue) {
            AbstractVariable referredDecl = ((ReferenceValue)dereferencedValue).getValue();
            if (null != referredDecl) {
                IDecisionVariable var = this.getDecision(referredDecl);
                if (null != var && null != var.getValue()) {
                    dereferencedValue = var.getValue();
                }
            } else {
                ConstraintSyntaxTree refExpression = ((ReferenceValue)dereferencedValue).getValueEx();
                EvaluationVisitor evalVisitor = new EvaluationVisitor(this, null, false, null);
                refExpression.accept(evalVisitor);
                if (!evalVisitor.constraintFailed()) {
                    dereferencedValue = evalVisitor.getResult();
                }
            }
        }
        return dereferencedValue;
    }

    public abstract IAssignmentState getAssignmentState();
}

