/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.modelManagement.IVariable;
import net.ssehub.easy.varModel.Bundle;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.CopyVisitor;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationVisitor;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.CustomOperation;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;

class EvaluationUtils {
    EvaluationUtils() {
    }

    static String createSpaces(int count) {
        String res = "";
        for (int i = 1; i <= count; ++i) {
            res = res + " ";
        }
        return res;
    }

    static void release(EvaluationAccessor[] accessors) {
        for (int a = 0; a < accessors.length; ++a) {
            if (null == accessors[a]) continue;
            accessors[a].release();
        }
    }

    static Compound getDeclaringCompound(AbstractVariable decl) {
        IModelElement parent = decl.getParent();
        while (!(parent instanceof Project) && !(parent instanceof Compound)) {
            parent = parent.getParent();
        }
        return parent instanceof Compound ? (Compound)parent : null;
    }

    static Map<IDatatype, List<AbstractVariable>> groupQuantors(Iterator<AbstractVariable> staticIter) {
        HashMap<IDatatype, List<AbstractVariable>> iterGroups = new HashMap<IDatatype, List<AbstractVariable>>();
        while (staticIter.hasNext()) {
            AbstractVariable var = staticIter.next();
            Compound declaring = EvaluationUtils.getDeclaringCompound(var);
            if (null == declaring) continue;
            ArrayList<AbstractVariable> group = (ArrayList<AbstractVariable>)iterGroups.get(declaring);
            if (null == group) {
                group = new ArrayList<AbstractVariable>();
                iterGroups.put(declaring, group);
            }
            group.add(var);
        }
        return iterGroups;
    }

    static IDecisionVariable findAttribute(IDecisionVariable var, AbstractVariable decl, boolean byName) {
        IDecisionVariable result = null;
        if (null != var) {
            int n = var.getAttributesCount();
            for (int a = 0; null == result && a < n; ++a) {
                IDecisionVariable attribute = var.getAttribute(a);
                if (byName && attribute.getDeclaration().getName().equals(decl.getName())) {
                    result = attribute;
                    continue;
                }
                if (byName || !attribute.getDeclaration().equals(decl)) continue;
                result = attribute;
            }
        }
        return result;
    }

    static int calculateDiff(CustomOperation operation, IDatatype returns, IDatatype[] argTypes) {
        int diff = EvaluationUtils.diff(returns, operation.getReturns());
        if (diff >= 0) {
            int n = argTypes.length;
            for (int a = 0; diff >= 0 && a < n; ++a) {
                int tmp = EvaluationUtils.diff(operation.getParameterType(a).getType(), argTypes[a]);
                if (tmp < 0) {
                    diff = -1;
                    continue;
                }
                diff += tmp;
            }
        }
        return diff;
    }

    private static int diff(IDatatype opType, IDatatype paramType) {
        int result = -1;
        if (opType.isAssignableFrom(paramType)) {
            if (paramType.isAssignableFrom(opType)) {
                result = 0;
            } else {
                result = 1;
                if (Compound.TYPE.isAssignableFrom(paramType)) {
                    result += EvaluationUtils.diff((Compound)paramType, opType);
                }
                if (Container.TYPE.isAssignableFrom(opType) && Container.TYPE.isAssignableFrom(paramType)) {
                    result = EvaluationUtils.diffContainer((Container)opType, (Container)paramType);
                }
            }
        }
        if (result != 0 && paramType instanceof Reference) {
            result = EvaluationUtils.diff(opType, Reference.dereference(paramType));
        }
        return result;
    }

    private static int diff(Compound type, IDatatype opType) {
        int result = 0;
        if (!TypeQueries.sameTypes(type, opType)) {
            ++result;
            for (int r = 0; r < type.getRefinesCount(); ++r) {
                result += EvaluationUtils.diff(type.getRefines(r), opType);
            }
        }
        return result;
    }

    private static int diffContainer(Container opCont, Container paramCont) {
        int paramContGen;
        int result = 0;
        int opContGen = opCont.getGenericTypeCount();
        if (opContGen != (paramContGen = paramCont.getGenericTypeCount())) {
            result = -1;
        } else {
            for (int i = 0; i < opContGen; ++i) {
                int tmp = EvaluationUtils.diff(opCont.getGenericType(i), paramCont.getGenericType(i));
                if (tmp < 0) {
                    result = -1;
                    break;
                }
                result += tmp;
            }
        }
        return result;
    }

    static class VariableReplacer
    implements CopyVisitor.IVariableReplacer {
        private Variable iter;
        private List<AbstractVariable> decls;

        VariableReplacer(DecisionVariableDeclaration iter, List<AbstractVariable> decls) {
            this.iter = new Variable(iter);
            try {
                this.iter.inferDatatype();
            }
            catch (CSTSemanticException e) {
                Bundle.getLogger(EvaluationVisitor.class).exception(e);
            }
            this.decls = decls;
        }

        @Override
        public IVariable map(IVariable variable) {
            return null;
        }

        @Override
        public ConstraintSyntaxTree mapLeaf(Variable variable) {
            CompoundAccess result = null;
            AbstractVariable var = variable.getVariable();
            for (int i = 0; null == result && i < this.decls.size(); ++i) {
                if (this.decls.get(i) != var) continue;
                result = new CompoundAccess(this.iter, var.getName());
            }
            return result;
        }

        @Override
        public ConstraintSyntaxTree mapSelf(Self self) {
            return null;
        }
    }
}

