/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.CompoundVariable;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.ConfigurationInitializerRegistry;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IConfiguration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.BlockExpression;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.Comment;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.CopyVisitor;
import net.ssehub.easy.varModel.cst.DeferInitExpression;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.IfThen;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.MultiAndExpression;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Parenthesis;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.UnresolvedExpression;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.cstEvaluation.CompoundSlotAccessor;
import net.ssehub.easy.varModel.cstEvaluation.ConstantAccessor;
import net.ssehub.easy.varModel.cstEvaluation.ConstantValueResolver;
import net.ssehub.easy.varModel.cstEvaluation.ConstraintOperations;
import net.ssehub.easy.varModel.cstEvaluation.ContextStack;
import net.ssehub.easy.varModel.cstEvaluation.DispatchInformation;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationContext;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationUtils;
import net.ssehub.easy.varModel.cstEvaluation.EvaluatorRegistry;
import net.ssehub.easy.varModel.cstEvaluation.IConstraintEvaluator;
import net.ssehub.easy.varModel.cstEvaluation.IIteratorEvaluator;
import net.ssehub.easy.varModel.cstEvaluation.IOperationEvaluator;
import net.ssehub.easy.varModel.cstEvaluation.IResolutionListener;
import net.ssehub.easy.varModel.cstEvaluation.IValueChangeListener;
import net.ssehub.easy.varModel.cstEvaluation.ListWrapperValue;
import net.ssehub.easy.varModel.cstEvaluation.LocalConfiguration;
import net.ssehub.easy.varModel.cstEvaluation.LocalDecisionVariable;
import net.ssehub.easy.varModel.cstEvaluation.StaticAccessFinder;
import net.ssehub.easy.varModel.cstEvaluation.VariableAccessor;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.AnyType;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.CustomOperation;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Operation;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.MetaTypeValue;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;
import net.ssehub.easy.varModel.persistency.StringProvider;

public class EvaluationVisitor
implements IConstraintTreeVisitor,
IConstraintEvaluator {
    protected IAssignmentState assignmentState;
    private final boolean modelCopy = ConfigurationInitializerRegistry.getInitializer().supportsElementCopy();
    private EvaluationAccessor result;
    private int opNesting = 0;
    private boolean assignmentsOnly;
    private IValueChangeListener listener;
    private IResolutionListener resolutionListener;
    private List<Message> messages = new ArrayList<Message>();
    private EvaluationContextImpl context;
    private Project dispatchScope;
    private StaticAccessFinder finder = new StaticAccessFinder();
    private Set<DecisionVariableDeclaration> selfVars = new HashSet<DecisionVariableDeclaration>();
    private Value selfValue;
    private boolean issueWarning;
    private ConstraintSyntaxTree innermostFailed;
    private Map<AbstractVariable, IDecisionVariable> varMapping = new HashMap<AbstractVariable, IDecisionVariable>();
    private ConstantValueResolver constantResolver = new ConstantValueResolver(this);
    private ContextStack contextStack = new ContextStack();

    public EvaluationVisitor() {
    }

    public EvaluationVisitor(IConfiguration config, IAssignmentState assignmentState, boolean assignmentsOnly, IValueChangeListener listener) {
        this();
        this.init(config, assignmentState, assignmentsOnly, listener);
    }

    public void init(IConfiguration config, IAssignmentState assignmentState, boolean assignmentsOnly, IValueChangeListener listener) {
        this.context = null == this.context ? new EvaluationContextImpl(config) : this.context.reset(config);
        this.assignmentState = assignmentState;
        this.assignmentsOnly = assignmentsOnly;
        this.listener = listener;
    }

    public void setAssignmentState(IAssignmentState assignmentState) {
        this.assignmentState = assignmentState;
    }

    public void setResolutionListener(IResolutionListener listener) {
        this.resolutionListener = listener;
    }

    public void setValueChangeListener(IValueChangeListener listener) {
        this.listener = listener;
    }

    void addMapping(AbstractVariable decl, IDecisionVariable var) {
        this.varMapping.put(decl, var);
    }

    void removeMapping(AbstractVariable decl) {
        this.varMapping.remove(decl);
    }

    public Project setDispatchScope(Project scope) {
        Project oldScope = this.dispatchScope;
        this.dispatchScope = scope;
        return oldScope;
    }

    public void setSelfValue(CompoundValue selfValue) {
        this.selfValue = selfValue;
    }

    public void clear() {
        this.clearIntermediary();
        if (null != this.context) {
            this.context.clear();
        }
        this.dispatchScope = null;
    }

    public void clearIntermediary() {
        this.clearResult();
        this.assignmentState = null;
        this.messages.clear();
        this.selfVars.clear();
        this.selfValue = null;
        this.issueWarning = false;
        this.innermostFailed = null;
        this.contextStack.clear();
    }

    public void clearResult() {
        if (null != this.result) {
            this.result.release();
            this.result = null;
        }
    }

    @Override
    public Value getResult() {
        Value result = null;
        if (null != this.result) {
            result = this.result.getValue();
        }
        return result;
    }

    public IDecisionVariable getResultVariable() {
        IDecisionVariable result = null;
        if (null != this.result) {
            result = this.result.getVariable();
        }
        return result;
    }

    protected EvaluationAccessor getResultAccessor(boolean nullify) {
        EvaluationAccessor res = this.result;
        if (nullify) {
            this.result = null;
        }
        return res;
    }

    protected void setResultAcessor(EvaluationAccessor result) {
        this.result = result;
    }

    public static boolean constraintFulfilled(Object result) {
        return BooleanValue.TRUE == result || Boolean.TRUE == result;
    }

    public static boolean constraintFailed(Object result) {
        return BooleanValue.FALSE == result || Boolean.FALSE == result;
    }

    public static boolean constraintUndefined(Object result) {
        return result == null;
    }

    @Override
    public boolean constraintFulfilled() {
        return EvaluationVisitor.constraintFulfilled(this.result != null ? this.result.getValue() : null);
    }

    @Override
    public boolean constraintFailed() {
        return EvaluationVisitor.constraintFailed(this.result != null ? this.result.getValue() : null);
    }

    @Override
    public boolean constraintUndefined() {
        return EvaluationVisitor.constraintUndefined(this.result != null ? this.result.getValue() : null);
    }

    @Override
    public boolean constraintIsAWarning() {
        return this.issueWarning;
    }

    public ConstraintSyntaxTree[] getFailedExpression() {
        ConstraintSyntaxTree[] result = null != this.innermostFailed ? new ConstraintSyntaxTree[]{this.innermostFailed} : null;
        return result;
    }

    private void addMessage(Message message) {
        this.messages.add(message);
    }

    private void error(String text, int code) {
        this.addMessage(new Message(text, Status.ERROR, null, code));
    }

    private void notImplementedError(String subject) {
        this.addMessage(new Message("cannot evaluate " + subject + " as it is currently not implemented", Status.UNSUPPORTED, null, 100));
    }

    private void exception(Throwable th) {
        this.error(th.getMessage(), 110);
    }

    @Override
    public int getMessageCount() {
        return this.messages.size();
    }

    @Override
    public Message getMessage(int index) {
        return this.messages.get(index);
    }

    public ConstraintSyntaxTree visit(ConstraintSyntaxTree cst) {
        ConstraintSyntaxTree tmp = cst;
        tmp.accept(this.finder);
        Iterator<AbstractVariable> staticIter = this.finder.getResults();
        if (staticIter.hasNext()) {
            tmp = this.bindFreeVarsByQuantors(tmp, EvaluationUtils.groupQuantors(staticIter));
        } else if (null != this.finder.getSelf()) {
            IDatatype type = this.finder.getSelf().getType();
            Value allInstances = this.context.getAllInstances(type);
            if (allInstances instanceof ContainerValue) {
                Container cont = (Container)allInstances.getType();
                DecisionVariableDeclaration iter = new DecisionVariableDeclaration("iter", cont.getContainedType(), null);
                this.selfVars.add(iter);
                tmp = new ContainerOperationCall(new ConstantValue(allInstances), Container.FORALL.getName(), tmp, iter);
                try {
                    tmp.inferDatatype();
                }
                catch (CSTSemanticException e) {
                    tmp = null;
                }
            } else {
                tmp = null;
                this.error("Cannot determine all instances for " + IvmlDatatypeVisitor.getQualifiedType(type), 102);
            }
        }
        this.finder.clear();
        if (null != tmp) {
            cst = tmp;
            cst.accept(this);
        }
        return cst;
    }

    private ConstraintSyntaxTree bindFreeVarsByQuantors(ConstraintSyntaxTree cst, Map<IDatatype, List<AbstractVariable>> quantorGroups) {
        Iterator<Map.Entry<IDatatype, List<AbstractVariable>>> groupIter = quantorGroups.entrySet().iterator();
        while (null != cst && groupIter.hasNext()) {
            Map.Entry<IDatatype, List<AbstractVariable>> entry = groupIter.next();
            IDatatype eType = entry.getKey();
            Value allInstances = this.context.getAllInstances(eType);
            IDatatype type = allInstances instanceof ContainerValue ? ((Container)allInstances.getType()).getContainedType() : new Reference("", eType, null);
            List<AbstractVariable> group = entry.getValue();
            DecisionVariableDeclaration iter = null;
            iter = new DecisionVariableDeclaration("iter", type, null);
            this.selfVars.add(iter);
            CopyVisitor cVis = new CopyVisitor(new EvaluationUtils.VariableReplacer(iter, group));
            cst.accept(cVis);
            cst = cVis.getResult();
            if (null != cst && null != allInstances) {
                try {
                    cst = new ContainerOperationCall(new ConstantValue(allInstances), Container.FORALL.getName(), cst, iter);
                    cst.inferDatatype();
                }
                catch (CSTSemanticException e) {
                    cst = null;
                }
                continue;
            }
            cst = null;
            this.error("Cannot determine all instances for " + IvmlDatatypeVisitor.getQualifiedType(type), 102);
        }
        return cst;
    }

    @Override
    public void visitConstantValue(ConstantValue value) {
        Value constValue = value.getConstantValue();
        constValue.accept(this.constantResolver);
        Value resolvedValue = this.constantResolver.getValue();
        if (null != resolvedValue) {
            if (resolvedValue == constValue) {
                resolvedValue = resolvedValue.clone();
            }
            this.result = ConstantAccessor.POOL.getInstance().bind(resolvedValue, true, this.context);
        } else {
            this.result = null;
        }
    }

    @Override
    public void visitVariable(Variable variable) {
        ConstraintSyntaxTree qualifier = variable.getQualifier();
        if (null != qualifier) {
            IDecisionVariable var;
            IDecisionVariable attribute = null;
            qualifier.accept(this);
            if (null != this.result && null != (var = this.result.getVariable())) {
                boolean byName = this.isFreezeVariable(qualifier);
                attribute = EvaluationUtils.findAttribute(var, variable.getVariable(), byName);
                if (null == attribute && !byName) {
                    attribute = EvaluationUtils.findAttribute(var, variable.getVariable(), true);
                }
            }
            if (null != attribute) {
                this.clearResult();
                this.result = VariableAccessor.POOL.getInstance().bind(attribute, (EvaluationContext)this.context);
            }
        } else {
            IDecisionVariable resolved = variable.getResolved();
            this.result = null != resolved ? VariableAccessor.POOL.getInstance().bind(resolved, (EvaluationContext)this.context) : VariableAccessor.POOL.getInstance().bind(variable.getVariable(), (EvaluationContext)this.context);
        }
    }

    @Override
    public void visitParenthesis(Parenthesis parenthesis) {
        parenthesis.getExpr().accept(this);
    }

    @Override
    public void visitDeferInitExpression(DeferInitExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visitComment(Comment comment) {
    }

    private void evaluateCustomOperation(CustomOperation operation, EvaluationAccessor operand, EvaluationAccessor[] args) {
        if (null != operand) {
            int dec = 0;
            while (args.length - 1 - dec >= 0 && null == args[args.length - 1 - dec]) {
                ++dec;
            }
            EvaluationAccessor[] tmp = new EvaluationAccessor[args.length + 1 - dec];
            tmp[0] = operand;
            System.arraycopy(args, 0, tmp, 1, args.length - dec);
            args = tmp;
        }
        if (args.length == operation.getParameterCount()) {
            LocalConfiguration cfg = new LocalConfiguration();
            this.context.pushLevel(cfg);
            boolean allOk = true;
            for (int a = 0; allOk && a < args.length; ++a) {
                if (args[a] != null) {
                    LocalDecisionVariable argument = new LocalDecisionVariable(operation.getParameterDeclaration(a), this.context, args[a].getVariable());
                    try {
                        argument.setValue(args[a].getValue(), AssignmentState.ASSIGNED);
                    }
                    catch (ConfigurationException e) {
                        this.exception(e);
                    }
                    cfg.addDecision(argument);
                    continue;
                }
                allOk = false;
            }
            if (allOk) {
                CustomOperation dyn;
                if (!operation.isStatic() && (dyn = this.dynamicDispatch(operation, args)) != operation) {
                    cfg.rebind(operation, dyn);
                    operation = dyn;
                }
                operation.getFunction().accept(this);
            }
            this.context.popLevel();
        } else {
            this.error("argument and operation count do not match", 102);
        }
    }

    private boolean handleBinaryBoolean(EvaluationAccessor operand, OCLFeatureCall call) {
        boolean hasBeenEvaluated = false;
        Operation op = call.getResolvedOperation();
        EvaluationAccessor operandAccessor = operand;
        EvaluationAccessor parameterAccessor = null;
        ConstraintSyntaxTree parameter = call.getParameter(0);
        if (this.containsIsDefined(call.getOperand()) && null != parameter) {
            parameterAccessor = this.getAccessor(parameterAccessor, parameter);
            operandAccessor = this.getAccessor(operandAccessor, call.getOperand());
        }
        if (op == BooleanType.AND) {
            if (null != operandAccessor && operandAccessor.getValue() == BooleanValue.FALSE) {
                this.result = ConstantAccessor.POOL.getInstance().bind(BooleanValue.FALSE, true, operand.getContext());
                hasBeenEvaluated = true;
            } else if (null != operand && null != parameter && null != (parameterAccessor = this.getAccessor(parameterAccessor, parameter)) && parameterAccessor.getValue() == BooleanValue.FALSE) {
                this.result = ConstantAccessor.POOL.getInstance().bind(BooleanValue.FALSE, true, operand.getContext());
                hasBeenEvaluated = true;
            }
        } else if (op == BooleanType.OR) {
            if (null != operandAccessor && operandAccessor.getValue() == BooleanValue.TRUE) {
                this.result = ConstantAccessor.POOL.getInstance().bind(BooleanValue.TRUE, true, operand.getContext());
                hasBeenEvaluated = true;
            } else if (null != operandAccessor && null != parameter && null != (parameterAccessor = this.getAccessor(parameterAccessor, parameter)) && parameterAccessor.getValue() == BooleanValue.TRUE) {
                this.result = ConstantAccessor.POOL.getInstance().bind(BooleanValue.TRUE, true, operand.getContext());
                hasBeenEvaluated = true;
            }
        } else if (null != operandAccessor && null != parameter && null != (parameterAccessor = this.getAccessor(parameterAccessor, parameter))) {
            boolean xorRes = operand.getValue() == BooleanValue.TRUE ^ this.result.getValue() == BooleanValue.TRUE;
            this.result = ConstantAccessor.POOL.getInstance().bind(BooleanValue.toBooleanValue(xorRes), true, operand.getContext());
            hasBeenEvaluated = true;
        }
        if (null != parameterAccessor) {
            parameterAccessor.release();
        }
        if (operandAccessor != operand) {
            operandAccessor.release();
        }
        return hasBeenEvaluated;
    }

    private EvaluationAccessor getAccessor(EvaluationAccessor accessor, ConstraintSyntaxTree expression) {
        EvaluationAccessor result = accessor;
        if (null == result) {
            expression.accept(this);
            result = this.result;
        }
        return result;
    }

    private boolean evaluateOclFeatureCall(OCLFeatureCall call) {
        return !this.assignmentsOnly || this.assignmentsOnly && (this.opNesting > 0 || "=".equals(call.getOperation()));
    }

    private boolean setAllowPropagation(Operation op, boolean allow) {
        boolean result = true;
        if (null != this.context) {
            result = this.context.setAllowPropagation(op, allow);
        }
        return result;
    }

    private boolean containsIsDefined(ConstraintSyntaxTree constraint) {
        boolean found;
        if (constraint instanceof OCLFeatureCall) {
            OCLFeatureCall call = (OCLFeatureCall)constraint;
            found = "isDefined".equals(call.getOperation());
            if (!found) {
                found = this.containsIsDefined(call.getOperand());
                for (int p = 0; !found && p < call.getParameterCount(); ++p) {
                    found = this.containsIsDefined(call.getParameter(p));
                }
            }
        } else {
            found = false;
        }
        return found;
    }

    @Override
    public void visitOclFeatureCall(OCLFeatureCall call) {
        if (this.evaluateOclFeatureCall(call)) {
            EvaluationAccessor operand;
            ++this.opNesting;
            boolean pop = false;
            Operation op = call.getResolvedOperation();
            if (null != call.getOperand()) {
                boolean oldState = this.setAllowPropagation(op, false);
                call.getOperand().accept(this);
                operand = this.result;
                this.result = null;
                this.setAllowPropagation(op, oldState);
                if ("=".equals(op.getName())) {
                    this.contextStack.push(operand);
                    pop = true;
                }
            } else {
                operand = null;
            }
            EvaluationAccessor[] args = new EvaluationAccessor[op.getParameterCount()];
            boolean allOk = this.evaluateArguments(call, op, operand, args);
            if (allOk) {
                if (op instanceof CustomOperation) {
                    this.evaluateCustomOperation((CustomOperation)op, operand, args);
                } else {
                    IOperationEvaluator evaluator = this.getOperationEvaluator(op);
                    if (null == evaluator) {
                        this.notImplementedError(null != op ? op.getName() : call.getOperation());
                    } else if (null != operand) {
                        this.result = evaluator.evaluate(operand, args);
                    }
                }
                if (null == operand && null != this.result) {
                    this.result.validateContext(this.context);
                }
            }
            if (pop) {
                this.contextStack.pop();
            }
            if (null != operand) {
                operand.release();
            }
            EvaluationUtils.release(args);
            --this.opNesting;
            this.recordIfFailed(call);
        }
    }

    private boolean evaluateArguments(OCLFeatureCall call, Operation op, EvaluationAccessor operand, EvaluationAccessor[] args) {
        int a;
        boolean allOk = true;
        if (op == BooleanType.AND || op == BooleanType.OR || op == BooleanType.XOR) {
            allOk = !this.handleBinaryBoolean(operand, call);
        } else if (op == ConstraintType.ASSIGNMENT) {
            this.result = ConstraintOperations.handleConstraintAssignment(operand, call.getParameter(0));
            allOk = false;
        } else if (op == ConstraintType.EQUALS || op == ConstraintType.UNEQUALS || op == ConstraintType.UNEQUALS_ALIAS) {
            this.result = ConstraintOperations.handleConstraintEquals(operand, call.getParameter(0), op != ConstraintType.EQUALS);
            allOk = false;
        }
        HashMap<String, EvaluationAccessor> namedArgs = null;
        this.contextStack.push();
        for (a = 0; allOk && a < op.getParameterCount(); ++a) {
            this.contextStack.setVariable(op.getParameterDeclaration(a));
            if (op == BooleanType.IMPLIES && (null == operand || BooleanValue.FALSE.equals(operand.getValue()))) {
                this.result = null == operand ? null : ConstantAccessor.POOL.getInstance().bind(BooleanValue.TRUE, true, this.context);
                allOk = false;
                continue;
            }
            String argName = null;
            if (a < call.getParameterCount()) {
                call.getParameter(a).accept(this);
                argName = call.getParameter(a).getName();
            } else if (null != op.getParameterDefaultValue(a)) {
                op.getParameterDefaultValue(a).accept(this);
            } else {
                this.result = null;
                break;
            }
            if (null == this.result && op.acceptsNull() && op.acceptsNull()) {
                this.result = ConstantAccessor.POOL.getInstance().bind(null, true, this.context);
            }
            if (argName != null) {
                if (null == namedArgs) {
                    namedArgs = new HashMap<String, EvaluationAccessor>();
                }
                namedArgs.put(argName, this.result);
            } else {
                args[a] = this.result;
            }
            if (null == this.result) {
                allOk = false;
            }
            this.result = null;
        }
        this.contextStack.pop();
        if (allOk && null != namedArgs) {
            for (a = 0; a < args.length; ++a) {
                String paramName;
                EvaluationAccessor arg;
                DecisionVariableDeclaration param = op.getParameterDeclaration(a);
                if (null == param || null == (arg = (EvaluationAccessor)namedArgs.get(paramName = param.getName()))) continue;
                args[a] = arg;
            }
        }
        return allOk;
    }

    private void recordIfFailed(ConstraintSyntaxTree cst) {
        Value value;
        if (null != this.result && (value = this.result.getValue()) instanceof BooleanValue && Boolean.FALSE == ((BooleanValue)value).getValue() && null == this.innermostFailed) {
            this.innermostFailed = cst;
        }
    }

    private CustomOperation dynamicDispatch(CustomOperation operation, EvaluationAccessor[] args) {
        CustomOperation result;
        if (null != this.dispatchScope) {
            DispatchInformation info = new DispatchInformation(operation, args);
            info.checkForDispatch(this.dispatchScope);
            result = info.getBestMatch();
        } else {
            result = operation;
        }
        return result;
    }

    @Override
    public void visitLet(Let let) {
        this.clearResult();
        LocalConfiguration cfg = new LocalConfiguration();
        this.context.pushLevel(cfg);
        LocalDecisionVariable lVar = this.addLocalVariable(cfg, let.getVariable(), let.getInitExpression(), true);
        let.getInExpression().accept(this);
        this.disposeLocalVariable(lVar);
        this.context.popLevel();
    }

    void disposeLocalVariable(LocalDecisionVariable var) {
        if (null != this.resolutionListener) {
            this.resolutionListener.localVariableDisposed(var);
        }
    }

    void disposeLocalVariables(LocalDecisionVariable[] vars) {
        for (int v = 0; null != this.resolutionListener && v < vars.length; ++v) {
            this.resolutionListener.localVariableDisposed(vars[v]);
        }
    }

    private LocalDecisionVariable addLocalVariable(LocalConfiguration cfg, DecisionVariableDeclaration decl, ConstraintSyntaxTree initEx, boolean notify) {
        Value value = null;
        IDecisionVariable parent = null;
        if (null == initEx) {
            initEx = decl.getDefaultValue();
        }
        if (null != initEx) {
            initEx.accept(this);
            if (null != this.result) {
                value = this.result.getValue();
                parent = this.result.getVariable();
                this.clearResult();
            }
        }
        LocalDecisionVariable var = new LocalDecisionVariable(decl, this.context, parent);
        if (notify && null != this.resolutionListener) {
            this.resolutionListener.localVariableCreated(var);
            var.setValueChangeListener(this.listener);
        }
        cfg.addDecision(var);
        if (null != value) {
            try {
                var.setValue(value, AssignmentState.DEFAULT);
            }
            catch (ConfigurationException e) {
                this.exception(e);
            }
        }
        return var;
    }

    @Override
    public void visitIfThen(IfThen ifThen) {
        EvaluationAccessor resultBefore = this.result;
        boolean oldState = this.setAllowPropagation(null, false);
        ifThen.getIfExpr().accept(this);
        this.setAllowPropagation(null, oldState);
        if (null != this.result) {
            boolean isFulfilled = this.constraintFulfilled();
            this.clearResult();
            if (isFulfilled) {
                EvaluationAccessor.release(resultBefore);
                ifThen.getThenExpr().accept(this);
            } else if (null != ifThen.getElseExpr()) {
                EvaluationAccessor.release(resultBefore);
                ifThen.getElseExpr().accept(this);
            } else {
                this.result = resultBefore;
            }
        }
    }

    @Override
    public void visitContainerOperationCall(ContainerOperationCall call) {
        if (!this.assignmentsOnly) {
            ++this.opNesting;
            this.clearResult();
            Operation operation = call.getResolvedOperation();
            IIteratorEvaluator evaluator = this.getIteratorEvaluator(operation);
            if (null != evaluator) {
                DecisionVariableDeclaration resultDecl;
                boolean ok = true;
                LocalConfiguration cfg = new LocalConfiguration();
                this.context.pushLevel(cfg);
                int lastIteratorIndex = call.getDeclaratorsCount();
                if (Container.APPLY == operation || Container.ITERATE == operation) {
                    resultDecl = call.getDeclarator(--lastIteratorIndex);
                } else {
                    IDatatype exType;
                    IDatatype type;
                    try {
                        type = call.inferDatatype();
                        exType = call.getExpression().inferDatatype();
                    }
                    catch (CSTSemanticException e) {
                        type = AnyType.TYPE;
                        exType = AnyType.TYPE;
                        this.exception(e);
                        ok = false;
                    }
                    resultDecl = new DecisionVariableDeclaration("*r*", type, call.getParent());
                    try {
                        resultDecl.setValue(evaluator.getStartResult(type, exType));
                    }
                    catch (ValueDoesNotMatchTypeException e) {
                        this.exception(e);
                        ok = false;
                    }
                }
                LocalDecisionVariable lResultVar = this.addLocalVariable(cfg, resultDecl, null, true);
                VariableAccessor resultVar = VariableAccessor.POOL.getInstance().bind(lResultVar, this.context, true);
                LocalDecisionVariable[] declarators = new LocalDecisionVariable[lastIteratorIndex];
                int iterCount = 0;
                IDatatype contd = call.getIteratorBaseType();
                boolean isContained = true;
                for (int d = 0; ok && d < declarators.length; ++d) {
                    DecisionVariableDeclaration decl = call.getDeclarator(d);
                    boolean isIterator = isContained && (null == contd || contd.isAssignableFrom(decl.getType()));
                    declarators[d] = this.addLocalVariable(cfg, decl, isIterator ? null : decl.getDefaultValue(), true);
                    iterCount += isIterator ? 1 : 0;
                }
                if (ok) {
                    ok = this.executeContainerIteration(call, declarators, iterCount, resultVar, evaluator);
                }
                this.context.popLevel();
                this.result = ok ? ConstantAccessor.POOL.getInstance().bind(resultVar.getValue(), false, this.context) : null;
                resultVar.release();
                this.disposeLocalVariable(lResultVar);
                this.disposeLocalVariables(declarators);
            } else {
                this.result = null;
            }
            --this.opNesting;
            this.recordIfFailed(call);
        }
    }

    private boolean executeContainerIteration(ContainerOperationCall call, LocalDecisionVariable[] declarators, int iterCount, VariableAccessor resultVar, IIteratorEvaluator evaluator) {
        ContainerIterationExecutor exec = new ContainerIterationExecutor(call, declarators, resultVar, evaluator);
        return exec.execute(iterCount);
    }

    private boolean containerException(Throwable throwable) {
        this.exception(throwable);
        return false;
    }

    private boolean isFreezeVariable(ConstraintSyntaxTree cst) {
        boolean result = false;
        if (null != cst) {
            try {
                result = TypeQueries.isFreezeVariableType(cst.inferDatatype());
            }
            catch (CSTSemanticException cSTSemanticException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public void visitCompoundAccess(CompoundAccess access) {
        access.getCompoundExpression().accept(this);
        if (null != this.result) {
            IDecisionVariable resVar;
            String slotName = access.getSlotName();
            IDecisionVariable variable = this.result.getVariable();
            Value value = this.result.getValue();
            this.clearResult();
            if (value instanceof ReferenceValue) {
                ReferenceValue refVal = (ReferenceValue)value;
                AbstractVariable decl = refVal.getValue();
                if (null == decl) {
                    ConstraintSyntaxTree ex = refVal.getValueEx();
                    if (null != ex) {
                        ex.accept(this);
                    }
                    variable = null;
                } else {
                    IDecisionVariable res = this.context.getDecision(decl);
                    if (null == res) {
                        res = Configuration.findInParents(variable, decl.getName());
                    }
                    variable = res;
                }
            }
            if (variable instanceof CompoundVariable) {
                this.result = CompoundSlotAccessor.POOL.getInstance().bind(variable, slotName, (EvaluationContext)this.context);
            } else if (variable instanceof LocalDecisionVariable) {
                this.result = CompoundSlotAccessor.POOL.getInstance().bind((LocalDecisionVariable)variable, slotName, (EvaluationContext)this.context);
            } else if (value instanceof CompoundValue) {
                CompoundValue cValue = (CompoundValue)value;
                Value nValue = cValue.getNestedValue(slotName);
                if (null != nValue) {
                    this.result = ConstantAccessor.POOL.getInstance().bind(nValue, false, this.context);
                }
            } else if (value instanceof MetaTypeValue) {
                IDatatype type = ((MetaTypeValue)value).getValue();
                if ((value = this.context.bind(type)) instanceof CompoundValue && null != (value = ((CompoundValue)value).getNestedValue(slotName))) {
                    this.result = ConstantAccessor.POOL.getInstance().bind(value, false, this.context);
                }
            } else if (null == this.result && null == variable) {
                this.error("cannot evaluate compound/slot in " + StringProvider.toIvmlString(access), 102);
            }
            if (null != this.resolutionListener && null != this.result && null != (resVar = this.result.getVariable())) {
                this.resolutionListener.notifyResolved(variable, slotName, resVar);
            }
            this.recordIfFailed(access);
        }
    }

    @Override
    public void visitUnresolvedExpression(UnresolvedExpression expression) {
        this.clearResult();
    }

    @Override
    public void visitCompoundInitializer(CompoundInitializer initializer) {
        Compound type = initializer.getType();
        Object[] values = new Object[2 + 2 * initializer.getSlotCount()];
        int pos = 0;
        values[pos++] = ".";
        values[pos++] = type;
        boolean ok = true;
        this.contextStack.push();
        for (int s = 0; ok && s < initializer.getSlotCount(); ++s) {
            String slotName = initializer.getSlot(s);
            this.contextStack.setCompoundSlot(slotName);
            values[pos++] = slotName;
            DecisionVariableDeclaration decl = type.getElement(slotName);
            if (ConstraintType.isConstraint(decl.getType())) {
                try {
                    values[pos++] = ValueFactory.createValue(ConstraintType.TYPE, initializer.getExpression(s));
                }
                catch (ValueDoesNotMatchTypeException e) {
                    this.exception(e);
                }
                continue;
            }
            if (initializer.getExpression(s) instanceof DeferInitExpression) {
                values[pos++] = ((DeferInitExpression)initializer.getExpression(s)).getExpression();
                continue;
            }
            initializer.getExpression(s).accept(this);
            if (null == this.result) {
                this.error("cannot evaluate expression for compound slot '" + slotName + "' in type '" + type.getName() + "': " + StringProvider.toIvmlString(initializer.getExpression(s)), 102);
                ok = false;
            } else if (TypeQueries.isReference(decl.getType())) {
                values[pos++] = this.result.getReferenceValue();
            } else {
                Value val = this.result.getValue();
                if (null != val && this.modelCopy && !this.result.isConstant()) {
                    val = val.clone();
                }
                values[pos++] = val;
            }
            this.clearResult();
        }
        this.contextStack.pop();
        if (ok) {
            try {
                Value value = ValueFactory.createValue(initializer.getType(), values);
                this.result = ConstantAccessor.POOL.getInstance().bind(value, false, this.context);
            }
            catch (ValueDoesNotMatchTypeException e) {
                this.exception(e);
            }
        }
        this.recordIfFailed(initializer);
    }

    @Override
    public void visitContainerInitializer(ContainerInitializer initializer) {
        Object[] values = new Object[initializer.getExpressionCount()];
        boolean isConstraintCollection = Container.isContainer(initializer.getType(), ConstraintType.TYPE);
        boolean ok = true;
        boolean references = TypeQueries.isReference(initializer.getType().getContainedType());
        this.contextStack.push(initializer);
        for (int s = 0; ok && s < values.length; ++s) {
            Value val;
            this.contextStack.setContainerIndex(s);
            if (isConstraintCollection) {
                try {
                    values[s] = ValueFactory.createValue(ConstraintType.TYPE, initializer.getExpression(s));
                }
                catch (ValueDoesNotMatchTypeException e) {
                    this.exception(e);
                }
                continue;
            }
            initializer.getExpression(s).accept(this);
            if (null == this.result) {
                this.error("cannot evaluate container initializer expression '" + s + "'", 102);
                ok = false;
            } else if (references) {
                val = this.result.getValue();
                if (null == val) {
                    this.error("cannot evaluate container initializer expression, leads to null/no reference", 102);
                    ok = false;
                } else {
                    values[s] = TypeQueries.isReference(val.getType()) ? this.result.getValue() : this.result.getReferenceValue();
                }
            } else {
                val = this.result.getValue();
                if (null != val && this.modelCopy && !this.result.isConstant()) {
                    val = val.clone();
                }
                values[s] = val;
            }
            this.clearResult();
        }
        this.contextStack.pop();
        if (ok) {
            try {
                Value value = ValueFactory.createValue(initializer.getType(), values);
                this.result = ConstantAccessor.POOL.getInstance().bind(value, false, this.context);
            }
            catch (ValueDoesNotMatchTypeException e) {
                this.exception(e);
            }
        }
        this.recordIfFailed(initializer);
    }

    @Override
    public void visitSelf(Self self) {
        Value val = this.selfValue;
        if (null == val) {
            val = this.contextStack.getSelfValue();
        }
        this.result = null != val ? ConstantAccessor.POOL.getInstance().bind(val, false, this.context) : null;
    }

    protected IOperationEvaluator getOperationEvaluator(Operation operation) {
        return EvaluatorRegistry.getOperationEvaluator(operation);
    }

    protected IIteratorEvaluator getIteratorEvaluator(Operation operation) {
        return EvaluatorRegistry.getIteratorEvaluator(operation);
    }

    protected IAssignmentState getTargetState(IDecisionVariable var) {
        return this.assignmentState;
    }

    protected IAssignmentState getTargetState() {
        return this.assignmentState;
    }

    @Override
    public void visitAnnotationVariable(AttributeVariable variable) {
        this.visitVariable(variable);
    }

    @Override
    public void visitBlockExpression(BlockExpression block) {
        int n = block.getExpressionCount();
        for (int e = 0; e < n && (e <= 0 || null != this.result); ++e) {
            this.clearResult();
            block.getExpression(e).accept(this);
        }
    }

    @Override
    public void visitMultiAndExpression(MultiAndExpression expression) {
        Boolean res = Boolean.TRUE;
        for (int e = 0; Boolean.TRUE == res && e < expression.getExpressionCount(); ++e) {
            expression.getExpression(e).accept(this);
            if (null != this.result) {
                Value val = this.result.getValue();
                this.clearResult();
                if (val instanceof BooleanValue) {
                    res = ((BooleanValue)val).getValue();
                    continue;
                }
                res = null;
                continue;
            }
            res = null;
        }
        if (null != res) {
            this.result = ConstantAccessor.POOL.getInstance().bind(BooleanValue.toBooleanValue(res), true, this.context);
        }
    }

    private class ContainerIterationExecutor {
        private ContainerOperationCall call;
        private LocalDecisionVariable[] declarators;
        private VariableAccessor resultVar;
        private IIteratorEvaluator evaluator;
        private Map<Object, Object> data = new HashMap<Object, Object>();
        private int[] pos;
        private ContainerValue containerValue;
        private IDecisionVariable containerVariable;

        private ContainerIterationExecutor(ContainerOperationCall call, LocalDecisionVariable[] declarators, VariableAccessor resultVar, IIteratorEvaluator evaluator) {
            this.call = call;
            this.declarators = declarators;
            this.resultVar = resultVar;
            this.evaluator = evaluator;
        }

        private void determineContainer() {
            this.call.getContainer().accept(EvaluationVisitor.this);
            this.containerValue = null;
            if (null != EvaluationVisitor.this.result) {
                Value rValue = EvaluationVisitor.this.result.getValue();
                if (rValue instanceof ContainerValue) {
                    this.containerValue = (ContainerValue)rValue;
                    this.containerVariable = EvaluationVisitor.this.result.getVariable();
                    if (null != this.containerVariable && this.containerVariable.isLocal()) {
                        this.containerVariable = null;
                    }
                    if (null != this.containerVariable) {
                        this.resultVar.bindContainer(this.containerVariable);
                    } else {
                        this.resultVar.bindContainer(EvaluationVisitor.this.result);
                    }
                } else if (null != rValue) {
                    try {
                        IDatatype elementType;
                        IDatatype containerType = this.call.getContainerType();
                        this.containerValue = (ContainerValue)ValueFactory.createValue(containerType, null);
                        if (containerType.getGenericTypeCount() > 0 && Reference.TYPE.isAssignableFrom(elementType = containerType.getGenericType(0))) {
                            rValue = ValueFactory.createValue(elementType, EvaluationVisitor.this.result.getVariable().getDeclaration());
                        }
                        this.containerValue.addElement(rValue);
                    }
                    catch (ValueDoesNotMatchTypeException e) {
                        EvaluationVisitor.this.exception(e);
                    }
                    catch (CSTSemanticException e) {
                        EvaluationVisitor.this.exception(e);
                    }
                }
            }
        }

        private boolean initialize(ContainerValue[] containers, LocalDecisionVariable[] declarators) {
            boolean ok = true;
            for (int c = 0; c < containers.length; ++c) {
                Value val = declarators[c].getValue();
                if (val instanceof ContainerValue) {
                    containers[c] = (ContainerValue)val;
                    ok = containers[c] != null;
                    continue;
                }
                if (null == val || val == NullValue.INSTANCE) {
                    containers[c] = this.containerValue;
                    ok = containers[c] != null;
                    continue;
                }
                EvaluationVisitor.this.error("declarator " + declarators[c].getDeclaration().getName() + " does not provide a container value", 102);
                ok = false;
            }
            return ok;
        }

        private boolean execute(int iterCount) {
            boolean ok = true;
            this.determineContainer();
            if (null != this.containerValue) {
                EvaluationVisitor.this.clearResult();
                ContainerValue[] containers = new ContainerValue[iterCount];
                ok = this.initialize(containers, this.declarators);
                this.pos = new int[iterCount];
                block4: while (ok && containers.length > 0 && null != containers[0] && this.pos[0] < containers[0].getElementSize()) {
                    int iter = this.pos.length - 1;
                    ContainerValue iterator = containers[iter];
                    boolean setSelf = EvaluationVisitor.this.selfVars.contains(this.declarators[iter].getDeclaration());
                    int maxIter = iterator.getElementSize();
                    this.pos[iter] = 0;
                    while (ok && this.pos[iter] < maxIter) {
                        IDecisionVariable iVar = this.resultVar.getBoundContainerElement(this.pos[iter]);
                        Value iVal = iterator.getElement(this.pos[iter]);
                        ok = this.evaluateIterator(iter, iVal, iVar, maxIter, setSelf, this.resultVar);
                        int n = iter;
                        this.pos[n] = this.pos[n] + 1;
                    }
                    try {
                        this.evaluator.postProcessResult(this.resultVar, this.data);
                    }
                    catch (ValueDoesNotMatchTypeException ex) {
                        ok = EvaluationVisitor.this.containerException(ex);
                    }
                    EvaluationVisitor.this.selfValue = null;
                    this.data.clear();
                    --iter;
                    boolean propagate = true;
                    while (iter > 0 && propagate) {
                        int n = iter;
                        this.pos[n] = this.pos[n] + 1;
                        if (this.pos[iter] >= containers[iter].getElementSize()) {
                            this.pos[iter] = 0;
                        } else {
                            propagate = false;
                        }
                        try {
                            LocalDecisionVariable lVar = this.declarators[iter];
                            lVar.setVariable(this.resultVar.getBoundContainerElement(this.pos[iter]));
                            lVar.setValue(iterator.getElement(this.pos[iter]), AssignmentState.ASSIGNED);
                        }
                        catch (ConfigurationException e) {
                            ok = EvaluationVisitor.this.containerException(e);
                        }
                        if (!propagate) continue block4;
                        --iter;
                    }
                }
            } else {
                ok = false;
            }
            return ok;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean evaluateIterator(int iter, Value iterVal, IDecisionVariable iterVar, int maxIter, boolean setSelf, EvaluationAccessor rVar) {
            boolean ok = true;
            Operation.NestingMode nestingMode = this.call.getResolvedOperation().getNestingMode();
            if (Operation.NestingMode.NONE != nestingMode && iterVal instanceof ContainerValue) {
                if (Operation.NestingMode.LEGACY == nestingMode && this.declarators[iter].getDeclaration().getType().isAssignableFrom(iterVal.getType())) {
                    nestingMode = Operation.NestingMode.NONE;
                }
            } else {
                nestingMode = Operation.NestingMode.NONE;
            }
            if (Operation.NestingMode.NONE != nestingMode) {
                EvaluationAccessor res = rVar;
                if (Operation.NestingMode.NESTING == nestingMode) {
                    try {
                        Value val = ValueFactory.createValue(rVar.getValue().getContainedType(), null);
                        res = ConstantAccessor.POOL.getInstance().bind(val, false, rVar.getContext());
                        ((ContainerValue)rVar.getValue()).addElement(res.getValue());
                    }
                    catch (ValueDoesNotMatchTypeException ex) {
                        ok = EvaluationVisitor.this.containerException(ex);
                    }
                }
                ContainerValue cValue = (ContainerValue)iterVal;
                int e = 0;
                while (ok) {
                    if (e >= cValue.getElementSize()) return ok;
                    ok &= this.evaluateIterator(iter, cValue.getElement(e), null == iterVar ? null : iterVar.getNestedElement(e), maxIter, setSelf, res);
                    ++e;
                }
                return ok;
            }
            if (setSelf) {
                EvaluationVisitor.this.selfValue = iterVal;
            }
            try {
                this.declarators[iter].setVariable(iterVar);
                this.declarators[iter].setValue(iterVal, AssignmentState.ASSIGNED);
            }
            catch (ConfigurationException e) {
                ok = EvaluationVisitor.this.containerException(e);
            }
            this.call.getExpression().accept(EvaluationVisitor.this);
            if (null == EvaluationVisitor.this.result) return false;
            if (null == EvaluationVisitor.this.result.getValue()) return false;
            try {
                Value aggRes = this.evaluator.aggregate(rVar, iterVal, EvaluationVisitor.this.result, this.data);
                EvaluationVisitor.this.clearResult();
                if (BooleanValue.TRUE == aggRes) {
                    this.pos[iter] = maxIter;
                    return ok;
                }
                if (!(aggRes instanceof ListWrapperValue)) return ok;
                ListWrapperValue lwv = (ListWrapperValue)aggRes;
                int e = 0;
                while (e < lwv.getElementCount()) {
                    ok &= this.evaluateIterator(iter, lwv.getElement(e), null, maxIter, setSelf, rVar);
                    ++e;
                }
                return ok;
            }
            catch (ValueDoesNotMatchTypeException ex) {
                return EvaluationVisitor.this.containerException(ex);
            }
        }
    }

    public static class Message
    extends net.ssehub.easy.basics.messages.Message {
        public static final int CODE_UNSUPPORTED = 100;
        public static final int CODE_ASSIGNMENT_STATE = 101;
        public static final int CODE_RESOLUTION = 102;
        public static final int CODE_INDEX = 103;
        public static final int CODE_THROWABLE = 110;
        private IDecisionVariable var;
        private int code;

        public Message(String description, Status status, IDecisionVariable var, int code) {
            super(description, status);
            this.var = var;
            this.code = code;
        }

        public AbstractVariable getVariable() {
            return null != this.var ? this.var.getDeclaration() : null;
        }

        public IDecisionVariable getDecision() {
            return this.var;
        }

        public int getCode() {
            return this.code;
        }
    }

    private class EvaluationContextImpl
    extends EvaluationContext {
        private Stack<IConfiguration> configStack = new Stack();
        private boolean allowPropagation = true;

        EvaluationContextImpl(IConfiguration config) {
            this.pushLevel(config);
        }

        EvaluationContextImpl reset(IConfiguration config) {
            this.pushLevel(config);
            return this;
        }

        @Override
        void clear() {
            super.clear();
            this.configStack.clear();
            this.allowPropagation = true;
        }

        void pushLevel(IConfiguration config) {
            this.configStack.push(config);
        }

        void popLevel() {
            this.configStack.pop();
        }

        @Override
        public boolean allowAssignValues() {
            return EvaluationVisitor.this.assignmentState != null;
        }

        @Override
        public void notifyChangeListener(IDecisionVariable variable, Value value, IAssignmentState oldState, IValueChangeListener.ChangeKind kind) {
            if (null != EvaluationVisitor.this.listener && null != variable) {
                EvaluationVisitor.this.listener.notifyChanged(variable, value, oldState, kind);
            }
        }

        @Override
        public void addMessage(Message message) {
            if (null != message) {
                EvaluationVisitor.this.addMessage(message);
            }
        }

        @Override
        public IAssignmentState getTargetState(IDecisionVariable var) {
            return EvaluationVisitor.this.getTargetState(var);
        }

        @Override
        public IDecisionVariable getDecision(AbstractVariable variable) {
            IDecisionVariable result = (IDecisionVariable)EvaluationVisitor.this.varMapping.get(variable);
            for (int l = this.configStack.size() - 1; null == result && l >= 0; --l) {
                result = ((IConfiguration)this.configStack.get(l)).getDecision(variable);
            }
            if (null != EvaluationVisitor.this.resolutionListener && null != result) {
                EvaluationVisitor.this.resolutionListener.notifyResolved(variable, result);
            }
            return result;
        }

        @Override
        public Value getAllInstances(IDatatype type) {
            return ((IConfiguration)this.configStack.get(0)).getAllInstances(type);
        }

        Value bind(IDatatype type) {
            Value result = null;
            for (int l = this.configStack.size() - 1; null == result && l >= 0; --l) {
                IConfiguration cfg = (IConfiguration)this.configStack.get(l);
                if (!(cfg instanceof LocalConfiguration)) continue;
                LocalConfiguration localCfg = (LocalConfiguration)cfg;
                result = localCfg.bind(type, EvaluationVisitor.this.context);
            }
            return result;
        }

        @Override
        public void issueWarning() {
            EvaluationVisitor.this.issueWarning = true;
        }

        @Override
        public boolean allowPropagation() {
            return this.allowPropagation;
        }

        boolean setAllowPropagation(Operation op, boolean inPropagation) {
            boolean oldState = this.allowPropagation;
            if (op == BooleanType.IMPLIES || null == op) {
                this.allowPropagation = inPropagation;
            }
            return oldState;
        }

        @Override
        public IAssignmentState getAssignmentState() {
            return EvaluationVisitor.this.assignmentState;
        }
    }
}

