/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cstEvaluation.ConstantAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluatorRegistry;
import net.ssehub.easy.varModel.cstEvaluation.IOperationEvaluator;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.datatypes.FreezeVariableType;
import net.ssehub.easy.varModel.model.datatypes.StringType;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

public class FreezeVarOperations {
    public static final void register() {
        NameOperationEvaluator tmp = new NameOperationEvaluator(false);
        EvaluatorRegistry.registerEvaluator(tmp, FreezeVariableType.NAME);
        EvaluatorRegistry.registerEvaluator(tmp, FreezeVariableType.NAME2);
        tmp = new NameOperationEvaluator(true);
        EvaluatorRegistry.registerEvaluator(tmp, FreezeVariableType.QNAME);
        EvaluatorRegistry.registerEvaluator(tmp, FreezeVariableType.QNAME2);
    }

    private static class NameOperationEvaluator
    implements IOperationEvaluator {
        private boolean qualified;

        private NameOperationEvaluator(boolean qualified) {
            this.qualified = qualified;
        }

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            ConstantAccessor result = null;
            IDecisionVariable var = operand.getVariable();
            if (null != var) {
                AbstractVariable decl = var.getDeclaration();
                String name = this.qualified ? decl.getQualifiedName() : decl.getName();
                try {
                    Value value = ValueFactory.createValue(StringType.TYPE, name);
                    result = ConstantAccessor.POOL.getInstance().bind(value, true, operand.getContext());
                }
                catch (ValueDoesNotMatchTypeException valueDoesNotMatchTypeException) {
                    // empty catch block
                }
            }
            return result;
        }
    }
}

