/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.varModel.cstEvaluation.ConstantAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluatorRegistry;
import net.ssehub.easy.varModel.cstEvaluation.IOperationEvaluator;
import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.datatypes.RealType;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

class GenericNumberOperations {
    private static final INumberComparator LESS_COMPARATOR = new INumberComparator(){

        @Override
        public boolean compare(Number value1, Number value2) {
            return value1.doubleValue() < value2.doubleValue();
        }
    };
    private static final INumberComparator LESS_EQUALS_COMPARATOR = new INumberComparator(){

        @Override
        public boolean compare(Number value1, Number value2) {
            return value1.doubleValue() <= value2.doubleValue();
        }
    };
    private static final INumberComparator GREATER_COMPARATOR = new INumberComparator(){

        @Override
        public boolean compare(Number value1, Number value2) {
            return value1.doubleValue() > value2.doubleValue();
        }
    };
    private static final INumberComparator GREATER_EQUALS_COMPARATOR = new INumberComparator(){

        @Override
        public boolean compare(Number value1, Number value2) {
            return value1.doubleValue() >= value2.doubleValue();
        }
    };
    private static final IOperationEvaluator GREATER = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return GenericNumberOperations.comparisionOperation(operand, arguments, GREATER_COMPARATOR);
        }
    };
    private static final IOperationEvaluator GREATER_EQUALS = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return GenericNumberOperations.comparisionOperation(operand, arguments, GREATER_EQUALS_COMPARATOR);
        }
    };
    private static final IOperationEvaluator LESS = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return GenericNumberOperations.comparisionOperation(operand, arguments, LESS_COMPARATOR);
        }
    };
    private static final IOperationEvaluator LESS_EQUALS = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return GenericNumberOperations.comparisionOperation(operand, arguments, LESS_EQUALS_COMPARATOR);
        }
    };
    private static final IOperationEvaluator INVERSE = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return GenericNumberOperations.inverse(operand, arguments);
        }
    };
    private static final IOperationEvaluator ABSOLUTE = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return GenericNumberOperations.absolute(operand, arguments);
        }
    };

    GenericNumberOperations() {
    }

    public static final void register() {
        EvaluatorRegistry.registerEvaluator(GREATER_EQUALS, IntegerType.GREATER_EQUALS_INTEGER_INTEGER, IntegerType.GREATER_EQUALS_INTEGER_REAL, RealType.GREATER_EQUALS_REAL_INTEGER, RealType.GREATER_EQUALS_REAL_REAL);
        EvaluatorRegistry.registerEvaluator(GREATER, IntegerType.GREATER_INTEGER_INTEGER, IntegerType.GREATER_INTEGER_REAL, RealType.GREATER_REAL_INTEGER, RealType.GREATER_REAL_REAL);
        EvaluatorRegistry.registerEvaluator(LESS_EQUALS, IntegerType.LESS_EQUALS_INTEGER_INTEGER, IntegerType.LESS_EQUALS_INTEGER_REAL, RealType.LESS_EQUALS_REAL_INTEGER, RealType.LESS_EQUALS_REAL_REAL);
        EvaluatorRegistry.registerEvaluator(LESS, IntegerType.LESS_INTEGER_INTEGER, IntegerType.LESS_INTEGER_REAL, RealType.LESS_REAL_INTEGER, RealType.LESS_REAL_REAL);
        EvaluatorRegistry.registerEvaluator(INVERSE, IntegerType.INVERSE_INTEGER, RealType.INVERSE_REAL);
        EvaluatorRegistry.registerEvaluator(ABSOLUTE, IntegerType.ABS_INTEGER_INTEGER, RealType.ABS_REAL_REAL);
    }

    private static EvaluationAccessor comparisionOperation(EvaluationAccessor operand, EvaluationAccessor[] arguments, INumberComparator strategy) {
        ConstantAccessor result = null;
        if (null != operand && operand.getValue() != null && arguments.length == 1 && null != arguments[0].getValue()) {
            Object oValue = operand.getValue().getValue();
            Object aValue = arguments[0].getValue().getValue();
            if (oValue instanceof Number && aValue instanceof Number && null != strategy) {
                boolean booleanResult = strategy.compare((Number)oValue, (Number)aValue);
                result = ConstantAccessor.POOL.getInstance().bind(BooleanValue.toBooleanValue(booleanResult), true, operand.getContext());
            }
        }
        return result;
    }

    private static EvaluationAccessor inverse(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
        ConstantAccessor result = null;
        if (null == arguments || arguments.length == 0) {
            Value value = operand.getValue();
            Object oValue = value.getValue();
            Value newValue = null;
            try {
                if (oValue instanceof Integer) {
                    newValue = ValueFactory.createValue(value.getType(), (Integer)oValue * -1);
                } else if (oValue instanceof Double) {
                    newValue = ValueFactory.createValue(value.getType(), (Double)oValue * -1.0);
                }
            }
            catch (ValueDoesNotMatchTypeException e) {
                EASyLoggerFactory.INSTANCE.getLogger(GenericNumberOperations.class, "net.ssehub.easy.varModel").exception(e);
            }
            if (null != newValue) {
                result = ConstantAccessor.POOL.getInstance().bind(newValue, true, operand.getContext());
            }
        }
        return result;
    }

    private static EvaluationAccessor absolute(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
        ConstantAccessor result = null;
        if (null == arguments || arguments.length == 0) {
            Value value = operand.getValue();
            Object oValue = value.getValue();
            Value newValue = null;
            try {
                if (oValue instanceof Integer) {
                    newValue = ValueFactory.createValue(value.getType(), Math.abs((Integer)oValue));
                } else if (oValue instanceof Double) {
                    newValue = ValueFactory.createValue(value.getType(), Math.abs((Double)oValue * -1.0));
                }
            }
            catch (ValueDoesNotMatchTypeException e) {
                EASyLoggerFactory.INSTANCE.getLogger(GenericNumberOperations.class, "net.ssehub.easy.varModel").exception(e);
            }
            if (null != newValue) {
                result = ConstantAccessor.POOL.getInstance().bind(newValue, true, operand.getContext());
            }
        }
        return result;
    }

    private static interface INumberComparator {
        public boolean compare(Number var1, Number var2);
    }
}

