/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.pool.IPoolManager;
import net.ssehub.easy.basics.pool.Pool;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cstEvaluation.AbstractDecisionVariableEvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.CollectionElementVariable;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationContext;
import net.ssehub.easy.varModel.cstEvaluation.IValueChangeListener;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

class IndexAccessor
extends AbstractDecisionVariableEvaluationAccessor {
    public static final Pool<IndexAccessor> POOL = new Pool<IndexAccessor>(new IPoolManager<IndexAccessor>(){

        @Override
        public IndexAccessor create() {
            return new IndexAccessor();
        }

        @Override
        public void clear(IndexAccessor instance) {
            instance.clear();
        }
    });
    private int index;

    private IndexAccessor() {
    }

    protected IndexAccessor bind(IDecisionVariable variable, EvaluationContext context, int index) {
        super.bind(variable, context);
        this.index = index;
        return this;
    }

    @Override
    public Value getValue() {
        ContainerValue value;
        Value result = null;
        IDecisionVariable variable = this.getVariable();
        IDatatype type = DerivedDatatype.resolveToBasis(variable.getDeclaration().getType());
        if (Container.TYPE.isAssignableFrom(type) && null != (value = (ContainerValue)variable.getValue())) {
            result = ((ContainerValue)variable.getValue()).getElement(this.index);
        }
        return result;
    }

    @Override
    public boolean setValue(Value value, boolean asAssignment) {
        ContainerValue val;
        boolean done = false;
        IDecisionVariable variable = this.getVariable();
        if (Container.TYPE.isAssignableFrom(variable.getDeclaration().getType()) && null != (val = (ContainerValue)variable.getValue())) {
            Value oldValue = val.getElement(this.index);
            if (!Value.equals(oldValue, value)) {
                IAssignmentState oldState = variable.getState();
                try {
                    val.setValue(this.index, value);
                    this.getContext().notifyChangeListener(variable.getNestedElement(this.index), oldValue, oldState, IValueChangeListener.ChangeKind.FULL);
                    done = true;
                }
                catch (ValueDoesNotMatchTypeException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(IndexAccessor.class, "net.ssehub.easy.varModel").exception(e);
                }
            }
            variable.notifyWasAssigned(val);
        }
        return done;
    }

    @Override
    public boolean isAssignable() {
        return true;
    }

    @Override
    public void release() {
        POOL.releaseInstance(this);
    }

    @Override
    public Value getReferenceValue() {
        Value result;
        try {
            IDecisionVariable variable = this.getVariable();
            AbstractVariable decl = variable.getDeclaration();
            IDatatype declType = DerivedDatatype.resolveToBasis(decl.getType());
            IDatatype contained = Container.TYPE.isAssignableFrom(declType) ? ((Container)declType).getContainedType() : declType;
            result = Reference.TYPE.isAssignableFrom(contained) ? ((ContainerValue)variable.getValue()).getElement(this.index) : ValueFactory.createValue(new Reference("", contained, null), new CollectionElementVariable(decl, contained, variable.getResolutionPath(), this.index));
        }
        catch (ValueDoesNotMatchTypeException e) {
            result = null;
        }
        return result;
    }
}

