/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.varModel.cstEvaluation.ArithmeticOperationType;
import net.ssehub.easy.varModel.cstEvaluation.ConstantAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluatorRegistry;
import net.ssehub.easy.varModel.cstEvaluation.GenericNumberOperations;
import net.ssehub.easy.varModel.cstEvaluation.GenericOperations;
import net.ssehub.easy.varModel.cstEvaluation.IOperationEvaluator;
import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.IntValue;
import net.ssehub.easy.varModel.model.values.RealValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

public class IntegerOperations {
    static final IOperationEvaluator EQUALS_INT_REAL = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return IntegerOperations.equalsIntReal(operand, arguments, false);
        }
    };
    static final IOperationEvaluator UNEQUALS_INT_REAL = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return IntegerOperations.equalsIntReal(operand, arguments, true);
        }
    };
    static final IOperationEvaluator PLUS_INT_INT = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return IntegerOperations.arithmeticOperationIntInt(operand, arguments, ArithmeticOperationType.PLUS);
        }
    };
    static final IOperationEvaluator MINUS_INT_INT = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return IntegerOperations.arithmeticOperationIntInt(operand, arguments, ArithmeticOperationType.MINUS);
        }
    };
    static final IOperationEvaluator MULTIPLICATION_INT_INT = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return IntegerOperations.arithmeticOperationIntInt(operand, arguments, ArithmeticOperationType.MULTIPLICATION);
        }
    };
    static final IOperationEvaluator DIVISION_INT_INT = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return IntegerOperations.arithmeticOperationIntInt(operand, arguments, ArithmeticOperationType.DIVISION);
        }
    };
    static final IOperationEvaluator MODULO_INT_INT = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return IntegerOperations.arithmeticOperationIntInt(operand, arguments, ArithmeticOperationType.MODULO);
        }
    };
    static final IOperationEvaluator MIN_INT_INT = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return IntegerOperations.minmaxOperationIntInt(operand, arguments, true);
        }
    };
    static final IOperationEvaluator MAX_INT_INT = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return IntegerOperations.minmaxOperationIntInt(operand, arguments, false);
        }
    };

    private IntegerOperations() {
    }

    public static final void register() {
        EvaluatorRegistry.registerEvaluator(GenericOperations.TYPE_OF, IntegerType.TYPE_OF);
        EvaluatorRegistry.registerEvaluator(GenericOperations.EQUALS, IntegerType.EQUALS_INTEGER_INTEGER);
        EvaluatorRegistry.registerEvaluator(GenericOperations.TO_STRING, IntegerType.TO_STRING);
        EvaluatorRegistry.registerEvaluator(EQUALS_INT_REAL, IntegerType.EQUALS_INTEGER_REAL);
        EvaluatorRegistry.registerEvaluator(GenericOperations.ASSIGNMENT, IntegerType.ASSIGNMENT_INTEGER_INTEGER);
        EvaluatorRegistry.registerEvaluator(GenericOperations.IS_DEFINED, IntegerType.IS_DEFINED);
        EvaluatorRegistry.registerEvaluator(GenericOperations.COPY, IntegerType.COPY);
        EvaluatorRegistry.registerEvaluator(GenericOperations.UNEQUALS, IntegerType.NOTEQUALS_INTEGER_INTEGER);
        EvaluatorRegistry.registerEvaluator(UNEQUALS_INT_REAL, IntegerType.NOTEQUALS_INTEGER_REAL);
        EvaluatorRegistry.registerEvaluator(GenericOperations.UNEQUALS, IntegerType.NOTEQUALS_INTEGER_INTEGER_ALIAS, IntegerType.NOTEQUALS_INTEGER_REAL_ALIAS);
        EvaluatorRegistry.registerEvaluator(PLUS_INT_INT, IntegerType.PLUS_INTEGER_INTEGER);
        EvaluatorRegistry.registerEvaluator(MINUS_INT_INT, IntegerType.MINUS_INTEGER_INTEGER);
        EvaluatorRegistry.registerEvaluator(MULTIPLICATION_INT_INT, IntegerType.MULT_INTEGER_INTEGER);
        EvaluatorRegistry.registerEvaluator(DIVISION_INT_INT, IntegerType.DIV_INTEGER_INTEGER);
        EvaluatorRegistry.registerEvaluator(MODULO_INT_INT, IntegerType.MOD_INTEGER_INTEGER);
        EvaluatorRegistry.registerEvaluator(MIN_INT_INT, IntegerType.MIN_INTEGER_INTEGER);
        EvaluatorRegistry.registerEvaluator(MAX_INT_INT, IntegerType.MAX_INTEGER_INTEGER);
    }

    static EvaluationAccessor equalsIntReal(EvaluationAccessor operand, EvaluationAccessor[] arguments, boolean negate) {
        ConstantAccessor result = null;
        if (arguments.length == 1) {
            Value oValue = operand.getValue();
            Value aValue = arguments[0].getValue();
            if (aValue instanceof RealValue && oValue instanceof IntValue) {
                double arg;
                boolean equals;
                int op = ((IntValue)oValue).getValue();
                boolean bl = equals = op == (int)(arg = ((RealValue)aValue).getValue().doubleValue());
                if (negate) {
                    equals = !equals;
                }
                result = ConstantAccessor.POOL.getInstance().bind(BooleanValue.toBooleanValue(equals), true, operand.getContext());
            }
        }
        return result;
    }

    private static EvaluationAccessor arithmeticOperationIntInt(EvaluationAccessor operand, EvaluationAccessor[] arguments, ArithmeticOperationType type) {
        ConstantAccessor result = null;
        if (arguments.length == 1) {
            Value oValue = operand.getValue();
            Value aValue = arguments[0].getValue();
            if (oValue instanceof IntValue && aValue instanceof IntValue && null != type) {
                int op = ((IntValue)oValue).getValue();
                int arg = ((IntValue)aValue).getValue();
                int resultOfOperation = 0;
                boolean operationPerformed = true;
                try {
                    switch (type) {
                        case PLUS: {
                            resultOfOperation = op + arg;
                            break;
                        }
                        case MINUS: {
                            resultOfOperation = op - arg;
                            break;
                        }
                        case MULTIPLICATION: {
                            resultOfOperation = op * arg;
                            break;
                        }
                        case DIVISION: {
                            resultOfOperation = op / arg;
                            break;
                        }
                        case MODULO: {
                            resultOfOperation = op % arg;
                            break;
                        }
                        default: {
                            operationPerformed = false;
                            break;
                        }
                    }
                }
                catch (ArithmeticException e) {
                    operationPerformed = false;
                }
                if (operationPerformed) {
                    try {
                        Value rValue = ValueFactory.createValue(IntegerType.TYPE, resultOfOperation);
                        result = ConstantAccessor.POOL.getInstance().bind(rValue, true, operand.getContext());
                    }
                    catch (ValueDoesNotMatchTypeException e) {
                        EASyLoggerFactory.INSTANCE.getLogger(GenericNumberOperations.class, "net.ssehub.easy.varModel").exception(e);
                    }
                }
            }
        }
        return result;
    }

    private static EvaluationAccessor minmaxOperationIntInt(EvaluationAccessor operand, EvaluationAccessor[] arguments, boolean min) {
        ConstantAccessor result = null;
        if (arguments.length == 1) {
            Value oValue = operand.getValue();
            Value aValue = arguments[0].getValue();
            if (oValue instanceof IntValue && aValue instanceof IntValue) {
                int op = ((IntValue)oValue).getValue();
                int arg = ((IntValue)aValue).getValue();
                Value rValue = min ? (op <= arg ? oValue : aValue) : (op >= arg ? oValue : aValue);
                result = ConstantAccessor.POOL.getInstance().bind(rValue, false, operand.getContext());
            }
        }
        return result;
    }
}

