/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.varModel.cstEvaluation.ArithmeticOperationType;
import net.ssehub.easy.varModel.cstEvaluation.ConstantAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluatorRegistry;
import net.ssehub.easy.varModel.cstEvaluation.GenericNumberOperations;
import net.ssehub.easy.varModel.cstEvaluation.GenericOperations;
import net.ssehub.easy.varModel.cstEvaluation.IOperationEvaluator;
import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.datatypes.RealType;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.IntValue;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.RealValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

public class RealOperations {
    static final IOperationEvaluator EQUALS_REAL_INT = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return RealOperations.equalsRealInt(operand, arguments, false);
        }
    };
    static final IOperationEvaluator UNEQUALS_REAL_INT = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return RealOperations.equalsRealInt(operand, arguments, true);
        }
    };
    static final IOperationEvaluator TO_INT = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            EvaluationAccessor result = null;
            Value value = operand.getValue();
            if (value instanceof RealValue) {
                double rValue = ((RealValue)value).getValue();
                try {
                    Value iValue = ValueFactory.createValue(IntegerType.TYPE, (int)rValue);
                    ConstantAccessor.POOL.getInstance().bind(iValue, true, operand.getContext());
                }
                catch (ValueDoesNotMatchTypeException e) {
                    operand.getContext().addErrorMessage("toInt: " + e.getMessage(), 102);
                }
            }
            return result;
        }
    };
    static final IOperationEvaluator PLUS_REAL = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return RealOperations.arithmeticOperationReal(operand, arguments, ArithmeticOperationType.PLUS);
        }
    };
    static final IOperationEvaluator MINUS_REAL = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return RealOperations.arithmeticOperationReal(operand, arguments, ArithmeticOperationType.MINUS);
        }
    };
    static final IOperationEvaluator MULTIPLICATION_REAL = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return RealOperations.arithmeticOperationReal(operand, arguments, ArithmeticOperationType.MULTIPLICATION);
        }
    };
    static final IOperationEvaluator DIVISION_REAL = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return RealOperations.arithmeticOperationReal(operand, arguments, ArithmeticOperationType.DIVISION);
        }
    };
    static final IOperationEvaluator MODULO_REAL = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return RealOperations.arithmeticOperationReal(operand, arguments, ArithmeticOperationType.MODULO);
        }
    };
    static final IOperationEvaluator FLOOR = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return RealOperations.round(operand, arguments, false);
        }
    };
    static final IOperationEvaluator ROUND = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return RealOperations.round(operand, arguments, true);
        }
    };
    static final IOperationEvaluator MIN_REAL = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return RealOperations.minmaxOperationReal(operand, arguments, true);
        }
    };
    static final IOperationEvaluator MAX_REAL = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return RealOperations.minmaxOperationReal(operand, arguments, false);
        }
    };

    private RealOperations() {
    }

    public static final void register() {
        EvaluatorRegistry.registerEvaluator(GenericOperations.TYPE_OF, RealType.TYPE_OF);
        EvaluatorRegistry.registerEvaluator(GenericOperations.EQUALS, RealType.EQUALS_REAL_REAL);
        EvaluatorRegistry.registerEvaluator(EQUALS_REAL_INT, RealType.EQUALS_REAL_INTEGER);
        EvaluatorRegistry.registerEvaluator(GenericOperations.ASSIGNMENT, RealType.ASSIGNMENT_REAL_INTEGER, RealType.ASSIGNMENT_REAL_REAL);
        EvaluatorRegistry.registerEvaluator(GenericOperations.IS_DEFINED, RealType.IS_DEFINED);
        EvaluatorRegistry.registerEvaluator(GenericOperations.COPY, RealType.COPY);
        EvaluatorRegistry.registerEvaluator(GenericOperations.UNEQUALS, RealType.NOTEQUALS_REAL_REAL, RealType.NOTEQUALS_REAL_REAL_ALIAS);
        EvaluatorRegistry.registerEvaluator(UNEQUALS_REAL_INT, RealType.NOTEQUALS_REAL_INTEGER, RealType.NOTEQUALS_REAL_INTEGER_ALIAS);
        EvaluatorRegistry.registerEvaluator(GenericOperations.TO_STRING, RealType.TO_STRING);
        EvaluatorRegistry.registerEvaluator(PLUS_REAL, RealType.PLUS_REAL_REAL, RealType.PLUS_REAL_INTEGER, IntegerType.PLUS_INTEGER_REAL);
        EvaluatorRegistry.registerEvaluator(MINUS_REAL, RealType.MINUS_REAL_REAL, RealType.MINUS_REAL_INTEGER, IntegerType.MINUS_INTEGER_REAL);
        EvaluatorRegistry.registerEvaluator(MULTIPLICATION_REAL, RealType.MULT_REAL_REAL, RealType.MULT_REAL_INTEGER, IntegerType.MULT_INTEGER_REAL);
        EvaluatorRegistry.registerEvaluator(DIVISION_REAL, RealType.DIV_REAL_REAL, RealType.DIV_REAL_INTEGER, IntegerType.DIV_INTEGER_REAL, IntegerType.DIVREAL_INTEGER_INTEGER);
        EvaluatorRegistry.registerEvaluator(MODULO_REAL, RealType.MOD_REAL_REAL, RealType.MOD_REAL_INTEGER, IntegerType.MOD_INTEGER_REAL);
        EvaluatorRegistry.registerEvaluator(FLOOR, RealType.FLOOR);
        EvaluatorRegistry.registerEvaluator(ROUND, RealType.ROUND);
        EvaluatorRegistry.registerEvaluator(MIN_REAL, RealType.MIN_REAL_REAL, RealType.MIN_REAL_INTEGER, IntegerType.MIN_INTEGER_REAL);
        EvaluatorRegistry.registerEvaluator(MAX_REAL, RealType.MAX_REAL_REAL, RealType.MAX_REAL_INTEGER, IntegerType.MAX_INTEGER_REAL);
    }

    static EvaluationAccessor equalsRealInt(EvaluationAccessor operand, EvaluationAccessor[] arguments, boolean negate) {
        ConstantAccessor result = null;
        if (arguments.length == 1) {
            Value oValue = operand.getValue();
            Value aValue = arguments[0].getValue();
            if (aValue instanceof IntValue) {
                if (oValue instanceof RealValue) {
                    int arg;
                    boolean equals;
                    double op = ((RealValue)oValue).getValue();
                    boolean bl = equals = (int)op == (arg = ((IntValue)aValue).getValue().intValue());
                    if (negate) {
                        equals = !equals;
                    }
                    result = ConstantAccessor.POOL.getInstance().bind(BooleanValue.toBooleanValue(equals), true, operand.getContext());
                } else if (oValue == NullValue.INSTANCE) {
                    result = ConstantAccessor.POOL.getInstance().bind(BooleanValue.toBooleanValue(negate), true, operand.getContext());
                }
            }
        }
        return result;
    }

    private static EvaluationAccessor arithmeticOperationReal(EvaluationAccessor operand, EvaluationAccessor[] arguments, ArithmeticOperationType type) {
        ConstantAccessor result = null;
        if (null != operand.getValue() && arguments.length == 1 && null != arguments[0].getValue()) {
            Object oValue = operand.getValue().getValue();
            Object aValue = arguments[0].getValue().getValue();
            if (oValue instanceof Number && aValue instanceof Number && null != type) {
                double op = ((Number)oValue).doubleValue();
                double arg = ((Number)aValue).doubleValue();
                double resultOfOperation = 0.0;
                boolean operationPerformed = true;
                try {
                    switch (type) {
                        case PLUS: {
                            resultOfOperation = op + arg;
                            break;
                        }
                        case MINUS: {
                            resultOfOperation = op - arg;
                            break;
                        }
                        case MULTIPLICATION: {
                            resultOfOperation = op * arg;
                            break;
                        }
                        case DIVISION: {
                            resultOfOperation = op / arg;
                            if (Double.isInfinite(resultOfOperation) || Double.isNaN(resultOfOperation)) {
                                operationPerformed = false;
                            }
                            break;
                        }
                        case MODULO: {
                            resultOfOperation = op % arg;
                            break;
                        }
                        default: {
                            operationPerformed = false;
                            break;
                        }
                    }
                }
                catch (ArithmeticException e) {
                    operationPerformed = false;
                }
                if (operationPerformed) {
                    try {
                        Value rValue = ValueFactory.createValue(RealType.TYPE, resultOfOperation);
                        result = ConstantAccessor.POOL.getInstance().bind(rValue, true, operand.getContext());
                    }
                    catch (ValueDoesNotMatchTypeException e) {
                        EASyLoggerFactory.INSTANCE.getLogger(GenericNumberOperations.class, "net.ssehub.easy.varModel").exception(e);
                    }
                }
            }
        }
        return result;
    }

    private static EvaluationAccessor round(EvaluationAccessor operand, EvaluationAccessor[] arguments, boolean roundUp) {
        Value value;
        ConstantAccessor result = null;
        if ((null == arguments || arguments.length == 0) && (value = operand.getValue()) instanceof RealValue) {
            double op = (Double)value.getValue();
            int resultOfOperation = Integer.MAX_VALUE;
            if (op >= -2.147483648E9 && op <= 2.147483647E9) {
                resultOfOperation = (int)(roundUp ? (double)Math.round(op) : Math.floor(op));
            } else if (op < -2.147483648E9) {
                resultOfOperation = Integer.MIN_VALUE;
            }
            try {
                Value rValue = ValueFactory.createValue(IntegerType.TYPE, resultOfOperation);
                result = ConstantAccessor.POOL.getInstance().bind(rValue, true, operand.getContext());
            }
            catch (ValueDoesNotMatchTypeException e) {
                EASyLoggerFactory.INSTANCE.getLogger(GenericNumberOperations.class, "net.ssehub.easy.varModel").exception(e);
            }
        }
        return result;
    }

    private static EvaluationAccessor minmaxOperationReal(EvaluationAccessor operand, EvaluationAccessor[] arguments, boolean min) {
        ConstantAccessor result = null;
        if (arguments.length == 1) {
            Object oValue = operand.getValue().getValue();
            Object aValue = arguments[0].getValue().getValue();
            if (oValue instanceof Number && aValue instanceof Number) {
                Number op = (Number)oValue;
                Number arg = (Number)aValue;
                Number rNumber = min ? (Number)(op.doubleValue() <= arg.doubleValue() ? (Number)op : (Number)arg) : (Number)(op.doubleValue() >= arg.doubleValue() ? (Number)op : (Number)arg);
                try {
                    Value rValue = ValueFactory.createValue(RealType.TYPE, rNumber);
                    result = ConstantAccessor.POOL.getInstance().bind(rValue, true, operand.getContext());
                }
                catch (ValueDoesNotMatchTypeException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(GenericNumberOperations.class, "net.ssehub.easy.varModel").exception(e);
                }
            }
        }
        return result;
    }
}

