/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.pool.IPoolManager;
import net.ssehub.easy.basics.pool.Pool;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cstEvaluation.AbstractDecisionVariableEvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationContext;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationVisitor;
import net.ssehub.easy.varModel.cstEvaluation.IValueChangeListener;
import net.ssehub.easy.varModel.cstEvaluation.IndexAccessor;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.OclKeyWords;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.IntValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;

class VariableAccessor
extends AbstractDecisionVariableEvaluationAccessor {
    public static final Pool<VariableAccessor> POOL = new Pool<VariableAccessor>(new IPoolManager<VariableAccessor>(){

        @Override
        public VariableAccessor create() {
            return new VariableAccessor();
        }

        @Override
        public void clear(VariableAccessor instance) {
            instance.clear();
        }
    });

    private VariableAccessor() {
    }

    public VariableAccessor bind(AbstractVariable variable, EvaluationContext context) {
        super.bind(context.getDecision(variable), context);
        return this;
    }

    @Override
    public VariableAccessor bind(IDecisionVariable variable, EvaluationContext context) {
        super.bind(variable, context);
        return this;
    }

    public VariableAccessor bind(IDecisionVariable variable, EvaluationContext context, boolean isLocal) {
        super.bind(variable, context);
        return this;
    }

    @Override
    public Value getValue() {
        IDecisionVariable var = this.getVariable();
        Value result = null != var ? var.getValue() : null;
        return result;
    }

    @Override
    public boolean setValue(Value value, boolean asAssignment) {
        boolean successful = false;
        EvaluationContext context = this.getContext();
        if (context.allowAssignValues()) {
            successful = this.setValue(context, value, asAssignment);
        }
        return successful;
    }

    private boolean setValue(EvaluationContext context, Value value, boolean asAssignment) {
        boolean successful = false;
        if (value != null) {
            IDecisionVariable variable = this.getVariable();
            if (null == variable) {
                context.addErrorMessage("variable does not exist (attribute access failure)?", 102);
            } else {
                Value oldValue = variable.getValue();
                IAssignmentState oldState = variable.getState();
                if (!Value.equalsPartially(oldValue, value) && oldState != AssignmentState.USER_ASSIGNED) {
                    AssignmentState targetState;
                    IAssignmentState iAssignmentState = targetState = this.isLocal() ? AssignmentState.ASSIGNED : context.getTargetState(variable);
                    if (null != targetState) {
                        try {
                            this.dereferenceIfNeeded(variable, value).setValue(value, (IAssignmentState)targetState, asAssignment);
                            successful = true;
                            this.notifyVariableChange(oldValue, oldState, IValueChangeListener.ChangeKind.FULL);
                        }
                        catch (ConfigurationException e) {
                            context.addErrorMessage(e);
                        }
                    } else {
                        context.addMessage(new EvaluationVisitor.Message("Assignment state conflict", Status.ERROR, variable, 101));
                    }
                } else {
                    successful = true;
                    variable.notifyCreated();
                }
                boolean was = variable.notifyWasAssigned(value);
                if (!was && variable.enableWasAssignedForIsDefined()) {
                    this.notifyVariableChange(oldValue, oldState, IValueChangeListener.ChangeKind.VARIABLE_ONLY);
                }
            }
        }
        return successful;
    }

    @Override
    public boolean isAssignable() {
        return true;
    }

    @Override
    public EvaluationAccessor getValue(EvaluationAccessor accessor) {
        Value uncastedValue;
        IndexAccessor result = null;
        IDecisionVariable variable = this.getVariable();
        if (Container.TYPE.isAssignableFrom(DerivedDatatype.resolveToBasis(variable.getDeclaration().getType())) && null != (uncastedValue = variable.getValue())) {
            if (uncastedValue instanceof ContainerValue) {
                ContainerValue value = (ContainerValue)uncastedValue;
                Integer index = this.getIndex(value, accessor);
                if (null != index) {
                    result = IndexAccessor.POOL.getInstance().bind(variable, this.getContext(), index);
                }
            } else {
                this.getContext().addErrorMessage("index based access an null value", variable, 102);
            }
        }
        return result;
    }

    private Integer getIndex(ContainerValue value, EvaluationAccessor accessor) {
        Integer result = null;
        EvaluationContext context = accessor.getContext();
        Value iValue = accessor.getValue();
        if (iValue instanceof IntValue) {
            int index = OclKeyWords.toJavaIndex(((IntValue)iValue).getValue());
            if (index < 0) {
                context.addErrorMessage("index < 0", 103);
            } else if (index >= value.getElementSize()) {
                context.addErrorMessage("index >= " + value.getElementSize(), 103);
            } else {
                result = index;
            }
        } else if (null != iValue) {
            context.addErrorMessage("index access must happen trough an integer", 102);
        }
        return result;
    }

    @Override
    public void setValue(EvaluationAccessor accessor, Value value) {
        Integer index;
        ContainerValue container;
        IDecisionVariable variable = this.getVariable();
        if (Container.TYPE.isAssignableFrom(variable.getDeclaration().getType()) && null != (container = (ContainerValue)variable.getValue()) && null != (index = this.getIndex(container, accessor))) {
            EvaluationContext context = accessor.getContext();
            try {
                ((ContainerValue)variable.getValue()).setValue(index, value);
            }
            catch (IllegalArgumentException e) {
                context.addErrorMessage(e);
            }
            catch (IndexOutOfBoundsException e) {
                context.addErrorMessage(e);
            }
            catch (ValueDoesNotMatchTypeException e) {
                context.addErrorMessage(e);
            }
        }
    }

    @Override
    public void release() {
        POOL.releaseInstance(this);
    }
}

