/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.varModel.cstEvaluation.ConstantAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluatorRegistry;
import net.ssehub.easy.varModel.cstEvaluation.IOperationEvaluator;
import net.ssehub.easy.varModel.model.datatypes.VersionType;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.VersionValue;

public class VersionOperations {
    private VersionOperations() {
    }

    public static final void register() {
        EvaluatorRegistry.registerEvaluator(new VersionEvaluator(new IVersionResultConverter(){

            @Override
            public boolean convert(int value) {
                return 0 == value;
            }
        }), VersionType.EQUALS);
        EvaluatorRegistry.registerEvaluator(new VersionEvaluator(new IVersionResultConverter(){

            @Override
            public boolean convert(int value) {
                return 0 != value;
            }
        }), VersionType.UNEQUALS, VersionType.UNEQUALS_ALIAS);
        EvaluatorRegistry.registerEvaluator(new VersionEvaluator(new IVersionResultConverter(){

            @Override
            public boolean convert(int value) {
                return value < 0;
            }
        }), VersionType.LESS);
        EvaluatorRegistry.registerEvaluator(new VersionEvaluator(new IVersionResultConverter(){

            @Override
            public boolean convert(int value) {
                return value <= 0;
            }
        }), VersionType.LESS_EQUALS);
        EvaluatorRegistry.registerEvaluator(new VersionEvaluator(new IVersionResultConverter(){

            @Override
            public boolean convert(int value) {
                return value > 0;
            }
        }), VersionType.GREATER);
        EvaluatorRegistry.registerEvaluator(new VersionEvaluator(new IVersionResultConverter(){

            @Override
            public boolean convert(int value) {
                return value >= 0;
            }
        }), VersionType.GREATER_EQUALS);
    }

    private static final class VersionEvaluator
    implements IOperationEvaluator {
        private IVersionResultConverter converter;

        private VersionEvaluator(IVersionResultConverter converter) {
            this.converter = converter;
        }

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            Value aValue;
            ConstantAccessor result = null;
            Value oValue = operand.getValue();
            if (oValue instanceof VersionValue && 1 == arguments.length && (aValue = arguments[0].getValue()) instanceof VersionValue) {
                BooleanValue tmp = BooleanValue.toBooleanValue(this.converter.convert(Version.compare(((VersionValue)oValue).getValue(), ((VersionValue)aValue).getValue())));
                result = ConstantAccessor.POOL.getInstance().bind(tmp, true, operand.getContext());
            }
            return result;
        }
    }

    private static interface IVersionResultConverter {
        public boolean convert(int var1);
    }
}

