/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.management;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class CommentResource {
    private static final char ESCAPE = '\\';
    private static final char SEPARATOR = '=';
    private Map<String, String> mapping = new HashMap<String, String>();

    public void load(Reader reader) throws IOException {
        String line;
        LineNumberReader lnr = new LineNumberReader(reader);
        do {
            if (null == (line = lnr.readLine())) continue;
            int pos = 0;
            int sepPos = -1;
            boolean lastIsEscape = false;
            while (pos < line.length() && sepPos < 0) {
                char c;
                if ('=' == (c = line.charAt(pos++)) && !lastIsEscape) {
                    sepPos = pos - 1;
                }
                lastIsEscape = c == '\\';
            }
            if (sepPos <= 0) continue;
            String key = line.substring(0, sepPos).trim();
            String value = line.substring(sepPos + 1).trim();
            this.mapping.put(key, value);
        } while (null != line);
    }

    public void store(Writer writer) throws IOException {
        PrintWriter out = new PrintWriter(writer);
        out.println("# generated by IVML core at " + Calendar.getInstance());
        for (Map.Entry<String, String> ent : this.mapping.entrySet()) {
            out.print(ent.getKey());
            out.print('=');
            out.println(ent.getValue());
        }
    }

    public void clear() {
        this.mapping.clear();
    }

    public boolean isEmpty() {
        return this.mapping.isEmpty();
    }

    public String get(String key) {
        return this.mapping.get(key);
    }

    public void put(String key, String value) {
        this.mapping.put(key, value);
    }

    public void remove(String key) {
        this.mapping.remove(key);
    }

    public boolean containsKey(String key) {
        return this.mapping.containsKey(key);
    }

    public String toString() {
        return this.mapping.toString();
    }
}

