/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.management;

import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.messages.IMessage;
import net.ssehub.easy.basics.messages.Message;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;

class DefaultImportResolver
extends net.ssehub.easy.basics.modelManagement.DefaultImportResolver<Project> {
    DefaultImportResolver() {
        super(true);
        EASyLoggerFactory.EASyLogger logger = EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.varModel");
        logger.info("Model.DefaultImportResolver registered");
    }

    @Override
    protected boolean checkImported(ModelImport<Project> imp, Project model, List<IMessage> messages) {
        boolean isOk = true;
        if (!imp.isConflict() && imp instanceof ProjectImport) {
            boolean impHasInterfaces;
            ProjectImport pImp = (ProjectImport)imp;
            boolean projectHasInterfaces = model.hasInterfaces();
            boolean bl = impHasInterfaces = !DefaultImportResolver.isEmptyOrNull(pImp.getInterfaceName());
            if (projectHasInterfaces && !impHasInterfaces) {
                messages.add(new Message("import for project '" + imp.getName() + "' does not refer to an interface but project declares interfaces", Status.ERROR));
                isOk = false;
            } else if (!projectHasInterfaces && impHasInterfaces) {
                messages.add(new Message("import for project '" + imp.getName() + "' refers to an interface but project does not declare interfaces", Status.ERROR));
                isOk = false;
            }
        }
        return isOk;
    }

    private static boolean isEmptyOrNull(String text) {
        return null == text || 0 == text.length();
    }
}

