/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.management;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import net.ssehub.easy.basics.modelManagement.IModelManagementRepository;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.Utils;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.management.CommentResource;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.IDecisionVariableContainer;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.persistency.StringProvider;

public class ModelCommentsPersistencer {
    private IModelManagementRepository<Project> repository;

    ModelCommentsPersistencer(IModelManagementRepository<Project> repository) {
        this.repository = repository;
    }

    public synchronized boolean storeComments(ModelInfo<Project> info) throws IOException {
        return this.storeComments(info, false);
    }

    public synchronized boolean storeComments(ModelInfo<Project> info, boolean considerImports) throws IOException {
        URI resourceUri;
        boolean done = false;
        Project project = info.getResolved();
        if (null != project && null != (resourceUri = info.getCommentsResource())) {
            File resourceFile = new File(resourceUri);
            CommentResource props = new CommentResource();
            int size = project.getElementCount();
            for (int c = 0; c < size; ++c) {
                ContainableModelElement element = project.getElement(c);
                String qName = element.getQualifiedName();
                if (null == qName) continue;
                props.put(qName, element.getComment());
            }
            FileWriter fw = new FileWriter(resourceFile);
            try {
                props.store(fw);
            }
            catch (IOException e) {
                try {
                    fw.close();
                }
                catch (IOException qName) {
                    // empty catch block
                }
                throw e;
            }
            fw.close();
            size = project.getImportsCount();
            for (int i = 0; i < size; ++i) {
                ProjectImport imp = project.getImport(i);
                if (imp.isConflict()) continue;
                this.storeComments(this.repository.getResolvedModelInfo((Project)imp.getResolved()));
            }
            done = true;
        }
        return done;
    }

    void loadComments(ModelInfo<Project> info) throws IOException {
        CommentResource props;
        Project project = info.getResolved();
        if (null != project && null != (props = ModelCommentsPersistencer.getComments(info))) {
            this.assignCommentsToProject(project, props);
        }
    }

    public static CommentResource getComments(Project project) throws IOException {
        ModelInfo<Project> info;
        CommentResource props = null;
        if (null != project && null != (info = VarModel.INSTANCE.availableModels().getModelInfo(project))) {
            props = ModelCommentsPersistencer.getComments(info);
        }
        return props;
    }

    private static CommentResource getComments(ModelInfo<Project> info) throws IOException {
        File baseFile;
        CommentResource props = null;
        File resourceFile = Utils.toExistingFile(info.getCommentsResource());
        if (null == resourceFile) {
            resourceFile = Utils.toExistingFile(info.getDefaultCommentsResource());
        }
        if (null == (baseFile = Utils.toExistingFile(info.getBaseCommentsResource()))) {
            baseFile = Utils.toExistingFile(info.getDefaultBaseCommentsResource());
        }
        if (null != resourceFile || null != baseFile) {
            props = new CommentResource();
            ModelCommentsPersistencer.readResourceFromFile(props, baseFile);
            ModelCommentsPersistencer.readResourceFromFile(props, resourceFile);
        }
        return props;
    }

    private static void readResourceFromFile(CommentResource resource, File file) throws IOException {
        if (null != file) {
            FileReader fr = new FileReader(file);
            try {
                resource.load(fr);
            }
            catch (IOException e) {
                try {
                    fr.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw e;
            }
            fr.close();
        }
    }

    private void assignCommentsToProject(Project project, CommentResource props) {
        int size = project.getElementCount();
        for (int c = 0; c < size; ++c) {
            ContainableModelElement element = project.getElement(c);
            this.assignComment(element, props);
            if (!(element instanceof IDecisionVariableContainer)) continue;
            this.assignComments((IDecisionVariableContainer)((Object)element), props);
        }
    }

    private void assignComments(IDecisionVariableContainer container, CommentResource props) {
        for (int e = 0; e < container.getElementCount(); ++e) {
            this.assignComment(container.getElement(e), props);
        }
        for (int a = 0; a < container.getAssignmentCount(); ++a) {
            this.assignComments(container.getAssignment(a), props);
        }
    }

    private void assignComment(ContainableModelElement elt, CommentResource props) {
        String tmp;
        String comment = "";
        String qName = elt.getQualifiedName();
        if (elt instanceof Constraint) {
            qName = ModelCommentsPersistencer.getKey((Constraint)elt);
        }
        if (null != qName && null != (tmp = props.get(qName))) {
            comment = tmp;
        }
        elt.setComment(comment);
    }

    public static String getKey(Constraint cons) {
        ConstraintSyntaxTree cst;
        String key = "";
        if (null != cons && null != (cst = cons.getConsSyntax())) {
            key = StringProvider.toIvmlString(cst).replace(" ", "").replace("=", "\\=");
        }
        return key;
    }
}

