/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.management;

import java.io.IOException;
import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.ImportResolver;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelManagement;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.modelManagement.ModelRepository;
import net.ssehub.easy.varModel.management.DefaultImportResolver;
import net.ssehub.easy.varModel.management.ModelCommentsPersistencer;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;

public class VarModel
extends ModelManagement<Project> {
    public static final VarModel INSTANCE = new VarModel();
    private ModelCommentsPersistencer comments = new ModelCommentsPersistencer(this.repository());

    private VarModel() {
    }

    @Override
    protected ModelRepository<Project> createRepository() {
        return new IvmlModelRepository(this);
    }

    public ModelCommentsPersistencer comments() {
        return this.comments;
    }

    @Override
    protected void postLoadModel(ModelInfo<Project> info) throws IOException {
        this.comments.loadComments(info);
    }

    @Override
    protected ImportResolver<Project> createResolver() {
        return new DefaultImportResolver();
    }

    private static class IvmlModelRepository
    extends ModelRepository<Project> {
        protected IvmlModelRepository(ModelManagement<Project> modelMgmt) {
            super(modelMgmt);
        }

        @Override
        public Project createModel(String modelName, List<Project> imports) {
            Project result = new Project(modelName);
            for (Project p : imports) {
                try {
                    ProjectImport imp = new ProjectImport(p.getName(), null, false, false, null, false);
                    imp.setResolved(p);
                    result.addImport(imp);
                }
                catch (ModelManagementException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(VarModel.class, "net.ssehub.easy.varModel").error("While creating ad-hoc model " + modelName + ": " + e.getMessage());
                }
            }
            return result;
        }
    }
}

