/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model;

import java.util.HashSet;
import java.util.Set;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.filter.FilterType;

public abstract class AbstractProjectVisitor
implements IModelVisitor {
    private Project originProject;
    private FilterType filterType;
    private Set<Project> done = new HashSet<Project>();

    protected AbstractProjectVisitor(Project originProject, FilterType filterType) {
        this.originProject = originProject;
        this.filterType = filterType;
    }

    @Override
    public void visitProjectImport(ProjectImport pImport) {
        if (null != pImport.getResolved()) {
            ((Project)pImport.getResolved()).accept(this);
        }
    }

    @Override
    public void visitProject(Project project) {
        if (!this.done.contains(project)) {
            boolean noImports;
            this.done.add(project);
            boolean importedProject = this.originProject != project;
            for (int i = 0; i < project.getImportsCount(); ++i) {
                project.getImport(i).accept(this);
            }
            boolean anyProject = FilterType.ALL == this.filterType;
            boolean onlyImports = FilterType.ONLY_IMPORTS == this.filterType && importedProject;
            boolean bl = noImports = FilterType.NO_IMPORTS == this.filterType && !importedProject;
            if (anyProject || onlyImports || noImports) {
                for (int i = 0; i < project.getElementCount(); ++i) {
                    project.getElement(i).accept(this);
                }
            }
        }
    }

    protected Project getStartingProject() {
        return this.originProject;
    }

    protected FilterType getFilterType() {
        return this.filterType;
    }

    protected void clear(Project originProject, FilterType filterType) {
        this.done.clear();
        if (null != originProject) {
            this.originProject = originProject;
        }
        if (null != filterType) {
            this.filterType = filterType;
        }
    }
}

