/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model;

import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;

public abstract class AbstractVisitor
implements IModelVisitor {
    @Override
    public void visitProject(Project project) {
        int count = project.getImportsCount();
        for (int p = 0; p < count; ++p) {
            project.getImport(p).accept(this);
        }
        count = project.getElementCount();
        for (int c = 0; c < count; ++c) {
            project.getElement(c).accept(this);
        }
    }

    @Override
    public void visitEnum(Enum eenum) {
        int count = eenum.getLiteralCount();
        for (int e = 0; e < count; ++e) {
            eenum.getLiteral(e).accept(this);
        }
    }

    @Override
    public void visitOrderedEnum(OrderedEnum eenum) {
        int count = eenum.getLiteralCount();
        for (int e = 0; e < count; ++e) {
            eenum.getLiteral(e).accept(this);
        }
    }

    @Override
    public void visitCompound(Compound compound) {
        int count = compound.getElementCount();
        for (int e = 0; e < count; ++e) {
            compound.getElement(e).accept(this);
        }
        count = compound.getConstraintsCount();
        for (int c = 0; c < count; ++c) {
            compound.getConstraint(c).accept(this);
        }
    }
}

