/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model;

import java.util.HashSet;
import java.util.Set;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.IAttributableElement;
import net.ssehub.easy.varModel.model.IAttributeAccess;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IvmlException;

public abstract class AnnotationVisitor {
    protected abstract void processAttributeAssignment(AttributeAssignment var1) throws IvmlException;

    protected abstract void processAttribute(Attribute var1) throws IvmlException;

    protected void addToScope(Set<Object> scope, IModelElement element, IAttributeAccess access) {
        scope.add(element);
    }

    public void visitAnnotations(IAttributeAccess access) throws IvmlException {
        if (!(access instanceof Attribute)) {
            IModelElement parent;
            HashSet<Object> scope = new HashSet<Object>();
            scope.add(access);
            for (parent = access.getParent(); null != parent; parent = parent.getParent()) {
                this.addToScope(scope, parent, access);
                if (!(parent instanceof AttributeAssignment)) continue;
                this.processAttributeAssignment((AttributeAssignment)parent);
            }
            this.visitAnnotations(access, scope);
            for (parent = access.getParent(); null != parent; parent = parent.getParent()) {
                if (!(parent instanceof IAttributeAccess)) continue;
                this.visitAnnotations((IAttributeAccess)((Object)parent), scope);
            }
        }
    }

    private void visitAnnotations(IAttributeAccess access, Set<Object> scope) throws IvmlException {
        for (int a = 0; a < access.getAttributesCount(); ++a) {
            Attribute attr = access.getAttribute(a);
            IAttributableElement elt = attr.getElement();
            if (null != elt && !scope.contains(elt)) continue;
            this.processAttribute(access.getAttribute(a));
        }
    }
}

