/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.EvaluationBlock;
import net.ssehub.easy.varModel.model.IDecisionVariableContainer;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.filter.DeclarationInContainerFinder;

public class BasicDecisionVariableContainer
extends ModelElement
implements IDecisionVariableContainer {
    private List<DecisionVariableDeclaration> elements = new ArrayList<DecisionVariableDeclaration>();
    private List<Constraint> constraints = new ArrayList<Constraint>();
    private List<AttributeAssignment> assignments = null;
    private List<ContainableModelElement> modelElements = new ArrayList<ContainableModelElement>();
    private Set<String> names = new HashSet<String>();
    private List<DecisionVariableDeclaration> allDeclarations = null;

    public BasicDecisionVariableContainer() {
        super(null);
    }

    @Override
    public void sortContainedElements(Comparator<ContainableModelElement> comp) {
        assert (null != comp);
        int size = this.modelElements.size();
        Collections.sort(this.modelElements, comp);
        assert (this.modelElements.size() == size);
    }

    @Override
    public void add(AttributeAssignment assignment) {
        assert (null != assignment);
        if (null == this.assignments) {
            this.assignments = new ArrayList<AttributeAssignment>();
        }
        this.assignments.add(assignment);
        this.modelElements.add(assignment);
        this.allDeclarations = null;
    }

    @Override
    public void forceUpdate() {
        this.allDeclarations = null;
        int end = this.modelElements.size();
        for (int i = 0; i < end; ++i) {
            ContainableModelElement element = this.modelElements.get(i);
            if (!(element instanceof IDecisionVariableContainer)) continue;
            ((IDecisionVariableContainer)((Object)element)).forceUpdate();
        }
    }

    @Override
    public void add(EvaluationBlock eval) {
        assert (null != eval);
        this.modelElements.add(eval);
    }

    @Override
    public int getAssignmentCount() {
        return null == this.assignments ? 0 : this.assignments.size();
    }

    @Override
    public AttributeAssignment getAssignment(int index) {
        if (null == this.assignments) {
            throw new IndexOutOfBoundsException();
        }
        return this.assignments.get(index);
    }

    @Override
    public ContainableModelElement getModelElement(int index) {
        return this.modelElements.get(index);
    }

    @Override
    public int getModelElementCount() {
        return this.modelElements.size();
    }

    @Override
    public DecisionVariableDeclaration getElement(String name) {
        DecisionVariableDeclaration result = null;
        for (int e = 0; null == result && e < this.elements.size(); ++e) {
            DecisionVariableDeclaration element = this.elements.get(e);
            if (null == element || !element.getName().equals(name) && !element.getQualifiedName().equals(name)) continue;
            result = element;
        }
        if (null == result) {
            for (int a = 0; null == result && a < this.getAssignmentCount(); ++a) {
                result = this.getAssignment(a).getElement(name);
            }
        }
        return result;
    }

    @Override
    public boolean contains(DecisionVariableDeclaration var) {
        boolean found = this.containsByName(var.getName());
        for (int e = 0; !found && e < this.elements.size(); ++e) {
            found = this.elements.get(e).isSame(var);
        }
        for (int a = 0; !found && a < this.getAssignmentCount(); ++a) {
            found = this.getAssignment(a).contains(var);
        }
        return found;
    }

    @Override
    public boolean containsByName(String name) {
        return null != name && this.names.contains(name);
    }

    @Override
    public void add(Comment comment) {
        if (null != comment) {
            this.modelElements.add(comment);
        }
    }

    @Override
    public int getElementCount() {
        return this.elements.size();
    }

    @Override
    public DecisionVariableDeclaration getElement(int index) {
        return this.elements.get(index);
    }

    @Override
    public boolean add(DecisionVariableDeclaration elem) {
        assert (null != elem);
        boolean found = this.contains(elem);
        if (!found) {
            this.names.add(elem.getName());
            this.elements.add(elem);
            this.modelElements.add(elem);
            this.allDeclarations = null;
        }
        return !found;
    }

    @Override
    public int getConstraintsCount() {
        return null == this.constraints ? 0 : this.constraints.size();
    }

    @Override
    public Constraint getConstraint(int index) {
        if (null == this.constraints) {
            throw new IndexOutOfBoundsException();
        }
        return this.constraints.get(index);
    }

    @Override
    public void addConstraint(Constraint constraint, boolean internal) {
        assert (null != constraint);
        if (null == this.constraints) {
            this.constraints = new ArrayList<Constraint>();
        }
        this.constraints.add(constraint);
        this.modelElements.add(constraint);
        this.allDeclarations = null;
    }

    @Override
    public int getRealizingCount() {
        return 0;
    }

    @Override
    public Constraint getRealizing(int index) {
        throw new IndexOutOfBoundsException("no elements");
    }

    @Override
    public boolean propagateAttribute(Attribute attribute) {
        boolean successful = true;
        for (int e = 0; e < this.elements.size(); ++e) {
            successful &= this.elements.get(e).propagateAttribute(attribute);
        }
        if (null != this.assignments) {
            for (int a = 0; a < this.assignments.size(); ++a) {
                successful &= this.assignments.get(a).propagateAttribute(attribute);
            }
        }
        return successful;
    }

    @Override
    public void accept(IModelVisitor visitor) {
    }

    @Override
    public int getDeclarationCount() {
        if (null == this.allDeclarations) {
            this.allDeclarations = new ArrayList<DecisionVariableDeclaration>();
            for (int i = 0; i < this.modelElements.size(); ++i) {
                DeclarationInContainerFinder finder = new DeclarationInContainerFinder(this.modelElements.get(i));
                this.allDeclarations.addAll(finder.getDeclarations());
            }
        }
        return this.allDeclarations.size();
    }

    @Override
    public DecisionVariableDeclaration getDeclaration(int index) {
        return this.allDeclarations.get(index);
    }

    public boolean removeModelElement(ContainableModelElement element) {
        boolean found = false;
        if (null != element) {
            if (element instanceof Constraint) {
                found = this.constraints.remove(element);
            } else if (element instanceof DecisionVariableDeclaration) {
                found = this.elements.remove(element);
                if (found) {
                    this.allDeclarations = null;
                }
            } else if (element instanceof AttributeAssignment) {
                found = this.assignments.remove(element);
            }
            if (found) {
                found |= this.modelElements.remove(element);
            }
        }
        return found;
    }

    @Override
    public String toString() {
        return this.modelElements.toString();
    }
}

